/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMerger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MergingFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    private ModelMerger myMerger;

    protected MergingFileDescription(Class<T> rootElementClass, @NonNls String rootTagName) {
        super(rootElementClass, rootTagName, new String[0]);
    }

    @NotNull
    protected abstract Set<XmlFile> getFilesToMerge(DomElement var1);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DomElement getResolveScope(GenericDomValue<?> reference) {
        DomElement domElement;
        DomElement annotation = this.getScopeFromAnnotation(reference);
        if (annotation != null) {
            domElement = annotation;
            if (domElement == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/MergingFileDescription.getResolveScope must not return null");
            return domElement;
        }
        DomFileElement element = DomUtil.getFileElement(reference);
        domElement = this.getMergedRoot(element);
        if (domElement != null) return domElement;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/MergingFileDescription.getResolveScope must not return null");
    }

    public final T getMergedRoot(DomFileElement<T> element) {
        DomFileElement originalElement;
        DomManager domManager = element.getManager();
        XmlFile xmlFile = element.getFile();
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        files.add(xmlFile);
        XmlFile originalFile = (XmlFile)xmlFile.getOriginalFile();
        if (originalFile != xmlFile && (originalElement = domManager.getFileElement(originalFile)) != null) {
            element = originalElement;
        }
        files.addAll(this.getFilesToMerge(element));
        ArrayList roots = new ArrayList(files.size());
        for (XmlFile file : files) {
            DomFileElement fileElement = domManager.getFileElement(file);
            if (fileElement == null) continue;
            roots.add(fileElement.getRootElement());
        }
        if (roots.size() == 1) {
            return (T)((DomElement)roots.iterator().next());
        }
        if (this.myMerger == null) {
            this.myMerger = DomService.getInstance().createModelMerger();
        }
        return (T)((DomElement)this.myMerger.mergeModels(this.getRootElementClass(), roots));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        void var5_6;
        DomElement domElement;
        DomElement annotation = this.getScopeFromAnnotation(element);
        if (annotation != null) {
            domElement = annotation;
            if (domElement == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/MergingFileDescription.getIdentityScope must not return null");
            return domElement;
        }
        List<JavaMethod> methods = DomUtil.getFixedPath(element.getParent());
        if (methods == null) {
            domElement = super.getIdentityScope(element);
            if (domElement == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/MergingFileDescription.getIdentityScope must not return null");
            return domElement;
        }
        DomFileElement root = DomUtil.getFileElement(element);
        Object t = this.getMergedRoot(root);
        for (JavaMethod method : methods) {
            Object object = method.invoke(var5_6, ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        domElement = (DomElement)var5_6;
        if (domElement != null) return domElement;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/MergingFileDescription.getIdentityScope must not return null");
    }

    @Override
    public boolean isAutomaticHighlightingEnabled() {
        return false;
    }
}

