/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.UI;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class LinkLabel
extends JLabel {
    private boolean myUnderline;
    private LinkListener myLinkListener;
    private Object myLinkData;
    private static final Set ourVisitedLinks = new HashSet();
    private boolean myIsLinkActive;
    private String myVisitedLinksKey;
    private int myIconWidth;
    private Icon myHoveringIcon;
    private Icon myInactiveIcon;
    private boolean myClickIsBeingProcessed;
    private boolean myPaintDefaultIcon;
    protected static final int DEFAULT_ICON_GAP = 2;
    private static final Icon LINK = IconLoader.getIcon((String)"/ide/link.png");

    public LinkLabel() {
        this("", LINK);
    }

    public LinkLabel(String text, Icon icon) {
        this(text, icon, null, null, null);
    }

    public LinkLabel(String text, Icon icon, LinkListener aListener) {
        this(text, icon, aListener, null, null);
    }

    public LinkLabel(String text, Icon icon, LinkListener aListener, Object aLinkData) {
        this(text, icon, aListener, aLinkData, null);
    }

    public LinkLabel(String text, Icon icon, LinkListener aListener, Object aLinkData, String aVisitedLinksKey) {
        super(text, icon, 2);
        this.setOpaque(false);
        this.setListener(aListener, aLinkData);
        this.myIconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        this.myInactiveIcon = this.getIcon();
        MyMouseHandler mouseHandler = new MyMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.myVisitedLinksKey = aVisitedLinksKey;
    }

    public void setHoveringIcon(Icon iconForHovering) {
        this.myHoveringIcon = iconForHovering;
    }

    public void setListener(LinkListener listener, Object linkData) {
        this.myLinkListener = listener;
        this.myLinkData = linkData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClick() {
        if (this.myClickIsBeingProcessed) {
            return;
        }
        try {
            this.myClickIsBeingProcessed = true;
            if (this.myLinkListener != null) {
                this.myLinkListener.linkSelected(this, this.myLinkData);
            }
            ourVisitedLinks.add(this.myVisitedLinksKey);
            this.repaint();
        }
        finally {
            this.myClickIsBeingProcessed = false;
        }
    }

    public boolean isVisited() {
        return this.myVisitedLinksKey != null && ourVisitedLinks.contains(this.myVisitedLinksKey);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Border border = this.getBorder();
        int shiftX = 0;
        int shiftY = 0;
        if (border != null) {
            shiftX = border.getBorderInsets((Component)this).left;
            shiftY = border.getBorderInsets((Component)this).top;
        }
        this.setForeground(this.getActiveColor());
        super.paintComponent(g);
        if (this.getText() != null) {
            g.setColor(this.getActiveColor());
            int x = this.myIconWidth;
            int y = this.getTextBaseLine();
            if (this.myUnderline) {
                int lineY;
                int k = 1;
                if (this.getFont().getSize() > 11) {
                    k += this.getFont().getSize() - 11;
                }
                if ((lineY = (y += k) + shiftY) >= this.getSize().height) {
                    lineY = this.getSize().height - 1;
                }
                if (this.getHorizontalAlignment() == 2) {
                    UIUtil.drawLine((Graphics)g, (int)(x + shiftX), (int)lineY, (int)(x + this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + shiftX), (int)lineY);
                } else {
                    UIUtil.drawLine((Graphics)g, (int)(this.getWidth() - 1 - this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + shiftX), (int)lineY, (int)(this.getWidth() - 1 + shiftX), (int)lineY);
                }
            }
            if (this.myPaintDefaultIcon) {
                int endX = this.myIconWidth + this.getFontMetrics(this.getFont()).stringWidth(this.getText());
                int endY = this.getHeight() / 2 - LINK.getIconHeight() / 2 + 1;
                LINK.paintIcon(this, g, endX + shiftX + 2, endY);
            }
        }
    }

    private Color getActiveColor() {
        return this.myIsLinkActive ? LinkLabel.getActive() : (this.isVisited() ? LinkLabel.getVisited() : LinkLabel.getNormal());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = size.width + (this.myPaintDefaultIcon ? LINK.getIconWidth() + 2 : 0);
        return size;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.disableUnderline();
    }

    private void setActive(boolean isActive) {
        this.myIsLinkActive = isActive;
        this.onSetActive(this.myIsLinkActive);
        this.repaint();
    }

    protected void onSetActive(boolean active) {
    }

    private int getTextBaseLine() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return this.getHeight() / 2 + (fm.getHeight() / 2 - fm.getDescent());
    }

    private boolean isInClickableArea(Point pt) {
        if (this.getIcon() != null && pt.getX() < (double)this.getIcon().getIconWidth() && pt.getY() < (double)this.getIcon().getIconHeight()) {
            return true;
        }
        if (this.getText() != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int height = fm.getHeight() + 1;
            int y = this.getHeight() / 2 - fm.getHeight() / 2;
            int width = fm.stringWidth(this.getText());
            if (this.myPaintDefaultIcon) {
                width += LINK.getIconWidth() + 2;
            }
            if (this.getHorizontalAlignment() == 2) {
                return new Rectangle(this.myIconWidth, y, width, height).contains(pt);
            }
            return new Rectangle(this.getWidth() - width - 1, y, this.getWidth() - 1, height).contains(pt);
        }
        return false;
    }

    private void enableUnderline() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.myUnderline = true;
        if (this.myHoveringIcon != null) {
            this.setIcon(this.myHoveringIcon);
        }
        this.setStatusBarText(this.getStatusBarText());
        this.repaint();
    }

    protected String getStatusBarText() {
        return this.getToolTipText();
    }

    private void disableUnderline() {
        this.setCursor(Cursor.getDefaultCursor());
        this.myUnderline = false;
        this.setIcon(this.myInactiveIcon);
        this.setStatusBarText(null);
        this.setActive(false);
    }

    private void setStatusBarText(String statusBarText) {
        Project[] projects;
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            StatusBar bar = WindowManager.getInstance().getStatusBar(project);
            if (bar == null) continue;
            bar.setInfo(statusBarText);
        }
    }

    public static void clearVisitedHistory() {
        ourVisitedLinks.clear();
    }

    private static Color getVisited() {
        return UI.getColor("link.visited.foreground");
    }

    private static Color getActive() {
        return UI.getColor("link.pressed.foreground");
    }

    private static Color getNormal() {
        return UI.getColor("link.foreground");
    }

    public void entered(MouseEvent e) {
        this.enableUnderline();
    }

    public void exited(MouseEvent e) {
        this.disableUnderline();
    }

    public void pressed(MouseEvent e) {
        this.doClick();
    }

    public void setDefaultIconPainted(boolean paintDefaultIcon) {
        this.myPaintDefaultIcon = paintDefaultIcon;
    }

    private class MyMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MyMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint()) && e.getClickCount() == 1) {
                LinkLabel.this.doClick();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.setActive(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LinkLabel.this.setActive(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.enableUnderline();
            } else {
                LinkLabel.this.disableUnderline();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkLabel.this.disableUnderline();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

