/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatVariable(PsiVariable variable, int options, PsiSubstitutor substitutor) {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor, buffer);
        return buffer.toString();
    }

    private static void formatVariable(PsiVariable variable, int options, PsiSubstitutor substitutor, StringBuilder buffer) {
        PsiExpression initializer;
        String name;
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if (variable instanceof PsiField && (options & 0x1000) != 0) {
            String className;
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null && (className = aClass.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if ((options & 0x800) != 0) {
                    String qName = aClass.getQualifiedName();
                    if (qName != null) {
                        buffer.append(qName);
                    } else {
                        buffer.append(className);
                    }
                } else {
                    buffer.append(className);
                }
                buffer.append('.');
            }
            if ((options & 1) != 0) {
                buffer.append(variable.getName());
            }
        } else if ((options & 1) != 0 && (name = variable.getName()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name);
        }
        if ((options & 2) != 0 && (options & 4) != 0) {
            if ((options & 1) != 0 && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 0x80) != 0 && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = initializer.getText();
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text.substring(0, index));
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(PsiMethod method, PsiSubstitutor substitutor, int options, int parameterOptions) {
        return PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, 7);
    }

    public static String formatMethod(PsiMethod method, PsiSubstitutor substitutor, int options, int parameterOptions, int maxParametersToShow) {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(PsiMethod method, PsiSubstitutor substitutor, int options, int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type;
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0 && (type = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 0x1000) != 0) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name = aClass.getName();
                if (name != null) {
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(name);
                        }
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if ((options & 1) != 0) {
                buffer.append(method.getName());
            }
        } else if ((options & 1) != 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        if ((options & 0x100) != 0) {
            buffer.append('(');
            PsiParameter[] parms = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(parms.length, maxParametersToShow); ++i) {
                PsiParameter parm = parms[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(parm, parameterOptions, substitutor));
            }
            if (parms.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if ((options & 2) != 0 && (options & 4) != 0 && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 0x200) != 0 && (throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).length() > 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ");
            buffer.append(throwsText);
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, int options) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiFormatUtil.formatClass must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if ((options & 1) != 0) {
            if (aClass instanceof PsiAnonymousClass && (options & 0x8000) != 0) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if ((options & 0x400) != 0) {
            String implementsText;
            String extendsText = PsiFormatUtil.formatReferenceList(aClass.getExtendsList(), options);
            if (extendsText.length() > 0) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ");
                buffer.append(extendsText);
            }
            if ((implementsText = PsiFormatUtil.formatReferenceList(aClass.getImplementsList(), options)).length() > 0) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ");
                buffer.append(implementsText);
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiFormatUtil.formatClass must not return null");
        }
        return string;
    }

    public static String formatModifiers(PsiElement element, int options) throws IllegalArgumentException {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        return buffer.toString();
    }

    private static void formatModifiers(PsiElement element, int options, StringBuilder buffer) throws IllegalArgumentException {
        PsiModifierList list;
        boolean isInterface = false;
        if (element instanceof PsiVariable) {
            list = ((PsiVariable)element).getModifierList();
        } else if (element instanceof PsiMethod) {
            list = ((PsiMethod)element).getModifierList();
        } else if (element instanceof PsiClass) {
            isInterface = ((PsiClass)element).isInterface();
            list = ((PsiClass)element).getModifierList();
            if (list == null) {
                return;
            }
        } else if (element instanceof PsiClassInitializer) {
            list = ((PsiClassInitializer)element).getModifierList();
            if (list == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            return;
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("public") : list.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("packageLocal") : list.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.visibilityPresentation("packageLocal"));
            }
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("static") : list.hasModifierProperty("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        if (!isInterface && ((options & 0x20) == 0 ? list.hasExplicitModifier("abstract") : list.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("final") : list.hasModifierProperty("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    public static String formatReferenceList(PsiReferenceList list, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiJavaCodeReferenceElement[] refs = list.getReferenceElements();
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(PsiFormatUtil.formatReference(ref, options));
        }
        return buffer.toString();
    }

    public static String formatType(PsiType type, int options, PsiSubstitutor substitutor) {
        type = substitutor.substitute(type);
        if ((options & 0x10000) != 0) {
            type = TypeConversionUtil.erasure(type);
        }
        return (options & 0x2000) == 0 ? type.getPresentableText() : type.getInternalCanonicalText();
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return (options & 0x2000) == 0 ? ref.getText() : ref.getCanonicalText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, false);
        assert (psiClass != null);
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(" ");
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, 7, builder);
            return builder.toString();
        } else if (owner instanceof PsiField) {
            builder.append(" ").append(((PsiField)owner).getName());
            return builder.toString();
        } else {
            if (!(owner instanceof PsiParameter)) return null;
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) return null;
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(" ");
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, 7, builder);
            builder.append(" ");
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
                return builder.toString();
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiFormatUtil.getPackageDisplayName must not be null");
        }
        String packageName = psiClass.getQualifiedName();
        String string = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.length() == 0) {
            packageName = "default package";
        }
        return packageName;
    }
}

