/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiBundle;

public enum LanguageLevel {
    JDK_1_3("1.3 ", false, false),
    JDK_1_4(PsiBundle.message("jdk.1.4.language.level.description", new Object[0]), true, false),
    JDK_1_5(PsiBundle.message("jdk.1.5.language.level.description", new Object[0]), true, true),
    JDK_1_6(PsiBundle.message("jdk.1.6.language.level.description", new Object[0]), true, true),
    JDK_1_7(PsiBundle.message("jdk.1.7.language.level.description", new Object[0]), true, true);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final boolean myHasAssertKeyword;
    private final boolean myHasEnumKeywordAndAutoboxing;
    private final String myPresentableText;

    private LanguageLevel(String presentableText, boolean hasAssertKeyword, boolean hasEnumKeywordAndAutoboxing) {
        this.myHasAssertKeyword = hasAssertKeyword;
        this.myHasEnumKeywordAndAutoboxing = hasEnumKeywordAndAutoboxing;
        this.myPresentableText = presentableText;
    }

    public int getIndex() {
        return this.ordinal() + 3;
    }

    public boolean hasAssertKeyword() {
        return this.myHasAssertKeyword;
    }

    public boolean hasEnumKeywordAndAutoboxing() {
        return this.myHasEnumKeywordAndAutoboxing;
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    public boolean isAtLeast(LanguageLevel level) {
        return this.compareTo(level) >= 0;
    }

    static {
        HIGHEST = JDK_1_7;
        KEY = Key.create((String)"LANGUGAGE_LEVEL");
    }
}

