/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.KeyEventProcessor;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class FocusCommand
extends ActiveRunnable
implements Expirable {
    private Component myDominationComponent;
    private Throwable myAllocation;
    private ActionCallback myCallback;

    protected FocusCommand() {
    }

    protected FocusCommand(Component dominationComp) {
        this.myDominationComponent = dominationComp;
    }

    protected FocusCommand(Object object) {
        super(object);
    }

    protected FocusCommand(Object object, Component dominationComp) {
        super(object);
        this.myDominationComponent = dominationComp;
    }

    protected FocusCommand(Object[] objects) {
        super(objects);
    }

    protected FocusCommand(Object[] objects, Component dominationComp) {
        super(objects);
        this.myDominationComponent = dominationComp;
    }

    public final ActionCallback getCallback() {
        return this.myCallback;
    }

    public final void setCallback(ActionCallback callback) {
        this.myCallback = callback;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    public boolean canExecuteOnInactiveApp() {
        return false;
    }

    @Nullable
    public KeyEventProcessor getProcessor() {
        return null;
    }

    @Nullable
    public final Component getDominationComponent() {
        return this.myDominationComponent;
    }

    public boolean dominatesOver(FocusCommand cmd) {
        Component thisComponent = PopupUtil.getOwner(this.getDominationComponent());
        Component thatComponent = PopupUtil.getOwner(cmd.getDominationComponent());
        if (thisComponent != null && thatComponent != null) {
            return thisComponent != thatComponent && SwingUtilities.isDescendingFrom(thisComponent, thatComponent);
        }
        return false;
    }

    public final FocusCommand saveAllocation() {
        if (Registry.is("ide.debugMode")) {
            this.myAllocation = new Exception();
        }
        return this;
    }

    public Throwable getAllocation() {
        return this.myAllocation;
    }

    public String toString() {
        Object[] objects = this.getEqualityObjects();
        return "FocusCommand objectCount=" + objects.length + " objects=" + Arrays.asList(objects);
    }

    public static class ByComponent
    extends FocusCommand {
        private Component myToFocus;

        public ByComponent(@Nullable Component toFocus) {
            this(toFocus, toFocus);
        }

        public ByComponent(@Nullable Component toFocus, @Nullable Component dominationComponent) {
            super(toFocus, dominationComponent);
            this.myToFocus = toFocus;
        }

        @Override
        public final ActionCallback run() {
            if (this.myToFocus != null && !this.myToFocus.requestFocusInWindow()) {
                this.myToFocus.requestFocus();
            }
            return new ActionCallback.Done();
        }

        @Override
        public boolean isExpired() {
            return this.myToFocus == null || SwingUtilities.getWindowAncestor(this.myToFocus) == null;
        }
    }
}

