/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Key;
import com.intellij.reference.SoftReference;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionService {
    private static final Key<SoftReference<CompletionProcess>> INVOLVED_IN_COMPLETION_KEY = Key.create((String)"INVOLVED_IN_COMPLETION_KEY");
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> SORTING_KEY = Key.create((String)"completionSorting");

    public static CompletionService getCompletionService() {
        return ServiceManager.getService(CompletionService.class);
    }

    @Nullable
    public abstract String getAdvertisementText();

    public abstract void setAdvertisementText(@Nullable String var1);

    public void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, Consumer<LookupElement> consumer) {
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        boolean dumb = DumbService.getInstance(parameters.getPosition().getProject()).isDumb();
        for (int i = contributors.indexOf(from) + 1; i < contributors.size(); ++i) {
            CompletionContributor contributor = contributors.get(i);
            if (dumb && !(contributor instanceof DumbAware)) continue;
            CompletionResultSet result = this.createResultSet(parameters, consumer, contributor);
            contributor.fillCompletionVariants(parameters, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    public abstract CompletionResultSet createResultSet(CompletionParameters var1, Consumer<LookupElement> var2, @NotNull CompletionContributor var3);

    @Nullable
    public abstract CompletionProcess getCurrentCompletion();

    public boolean prefixMatches(@NotNull LookupElement element, @NotNull PrefixMatcher matcher) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionService.prefixMatches must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionService.prefixMatches must not be null");
        }
        SoftReference data = (SoftReference)element.getUserData(INVOLVED_IN_COMPLETION_KEY);
        CompletionProcess currentCompletion = this.getCurrentCompletion();
        if (currentCompletion != null) {
            CompletionProcess oldCompletion;
            element.putUserData(INVOLVED_IN_COMPLETION_KEY, new SoftReference((Object)currentCompletion));
            if (data != null && (oldCompletion = (CompletionProcess)data.get()) != null && oldCompletion != currentCompletion) {
                return element.setPrefixMatcher(matcher);
            }
        } else {
            element.putUserData(INVOLVED_IN_COMPLETION_KEY, null);
        }
        return element.isPrefixMatched() || element.setPrefixMatcher(matcher);
    }

    @NotNull
    public LookupElement[] performCompletion(CompletionParameters parameters, final Consumer<LookupElement> consumer) {
        final LinkedHashSet lookupSet = new LinkedHashSet();
        this.getVariantsFromContributors(parameters, null, new Consumer<LookupElement>(){

            public void consume(final LookupElement lookupElement) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (lookupSet.add(lookupElement)) {
                            consumer.consume((Object)lookupElement);
                        }
                    }
                });
            }
        });
        LookupElement[] lookupElementArray = lookupSet.toArray(new LookupElement[lookupSet.size()]);
        if (lookupElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionService.performCompletion must not return null");
        }
        return lookupElementArray;
    }

    public abstract void correctCaseInsensitiveString(@NotNull LookupElement var1, InsertionContext var2);
}

