/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

public class IntArrayList
implements Cloneable {
    private int[] myData;
    private int mySize;

    public IntArrayList(int initialCapacity) {
        this.myData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public void trimToSize() {
        int oldCapacity = this.myData.length;
        if (this.mySize < oldCapacity) {
            int[] oldData = this.myData;
            this.myData = new int[this.mySize];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(int elem) {
        for (int i = 0; i < this.mySize; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int elem) {
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.myData = new int[this.mySize];
            System.arraycopy(this.myData, 0, v.myData, 0, this.mySize);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int[] toArray() {
        int[] result = new int[this.mySize];
        System.arraycopy(this.myData, 0, result, 0, this.mySize);
        return result;
    }

    public int[] toArray(int[] a) {
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        System.arraycopy(this.myData, 0, a, 0, this.mySize);
        return a;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        this.myData[index] = element;
        return oldValue;
    }

    public void add(int o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public void add(int index, int element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.myData[index] = element;
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }
}

