/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.Sync;

public class ReentrantLock
implements Sync {
    protected Thread owner_ = null;
    protected long holds_ = 0L;
    private Runnable myActionOnRelease = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() throws InterruptedException {
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.owner_) {
                ++this.holds_;
            } else {
                try {
                    while (this.owner_ != null) {
                        this.wait();
                    }
                    this.owner_ = caller;
                    this.holds_ = 1L;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
    }

    @Override
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1L;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.owner_) {
                        ++this.holds_;
                        return true;
                    }
                    if (this.owner_ != null) continue;
                    this.owner_ = caller;
                    this.holds_ = 1L;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
            if (this.myActionOnRelease != null) {
                Runnable action = this.myActionOnRelease;
                this.myActionOnRelease = null;
                action.run();
            }
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
            if (this.myActionOnRelease != null) {
                Runnable action = this.myActionOnRelease;
                this.myActionOnRelease = null;
                action.run();
            }
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }

    public synchronized void performActionWhenReleased(Runnable action) {
        if (this.holds() == 0L) {
            action.run();
        } else {
            this.myActionOnRelease = action;
        }
    }
}

