/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckBoxListListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class CheckBoxList
extends JList {
    private static final int DEFAULT_CHECK_BOX_WIDTH = 20;

    public CheckBoxList(ListModel dataModel, final CheckBoxListListener checkBoxListListener) {
        super(dataModel);
        this.setCellRenderer(new CellRenderer());
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    int[] indices;
                    for (int index : indices = CheckBoxList.this.getSelectedIndices()) {
                        if (index < 0) continue;
                        JCheckBox checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                        CheckBoxList.this.setSelected(checkbox, index, checkBoxListListener);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (CheckBoxList.this.isEnabled() && (index = CheckBoxList.this.locationToIndex(e.getPoint())) != -1) {
                    int iconArea;
                    JCheckBox checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                    try {
                        iconArea = ((BasicRadioButtonUI)checkbox.getUI()).getDefaultIcon().getIconWidth();
                    }
                    catch (ClassCastException c) {
                        iconArea = 20;
                    }
                    if (e.getX() < iconArea) {
                        CheckBoxList.this.setSelected(checkbox, index, checkBoxListListener);
                    }
                }
            }
        });
    }

    private void setSelected(JCheckBox checkbox, int index, CheckBoxListListener checkBoxListListener) {
        boolean value = !checkbox.isSelected();
        checkbox.setSelected(value);
        this.repaint();
        checkBoxListListener.checkBoxSelectionChanged(index, value);
    }

    protected Font getFont(JCheckBox checkbox) {
        return this.getFont();
    }

    protected Color getBackground(boolean isSelected, JCheckBox checkbox) {
        return isSelected ? this.getSelectionBackground() : this.getBackground();
    }

    protected Color getForeground(boolean isSelected, JCheckBox checkbox) {
        return isSelected ? this.getSelectionForeground() : this.getForeground();
    }

    private class CellRenderer
    implements ListCellRenderer {
        private Border mySelectedBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        private Border myBorder;

        private CellRenderer() {
            Insets borderInsets = this.mySelectedBorder.getBorderInsets(new JCheckBox());
            this.myBorder = new EmptyBorder(borderInsets);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            if (!UIUtil.isUnderNimbusLookAndFeel()) {
                checkbox.setBackground(CheckBoxList.this.getBackground(isSelected, checkbox));
                checkbox.setForeground(CheckBoxList.this.getForeground(isSelected, checkbox));
            }
            checkbox.setEnabled(CheckBoxList.this.isEnabled());
            checkbox.setFont(CheckBoxList.this.getFont(checkbox));
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? this.mySelectedBorder : this.myBorder);
            return checkbox;
        }
    }
}

