/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class ProperTextRange
extends TextRange {
    public ProperTextRange(int startOffset, int endOffset) {
        super(startOffset, endOffset);
        ProperTextRange.assertProperRange(this);
    }

    public ProperTextRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.<init> must not be null");
        }
        this(range.getStartOffset(), range.getEndOffset());
    }

    public static void assertProperRange(@NotNull TextRange range) throws AssertionError {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.assertProperRange must not be null");
        }
        assert (range.getStartOffset() <= range.getEndOffset()) : "Invalid range specified: " + range;
        assert (range.getStartOffset() >= 0) : "Negative start offset: " + range;
    }

    @Override
    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.cutOut must not be null");
        }
        TextRange range = super.cutOut(subRange);
        ProperTextRange.assertProperRange(range);
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.cutOut must not return null");
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange shiftRight(int offset) {
        TextRange range = super.shiftRight(offset);
        ProperTextRange.assertProperRange(range);
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.shiftRight must not return null");
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange grown(int lengthDelta) {
        TextRange range = super.grown(lengthDelta);
        ProperTextRange.assertProperRange(range);
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.grown must not return null");
        }
        return textRange;
    }

    @Override
    public ProperTextRange intersection(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.intersection must not be null");
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.intersection(textRange);
        if (range == null) {
            return null;
        }
        return new ProperTextRange(range);
    }

    @Override
    @NotNull
    public ProperTextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ProperTextRange.union must not be null");
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.union(textRange);
        ProperTextRange properTextRange = new ProperTextRange(range);
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ProperTextRange.union must not return null");
        }
        return properTextRange;
    }
}

