/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class EndOfLineCommentPredicate
implements PsiElementPredicate {
    private static final Pattern NO_INSPECTION_PATTERN = Pattern.compile("//[\t ]*noinspection .*");

    EndOfLineCommentPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        if (element instanceof PsiDocComment) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType type = comment.getTokenType();
        if (!JavaTokenType.END_OF_LINE_COMMENT.equals(type)) {
            return false;
        }
        String text = comment.getText();
        Matcher matcher = NO_INSPECTION_PATTERN.matcher(text);
        return !matcher.matches();
    }
}

