/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.viewer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificatePane;
import net.sourceforge.jnlp.util.ImageResources;

public class CertificateViewer
extends JDialog {
    private boolean initialized = false;
    private static final String dialogTitle = Translator.R("CVCertificateViewer");
    CertificatePane panel;

    public CertificateViewer() {
        super((Frame)null, dialogTitle, true);
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.panel = new CertificatePane(this);
        this.add(this.panel);
        this.pack();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    CertificateViewer.this.panel.focusOnDefaultButton();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowFocusListener(adapter);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void centerDialog() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screen.width - dialogSize.width) / 2, (screen.height - dialogSize.height) / 2);
    }

    public static void showCertificateViewer() throws Exception {
        JNLPRuntime.initialize(true);
        CertificateViewer.setSystemLookAndFeel();
        CertificateViewer cv = new CertificateViewer();
        cv.setResizable(true);
        cv.centerDialog();
        cv.setVisible(true);
        cv.dispose();
    }

    private static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        CertificateViewer.showCertificateViewer();
    }
}

