/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URI;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.PropertyPermission;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class SecurityDesc {
    public static final Object ALL_PERMISSIONS = "All";
    public static final Object SANDBOX_PERMISSIONS = "Sandbox";
    public static final Object J2EE_PERMISSIONS = "J2SE";
    private Object type;
    private String downloadHost;
    private final boolean grantAwtPermissions;
    private JNLPFile file;
    private final Policy customTrustedPolicy;
    private static Permission[] j2eePermissions = new Permission[]{new AWTPermission("accessClipboard"), new RuntimePermission("exitVM"), new RuntimePermission("loadLibrary"), new RuntimePermission("queuePrintJob"), new SocketPermission("*", "connect"), new SocketPermission("localhost:1024-", "accept, listen"), new FilePermission("*", "read, write"), new PropertyPermission("*", "read")};
    private static Permission[] sandboxPermissions = new Permission[]{new SocketPermission("localhost:1024-", "listen"), new PropertyPermission("java.version", "read"), new PropertyPermission("java.vendor", "read"), new PropertyPermission("java.vendor.url", "read"), new PropertyPermission("java.class.version", "read"), new PropertyPermission("os.name", "read"), new PropertyPermission("os.version", "read"), new PropertyPermission("os.arch", "read"), new PropertyPermission("file.separator", "read"), new PropertyPermission("path.separator", "read"), new PropertyPermission("line.separator", "read"), new PropertyPermission("java.specification.version", "read"), new PropertyPermission("java.specification.vendor", "read"), new PropertyPermission("java.specification.name", "read"), new PropertyPermission("java.vm.specification.vendor", "read"), new PropertyPermission("java.vm.specification.name", "read"), new PropertyPermission("java.vm.version", "read"), new PropertyPermission("java.vm.vendor", "read"), new PropertyPermission("java.vm.name", "read"), new PropertyPermission("javawebstart.version", "read"), new PropertyPermission("javaplugin.*", "read"), new PropertyPermission("jnlp.*", "read,write"), new PropertyPermission("javaws.*", "read,write"), new PropertyPermission("browser", "read"), new PropertyPermission("browser.*", "read"), new RuntimePermission("exitVM"), new RuntimePermission("stopThread")};
    private static Permission[] jnlpRIAPermissions = new Permission[]{new PropertyPermission("awt.useSystemAAFontSettings", "read,write"), new PropertyPermission("http.agent", "read,write"), new PropertyPermission("http.keepAlive", "read,write"), new PropertyPermission("java.awt.syncLWRequests", "read,write"), new PropertyPermission("java.awt.Window.locationByPlatform", "read,write"), new PropertyPermission("javaws.cfg.jauthenticator", "read,write"), new PropertyPermission("javax.swing.defaultlf", "read,write"), new PropertyPermission("sun.awt.noerasebackground", "read,write"), new PropertyPermission("sun.awt.erasebackgroundonresize", "read,write"), new PropertyPermission("sun.java2d.d3d", "read,write"), new PropertyPermission("sun.java2d.dpiaware", "read,write"), new PropertyPermission("sun.java2d.noddraw", "read,write"), new PropertyPermission("sun.java2d.opengl", "read,write"), new PropertyPermission("swing.boldMetal", "read,write"), new PropertyPermission("swing.metalTheme", "read,write"), new PropertyPermission("swing.noxp", "read,write"), new PropertyPermission("swing.useSystemFontSettings", "read,write")};

    public SecurityDesc(JNLPFile file, Object type, String downloadHost) {
        this.file = file;
        this.type = type;
        this.downloadHost = downloadHost;
        String key = "deployment.security.sandbox.awtwarningwindow";
        this.grantAwtPermissions = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty(key));
        this.customTrustedPolicy = this.getCustomTrustedPolicy();
    }

    private Policy getCustomTrustedPolicy() {
        String key = "deployment.security.trusted.policy";
        String policyLocation = JNLPRuntime.getConfiguration().getProperty(key);
        Policy policy = null;
        if (policyLocation != null) {
            try {
                URI policyUri = new URI("file://" + policyLocation);
                policy = Policy.getInstance("JavaPolicy", new URIParameter(policyUri));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return policy;
    }

    public Object getSecurityType() {
        return this.type;
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this.getSandBoxPermissions();
        if (ALL_PERMISSIONS.equals(this.type)) {
            permissions = new Permissions();
            if (this.customTrustedPolicy == null) {
                permissions.add(new AllPermission());
                return permissions;
            }
            return this.customTrustedPolicy.getPermissions(cs);
        }
        if (J2EE_PERMISSIONS.equals(this.type)) {
            for (int i = 0; i < j2eePermissions.length; ++i) {
                permissions.add(j2eePermissions[i]);
            }
        }
        return permissions;
    }

    public PermissionCollection getSandBoxPermissions() {
        int i;
        Permissions permissions = new Permissions();
        for (i = 0; i < sandboxPermissions.length; ++i) {
            permissions.add(sandboxPermissions[i]);
        }
        if (this.grantAwtPermissions) {
            permissions.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        if (this.file.isApplication()) {
            for (i = 0; i < jnlpRIAPermissions.length; ++i) {
                permissions.add(jnlpRIAPermissions[i]);
            }
        }
        if (this.downloadHost != null && this.downloadHost.length() > 0) {
            permissions.add(new SocketPermission(this.downloadHost, "connect, accept"));
        }
        return permissions;
    }

    public static String[] getJnlpRIAPermissions() {
        String[] jnlpPermissions = new String[jnlpRIAPermissions.length];
        for (int i = 0; i < jnlpRIAPermissions.length; ++i) {
            jnlpPermissions[i] = jnlpRIAPermissions[i].getName();
        }
        return jnlpPermissions;
    }
}

