/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import net.sourceforge.jnlp.Log;
import net.sourceforge.jnlp.util.FileUtils;

class AppletLog
extends Log {
    private static Logger logger;

    private AppletLog() {
    }

    public static synchronized void log(Throwable e) {
        if (enableLogging && logger != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            logger.log(Level.FINE, baos.toString());
        }
    }

    static {
        try {
            if (enableLogging) {
                String fn = icedteaLogDir + "plugin" + System.currentTimeMillis() + ".log";
                FileUtils.createRestrictedFile(new File(fn), true);
                FileHandler fh = new FileHandler(fn, false);
                fh.setFormatter(new XMLFormatter());
                String logClassName = AppletLog.class.getName();
                logger = Logger.getLogger(logClassName);
                logger.setLevel(Level.ALL);
                logger.addHandler(fh);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

