#!/bin/sh
echo 'name: zlib
version: 0.5.4.1
id: zlib-0.5.4.1-f8b2bb965704e7ec5caa162d83990faa

license: BSD3
copyright: (c) 2006-2012 Duncan Coutts
maintainer: Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Compression and decompression in the gzip and zlib formats
description: This package provides a pure interface for compressing and
             decompressing streams of data represented as lazy
             '\''ByteString'\''s. It uses the zlib C library so it has high
             performance. It supports the \"zlib\", \"gzip\" and \"raw\"
             compression formats.
             .
             It provides a convenient high level API suitable for most
             tasks and for the few cases where more control is needed it
             provides access to the full zlib feature set.
category: Codec
author: Duncan Coutts <duncan@community.haskell.org>
pkgpath: archivers/hs-zlib
exposed: True
exposed-modules: Codec.Compression.GZip Codec.Compression.Zlib
                 Codec.Compression.Zlib.Raw Codec.Compression.Zlib.Internal
hidden-modules: Codec.Compression.Zlib.Stream
trusted: False
import-dirs: /usr/local/lib/ghc/zlib-0.5.4.1
library-dirs: /usr/local/lib/ghc/zlib-0.5.4.1
hs-libraries: HSzlib-0.5.4.1
extra-libraries: z
extra-ghci-libraries:
include-dirs:
includes: zlib.h
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-zlib-0.5.4.1/html/zlib.haddock
haddock-html: /usr/local/share/doc/hs-zlib-0.5.4.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
