#!/bin/sh
echo 'name: tls
version: 0.8.1
id: tls-0.8.1-0841f72080e2a2261cbf5458ca966923

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
synopsis: TLS/SSL protocol native implementation (Server and Client)
description: Native Haskell TLS and SSL protocol implementation for server and client.
             .
             This provides a high-level implementation of a sensitive security protocol,
             eliminating a common set of security issues through the use of the advanced
             type system, high level constructions and common Haskell features.
             .
             Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
             with only RSA supported for Key Exchange.
             .
             Only core protocol available here, have a look at the
             <http://hackage.haskell.org/package/tls-extra/> package for default
             ciphers, compressions and certificates functions.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS Network.TLS.Cipher
                 Network.TLS.Compression Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.MAC
                Network.TLS.Core Network.TLS.Crypto Network.TLS.Packet
                Network.TLS.Record Network.TLS.State Network.TLS.Sending
                Network.TLS.Receiving Network.TLS.Util Network.TLS.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/tls-0.8.1
library-dirs: /usr/local/lib/ghc/tls-0.8.1
hs-libraries: HStls-0.8.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         certificate-0.9.5-2d40f8facf754d2946e27f529783de7c
         crypto-api-0.10.2-ed965d5175b0edb9939073f02a068b59
         cryptocipher-0.2.8-8e22ea2234d6867668f953ed15dd5173
         cryptohash-0.7.0-316e1604125ceed9dd83f2715510953d
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.8.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.8.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
