#!/bin/sh
echo 'name: tagsoup
version: 0.12.8
id: tagsoup-0.12.8-831988f0e2d9cb9c2603e1498efef3b1

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/tagsoup/
package-url:
synopsis: Parsing and extracting information from (possibly malformed) HTML/XML documents
description: TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
             and can be used to parse either well-formed XML, or unstructured and malformed HTML
             from the web. The library also provides useful functions to extract information
             from an HTML document, making it ideal for screen-scraping.
             .
             Users should start from the "Text.HTML.TagSoup" module.
category: XML
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: textproc/hs-tagsoup
exposed: True
exposed-modules: Text.HTML.Download Text.HTML.TagSoup
                 Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
                 Text.HTML.TagSoup.Tree Text.StringLike
hidden-modules: Text.HTML.TagSoup.Generated
                Text.HTML.TagSoup.Implementation Text.HTML.TagSoup.Manual
                Text.HTML.TagSoup.Options Text.HTML.TagSoup.Parser
                Text.HTML.TagSoup.Render Text.HTML.TagSoup.Specification
                Text.HTML.TagSoup.Type
trusted: False
import-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
library-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
hs-libraries: HStagsoup-0.12.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         network-2.4.1.2-ed0143a4ea7fae0d6aafbe2cf30a6dc9
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tagsoup-0.12.8/html/tagsoup.haddock
haddock-html: /usr/local/share/doc/hs-tagsoup-0.12.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
