#!/bin/sh
echo 'name: snap-core
version: 0.9.4.0
id: snap-core-0.9.4.0-aa42950ecf43ca25907a55a094e08299

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Snap: A Haskell Web Framework (core interfaces and types)
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core",
             some iteratee utilities are in "Snap.Iteratee".
category: Web, Snap
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Core Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Exceptions
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Test Snap.Types.Headers
                 Snap.Util.FileServe Snap.Util.FileUploads Snap.Util.GZip
                 Snap.Util.Proxy Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool
                Snap.Internal.Parsing.FastSet Snap.Internal.Routing
                Snap.Internal.Types Snap.Internal.Test.RequestBuilder
                Snap.Internal.Test.Assertions
trusted: False
import-dirs: /usr/local/lib/ghc/snap-core-0.9.4.0
library-dirs: /usr/local/lib/ghc/snap-core-0.9.4.0
hs-libraries: HSsnap-core-0.9.4.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-037d72e94f82e21ad0efc3a3ca13d5e2
         MonadCatchIO-transformers-0.3.0.0-9df3c38f0408c0a91e2a32a7584ef9c9
         attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         attoparsec-enumerator-0.3.1-9799ee49c7c228079abd7930e5560145
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         blaze-builder-0.3.1.1-ac49b512143342e2370aead8ef93c70b
         blaze-builder-enumerator-0.2.0.5-9ad1bc3197df6727c137d951b463129e
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         bytestring-mmap-0.2.2-ff6e08b3515cc82a6a1ab2ad8c28a870
         case-insensitive-1.0.0.1-d2598685cbd81dd346ae8119d3bcded8
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         deepseq-1.3.0.1-aa1be128186a233c7290faf88620ffe5
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         enumerator-0.4.19-af2193302e502a3821d2e5d25db7ea2c
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         random-1.0.1.1-de2c78bd5b6a198d2ecb982e7d11c02f
         regex-posix-0.95.2-a34848eaff24ac32325260f99852c6c9
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         unix-2.6.0.1-f31936082e1fa9175b93ddf28f79644c
         unix-compat-0.4.1.1-7d1074b15de4b90d12292f611c87397a
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
         zlib-enum-0.2.3-37dd2d636e8955ee1808dc2197600362
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.9.4.0/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.9.4.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
