#!/bin/sh
echo 'name: snap
version: 0.12.0
id: snap-0.12.0-ee2430ec6cfc28c042d9c805ea3a1ec7

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Top-level package for the Snap Web Framework
description: This is the top-level package for the official Snap Framework libraries.
             It includes:
             .
             * The Snaplets API
             .
             * The \"snap\" executable program for generating starter projects
             .
             * Snaplets for sessions, authentication, and templates
             .
             To get started, issue the following sequence of commands:
             .
             @$ cabal install snap
             $ mkdir myproject
             $ cd myproject
             $ snap init@
             .
             If you have trouble or any questions, see our FAQ page
             (<http://snapframework.com/faq>) or the documentation
             (<http://snapframework.com/docs>).
category: Web, Snap
author: Ozgun Ataman, Doug Beardsley, Gregory Collins, Carl Howells, Chris Smith
pkgpath: www/hs-snap
exposed: True
exposed-modules: Snap Snap.Snaplet Snap.Snaplet.Heist
                 Snap.Snaplet.HeistNoClass Snap.Snaplet.Heist.Compiled
                 Snap.Snaplet.Heist.Generic Snap.Snaplet.Heist.Interpreted
                 Snap.Snaplet.Auth Snap.Snaplet.Auth.Backends.JsonFile
                 Snap.Snaplet.Config Snap.Snaplet.Session
                 Snap.Snaplet.Session.Common Snap.Snaplet.Session.SessionManager
                 Snap.Snaplet.Session.Backends.CookieSession Snap.Snaplet.Test
hidden-modules: Control.Access.RoleBased.Checker
                Control.Access.RoleBased.Role Control.Access.RoleBased.Types
                Control.Access.RoleBased.Internal.Role
                Control.Access.RoleBased.Internal.RoleMap
                Control.Access.RoleBased.Internal.Rule
                Control.Access.RoleBased.Internal.Types
                Snap.Snaplet.Auth.AuthManager Snap.Snaplet.Auth.Types
                Snap.Snaplet.Auth.Handlers Snap.Snaplet.Auth.SpliceHelpers
                Snap.Snaplet.Heist.Internal Snap.Snaplet.Internal.Initializer
                Snap.Snaplet.Internal.LensT Snap.Snaplet.Internal.Lensed
                Snap.Snaplet.Internal.RST Snap.Snaplet.Internal.Types
                Snap.Snaplet.Session.SecureCookie
trusted: False
import-dirs: /usr/local/lib/ghc/snap-0.12.0
library-dirs: /usr/local/lib/ghc/snap-0.12.0
hs-libraries: HSsnap-0.12.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.3.0.0-9df3c38f0408c0a91e2a32a7584ef9c9
         aeson-0.6.0.2-5c5998e8fd3dd21476ca10d62df94bd2
         attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         clientsession-0.8.0.1-6a2adf25df1dc9d2ba0252fd36f8163b
         comonad-3.0.3-97c2b9aaa661ce271befc6b439457331
         configurator-0.2.0.0-ef7ae084e9ff51bbfebe1bb8d4cb8f96
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         directory-tree-0.11.0-0f25d13869a5d7392e7d0db657bc695a
         dlist-0.5-537820b285fbaec1d5ce98a12ca093d8
         errors-1.4.2-73bc5745c94faaf6fd26a488bb91c414
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         heist-0.12.0-ad707bdadab21f42175ad4aa6f873a8d
         lens-3.7.6-c15c4a559d085cb397da19f3ffe792ec
         logict-0.5.0.1-a30e5ce38650023ca5c6c0f85bbb9671
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         mwc-random-0.12.0.1-005a6da460373c3cc9f54fd5037da418
         pwstore-fast-2.3-ea8435119e7819711faed2dc933e4ae9
         regex-posix-0.95.2-a34848eaff24ac32325260f99852c6c9
         snap-core-0.9.4.0-aa42950ecf43ca25907a55a094e08299
         snap-server-0.9.3.3-64f0648260c3836c0139f54c4510befa
         stm-2.4.2-0f41fcf17f5bc067084394f47dbfe7cf
         syb-0.4.0-8e7e08a060d6fc361aca595c701a94d6
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
         vector-algorithms-0.5.4.2-cd26604f598a50b09c2e8a378a15c5ed
         xmlhtml-0.2.1-024fbdca2ca705169920f98d3cb47c28
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-0.12.0/html/snap.haddock
haddock-html: /usr/local/share/doc/hs-snap-0.12.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
