#!/bin/sh
echo 'name: dbus
version: 0.10.4
id: dbus-0.10.4-b522ac0ec85fe16ec27dcfd8e724a7c1

license: GPL-3
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <jmillikin@gmail.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.4
library-dirs: /usr/local/lib/ghc/dbus-0.10.4
hs-libraries: HSdbus-0.10.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         libxml-sax-0.7.4-facb140884343dc266c9ae816e39f45d
         network-2.4.1.2-ed0143a4ea7fae0d6aafbe2cf30a6dc9
         parsec-3.1.3-c652afdd874e7e4acc362c51826c7925
         random-1.0.1.1-de2c78bd5b6a198d2ecb982e7d11c02f
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
         unix-2.6.0.1-f31936082e1fa9175b93ddf28f79644c
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
         xml-types-0.3.3-23e3194ef4426a359b660fc07386c2c9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.4/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
