#!/bin/sh
echo 'name: convertible
version: 1.0.11.1
id: convertible-1.0.11.1-405b2e1004d4074ab796e792d7978bb5

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
synopsis: Typeclasses and instances for converting between types
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
hs-libraries: HSconvertible-1.0.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         old-locale-1.0.0.5-753125cfaf463057d163a0cefde5b58f
         old-time-1.1.0.1-978f23f270668d2fce2ccde5417e64e6
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
