#!/bin/sh
echo 'name: conduit
version: 1.0.7.1
id: conduit-1.0.7.1-b979025e99374a114f410b6728de7c3f

license: MIT
copyright:
maintainer: michael@snoyman.com
stability:
homepage: http://github.com/snoyberg/conduit
package-url:
synopsis: Streaming data processing library.
description: @conduit@ is a solution to the streaming data problem, allowing for production, transformation, and consumption of streams of data in constant memory. It is an alternative to lazy I\/O which guarantees deterministic resource handling, and fits in the same general solution space as @enumerator@\/@iteratee@ and @pipes@. For a tutorial, please visit <https://haskell.fpcomplete.com/user/snoyberg/library-documentation/conduit-overview>.
             .
             Release history:
             .
             [1.0] Simplified the user-facing interface back to the Source, Sink, and Conduit types, with Producer and Consumer for generic code. Error messages have been simplified, and optional leftovers and upstream terminators have been removed from the external API. Some long-deprecated functions were finally removed.
             .
             [0.5] The internals of the package are now separated to the .Internal module, leaving only the higher-level interface in the advertised API. Internally, switched to a @Leftover@ constructor and slightly tweaked the finalization semantics.
             .
             [0.4] Inspired by the design of the pipes package: we now have a single unified type underlying @Source@, @Sink@, and @Conduit@. This type is named @Pipe@. There are type synonyms provided for the other three types. Additionally, @BufferedSource@ is no longer provided. Instead, the connect-and-resume operator, @$$+@, can be used for the same purpose.
             .
             [0.3] ResourceT has been greatly simplified, specialized for IO, and moved into a separate package. Instead of hard-coding ResourceT into the conduit datatypes, they can now live around any monad. The Conduit datatype has been enhanced to better allow generation of streaming output. The SourceResult, SinkResult, and ConduitResult datatypes have been removed entirely.
             .
             [0.2] Instead of storing state in mutable variables, we now use CPS. A @Source@ returns the next @Source@, and likewise for @Sink@s and @Conduit@s. Not only does this take better advantage of GHC\'\''s optimizations (about a 20% speedup), but it allows some operations to have a reduction in algorithmic complexity from exponential to linear. This also allowed us to remove the @Prepared@ set of types. Also, the @State@ functions (e.g., @sinkState@) use better constructors for return types, avoiding the need for a dummy state on completion.
             .
             [0.1] @BufferedSource@ is now an abstract type, and has a much more efficient internal representation. The result was a 41% speedup on microbenchmarks (note: do not expect speedups anywhere near that in real usage). In general, we are moving towards @BufferedSource@ being a specific tool used internally as needed, but using @Source@ for all external APIs.
             .
             [0.0] Initial release.
category: Data, Conduit
author: Michael Snoyman
pkgpath: devel/hs-conduit
exposed: True
exposed-modules: Data.Conduit Data.Conduit.Binary Data.Conduit.Text
                 Data.Conduit.List Data.Conduit.Lazy Data.Conduit.Internal
                 Data.Conduit.Util
hidden-modules: System.PosixFile
trusted: False
import-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
library-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
hs-libraries: HSconduit-1.0.7.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         lifted-base-0.1.1.1-df962fabd9ebfca01b8544de0993ae6a
         mmorph-1.0.0-a15fab14847b17e8633f502cec662879
         monad-control-0.3.1.4-d024ce2b7201855c15fd49bb7bd26d58
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         resourcet-0.4.6-b6f1fe8681fd236d30eb6b8fbf206eec
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
         transformers-base-0.4.1-29e41c74cf8cb797697c0a8da0a90a5c
         void-0.6.1-f7cc4ae824b6e0bc732bb8e7c8068c34
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-conduit-1.0.7.1/html/conduit.haddock
haddock-html: /usr/local/share/doc/hs-conduit-1.0.7.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
