#!/bin/sh
echo 'name: aeson
version: 0.6.0.2
id: aeson-0.6.0.2-5c5998e8fd3dd21476ca10d62df94bd2

license: BSD3
copyright: (c) 2011 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
synopsis: Fast JSON parsing and encoding
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             For release notes, see
             <https://github.com/bos/aeson/blob/master/release-notes.markdown>
             .
             /Note/: if you use GHCi or Template Haskell, please see the
             @README@ file for important details about building this package,
             and other packages that depend on it:
             <https://github.com/bos/aeson#readme>
             .
             Parsing performance on a late 2010 MacBook Pro (2.66GHz Core i7),
             for mostly-English tweets from Twitter'\''s JSON search API:
             .
             * 0.8 KB, 32-bit GHC 6.12.3: 30538 msg\/sec (24.9 MB\/sec)
             .
             * 0.8 KB, 64-bit GHC 7.0.3: 31204 msg\/sec (25.4 MB\/sec)
             .
             * 6.4 KB, 32-bit GHC 6.12.3: 6731 msg\/sec (42.3 MB\/sec)
             .
             * 6.4 KB, 64-bit GHC 7.0.3: 6627 msg\/sec (41.7 MB\/sec)
             .
             * 11.8 KB, 32-bit GHC 6.12.3: 3751 msg\/sec (43.2 MB\/sec)
             .
             * 11.8 KB, 64-bit GHC 7.0.3: 3381 msg\/sec (38.9 MB\/sec)
             .
             * 31.2 KB, 32-bit GHC 6.12.3: 1306 msg\/sec (39.8 MB\/sec)
             .
             * 31.2 KB, 64-bit GHC 7.0.3: 1132 msg\/sec (34.5 MB\/sec)
             .
             * 61.5 KB, 32-bit GHC 6.12.3: 616 msg\/sec (37.0 MB\/sec)
             .
             * 61.5 KB, 64-bit GHC 7.0.3: 534 msg\/sec (32.1 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB, 32-bit GHC 6.12.3: 2315 msg\/sec (33.1 MB\/sec)
             .
             * 14.6 KB, 64-bit GHC 7.0.3: 1986 msg\/sec (28.4 MB\/sec)
             .
             * 44.1 KB, 32-bit GHC 6.12.3: 712 msg\/sec (30.7 MB\/sec)
             .
             * 44.1 KB, 64-bit GHC 7.0.3: 634 msg\/sec (27.3 MB\/sec)
             .
             * 82.9 KB, 32-bit GHC 6.12.3: 377 msg\/sec (30.5 MB\/sec)
             .
             * 82.9 KB, 64-bit GHC 7.0.3: 332 msg\/sec (26.9 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 854 bytes: 43439 msg\/sec (35.4 MB/sec)
             .
             * English, 6.4 KB: 7127 msg\/sec (44.8 MB/sec)
             .
             * Engish, 61.5 KB: 765 msg\/sec (46.0 MB/sec)
             .
             * Japanese, 14.6 KB: 4727 msg\/sec (67.5 MB/sec)
             .
             * Japanese, 44.1 KB: 1505 msg\/sec (64.8 MB/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Types.Generic Data.Aeson.Functions
                Data.Aeson.Parser.Internal Data.Aeson.Types.Class
                Data.Aeson.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
library-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
hs-libraries: HSaeson-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         blaze-builder-0.3.1.1-ac49b512143342e2370aead8ef93c70b
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         deepseq-1.3.0.1-aa1be128186a233c7290faf88620ffe5
         dlist-0.5-537820b285fbaec1d5ce98a12ca093d8
         ghc-prim-0.3.0.0-00db43fcd2f6e2a73243bdb496b765e0
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         old-locale-1.0.0.5-753125cfaf463057d163a0cefde5b58f
         syb-0.4.0-8e7e08a060d6fc361aca595c701a94d6
         template-haskell-2.8.0.0-ac0663b70333f59eeec24f3cf48cfb28
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.6.0.2/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
