/*
 * Virtual GMC-4
 * 
 * 4bit 仮想化ソリューション
 *
 * GMC-4上でGMC-4をエミュレートします．
 * (単にJUMP 50をしてる訳ではない!)
 * 0x50-0x5D番地にバーチャルマシンの命令を書きます．
 *
 * キーを押している間はバーチャルマシンの実行を一時停止できます．
 *
 * バーチャルマシン上でサポートされる命令は	
 * TIA, AIA, AO, JUMP だけです，，
 */
	
	# バーチャルプログラムカウンタの初期化
	TIY F
	TIA 0
	AM
	
fetch:
	# 命令とオペランドのFetch
	MA	# 命令取得
	CY
	MA

	CH	# オペランド取得
	TIY F
	MA	
	AIA 1
	CY
	MA
	CH
	
	# JUMP命令 Execute
	CIA F	
	JUMP decodeNextJUMP

	CH
	
	TIY F	# バーチャルプログラムカウンタを設定
	AM
	
	JUMP fetch
decodeNextJUMP:
	
	# TIA命令 Execute
	CIA 8
	JUMP decodeNextTIA

	CH
	
	TIY E	# バーチャルAレジスタに格納
	AM

	TIA 2	# PC増加分
	JUMP decodeEnd
decodeNextTIA:
	
	# AIA命令 Execute
	CIA 9
	JUMP decodeNextAIA

	CH
		
	TIY E	# バーチャルAレジスタとオペランドを加算して格納
	M+
	AM
	
	TIA 2	# PC増加分
	JUMP decodeEnd
decodeNextAIA:

	# AO命令 Execute
	#CIA 1	# 上記の命令でなければAO命令と解釈する
	#JUMP decodeNextAO

	TIY E	# バーチャルAレジスタの内容を表示
	MA
	AO
	
	TIA 1	# PC増加分
decodeNextAO:


decodeEnd:	
	# バーチャルプログラムカウンタを進める
	TIY F
	M+
	AM
	
suspend:		# サスペンド機能

# ホストマシン上のアプリケーション ここから-------------------------
	# 短い音を鳴らす
	CAL SHTS	
# ホストマシン上のアプリケーション ここまで-------------------------
	

	KA
	JUMP fetch
	JUMP suspend
	

# バーチャルマシン ここから --------------------------------------
	.align 50
	# 0からFまで順に表示する
	TIA 0
	AO
	AIA 1		# 実行フラグの機能はなし
	JUMP 20		# 2番地にジャンプ．
			# プログラム領域のアドレスも1ニブルなので下一桁は無視される．
# バーチャルマシン ここまで --------------------------------------

	
	
#バーチャルマシン用レジスタ領域
	.align 5E
	.nibble F # バーチャルマシンAレジスタ
	.nibble 0 # バーチャルマシンプログラムカウンタ
