/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -1681004643499461044L;
    private KeyStroke accelerator;
    private boolean isDragging;

    public JMenuItem() {
        this(null, null);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
    }

    public JMenuItem(String text) {
        this(text, null);
    }

    public JMenuItem(Action action) {
        super.setAction(action);
        this.setModel(new DefaultButtonModel());
        this.init(null, null);
        if (action != null) {
            String command;
            Integer mnemonic;
            KeyStroke accel;
            String name = (String)action.getValue("Name");
            if (name != null) {
                this.setName(name);
            }
            if ((accel = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                this.setAccelerator(accel);
            }
            if ((mnemonic = (Integer)action.getValue("MnemonicKey")) != null) {
                this.setMnemonic(mnemonic);
            }
            if ((command = (String)action.getValue("ActionCommandKey")) != null) {
                this.setActionCommand(command);
            }
        }
    }

    public JMenuItem(String text, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(text, icon);
    }

    public JMenuItem(String text, int mnemonic) {
        this(text, null);
        this.setMnemonic(mnemonic);
    }

    protected void init(String text, Icon icon) {
        super.init(text, icon);
        this.focusPainted = false;
        this.horizontalAlignment = 10;
        this.horizontalTextPosition = 11;
    }

    public void setUI(MenuItemUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuItemUI";
    }

    public boolean isArmed() {
        return this.getModel().isArmed();
    }

    public void setArmed(boolean armed) {
        this.getModel().setArmed(armed);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keystroke) {
        KeyStroke old = this.accelerator;
        this.accelerator = keystroke;
        this.firePropertyChange("accelerator", old, keystroke);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        if (!(this instanceof JMenu) && action != null) {
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
            if (this.accelerator != null) {
                super.registerKeyboardAction(action, this.accelerator, 2);
            }
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                JMenuItem.this.configurePropertiesFromAction(act);
            }
        };
    }

    public void processMouseEvent(MouseEvent ev, MenuElement[] path, MenuSelectionManager manager) {
        MenuDragMouseEvent e = new MenuDragMouseEvent(ev.getComponent(), ev.getID(), ev.getWhen(), ev.getModifiers(), ev.getX(), ev.getY(), ev.getClickCount(), ev.isPopupTrigger(), path, manager);
        this.processMenuDragMouseEvent(e);
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
        MenuKeyEvent e = new MenuKeyEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getKeyCode(), event.getKeyChar(), path, manager);
        this.processMenuKeyEvent(e);
        if (e.isConsumed()) {
            event.consume();
        }
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent event) {
        switch (event.getID()) {
            case 504: {
                this.isDragging = false;
                this.fireMenuDragMouseEntered(event);
                break;
            }
            case 505: {
                this.isDragging = false;
                this.fireMenuDragMouseExited(event);
                break;
            }
            case 506: {
                this.isDragging = true;
                this.fireMenuDragMouseDragged(event);
                break;
            }
            case 502: {
                if (!this.isDragging) break;
                this.fireMenuDragMouseReleased(event);
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent event) {
        switch (event.getID()) {
            case 401: {
                this.fireMenuKeyPressed(event);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(event);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(event);
                break;
            }
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuDragMouseListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseEntered(event);
            ++i;
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuDragMouseListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseExited(event);
            ++i;
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuDragMouseListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseDragged(event);
            ++i;
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuDragMouseListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseReleased(event);
            ++i;
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuKeyListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuKeyListener)ll[i]).menuKeyPressed(event);
            ++i;
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuKeyListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuKeyListener)ll[i]).menuKeyTyped(event);
            ++i;
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(MenuKeyListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuKeyListener)ll[i]).menuKeyTyped(event);
            ++i;
        }
    }

    public void menuSelectionChanged(boolean changed) {
        Container parent = this.getParent();
        if (changed) {
            this.model.setArmed(true);
            if (parent != null && parent instanceof JPopupMenu) {
                ((JPopupMenu)parent).setSelected(this);
            }
        } else {
            this.model.setArmed(false);
            if (parent != null && parent instanceof JPopupMenu) {
                ((JPopupMenu)parent).getSelectionModel().clearSelection();
            }
        }
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public void addMenuDragMouseListener(MenuDragMouseListener listener) {
        this.listenerList.add(MenuDragMouseListener.class, listener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener listener) {
        this.listenerList.remove(MenuDragMouseListener.class, listener);
    }

    public MenuDragMouseListener[] getMenuDragMouseListeners() {
        return (MenuDragMouseListener[])this.listenerList.getListeners(MenuDragMouseListener.class);
    }

    public void addMenuKeyListener(MenuKeyListener listener) {
        this.listenerList.add(MenuKeyListener.class, listener);
    }

    public void removeMenuKeyListener(MenuKeyListener listener) {
        this.listenerList.remove(MenuKeyListener.class, listener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(MenuKeyListener.class);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJMenuItem ctx = new AccessibleJMenuItem();
            this.addChangeListener(ctx);
            this.accessibleContext = ctx;
        }
        return this.accessibleContext;
    }

    boolean onTop() {
        return SwingUtilities.getAncestorOfClass(JInternalFrame.class, this) == null;
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        private static final long serialVersionUID = 6748924232082076534L;
        private boolean armed;
        private boolean focusOwner;
        private boolean pressed;
        private boolean selected;

        AccessibleJMenuItem() {
            super(JMenuItem.this);
        }

        public void stateChanged(ChangeEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            ButtonModel model = JMenuItem.this.getModel();
            if (model.isArmed()) {
                if (!this.armed) {
                    this.armed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
                }
            } else if (this.armed) {
                this.armed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            }
            if (model.isPressed()) {
                if (!this.pressed) {
                    this.pressed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
                }
            } else if (this.pressed) {
                this.pressed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
            }
            if (model.isSelected()) {
                if (!this.selected) {
                    this.selected = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                }
            } else if (this.selected) {
                this.selected = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
            if (JMenuItem.this.isFocusOwner()) {
                if (!this.focusOwner) {
                    this.focusOwner = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            } else if (this.focusOwner) {
                this.focusOwner = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }
    }
}

