/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.HashMap;

class CompatibilityFocusTraversalPolicy
extends FocusTraversalPolicy {
    private FocusTraversalPolicy fallback;
    private HashMap forward;
    private HashMap backward;

    CompatibilityFocusTraversalPolicy(FocusTraversalPolicy p) {
        this.fallback = p;
        this.forward = new HashMap();
        this.backward = new HashMap();
    }

    public Component getComponentAfter(Container root, Component current) {
        Component next = (Component)this.forward.get(current);
        if (next == null && this.fallback != null) {
            next = this.fallback.getComponentAfter(root, current);
        }
        return next;
    }

    public Component getComponentBefore(Container root, Component current) {
        Component previous = (Component)this.backward.get(current);
        if (previous == null && this.fallback != null) {
            previous = this.fallback.getComponentAfter(root, current);
        }
        return previous;
    }

    public Component getFirstComponent(Container root) {
        Component first = null;
        if (this.fallback != null) {
            first = this.fallback.getFirstComponent(root);
        }
        return first;
    }

    public Component getLastComponent(Container root) {
        Component last = null;
        if (this.fallback != null) {
            last = this.fallback.getLastComponent(root);
        }
        return last;
    }

    public Component getDefaultComponent(Container root) {
        Component def = null;
        if (this.fallback != null) {
            def = this.fallback.getDefaultComponent(root);
        }
        return def;
    }

    void setNextFocusableComponent(Component current, Component next) {
        this.forward.put(current, next);
        this.backward.put(next, current);
    }

    void addNextFocusableComponent(Component current, Component next) {
        this.forward.put(current, next);
        this.backward.put(next, current);
    }

    void removeNextFocusableComponent(Component current, Component next) {
        this.forward.remove(current);
        this.backward.remove(next);
    }
}

