/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException;

    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        int total = 0;
        byte[] inbuf = new byte[256];
        while (input.hasRemaining()) {
            int in = Math.min(inbuf.length, input.remaining());
            input.get(inbuf, 0, in);
            byte[] outbuf = new byte[this.engineGetOutputSize(in)];
            int out = 0;
            out = input.hasRemaining() ? this.engineUpdate(inbuf, 0, in, outbuf, 0) : this.engineDoFinal(inbuf, 0, in, outbuf, 0);
            output.put(outbuf, 0, out);
            total += out;
        }
        return total;
    }

    protected abstract int engineGetBlockSize();

    protected abstract byte[] engineGetIV();

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected abstract int engineGetOutputSize(int var1);

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidAlgorithmParameterException, InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidAlgorithmParameterException, InvalidKeyException;

    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        int total = 0;
        byte[] inbuf = new byte[256];
        while (input.hasRemaining()) {
            int in = Math.min(inbuf.length, input.remaining());
            input.get(inbuf, 0, in);
            byte[] outbuf = new byte[this.engineGetOutputSize(in)];
            int out = this.engineUpdate(inbuf, 0, in, outbuf, 0);
            output.put(outbuf, 0, out);
            total += out;
        }
        return total;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        throw new UnsupportedOperationException();
    }
}

