/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;

public class PixelInterleavedSampleModel
extends ComponentSampleModel {
    public PixelInterleavedSampleModel(int dataType, int width, int height, int pixelStride, int scanlineStride, int[] bandOffsets) {
        super(dataType, width, height, pixelStride, scanlineStride, bandOffsets);
    }

    public SampleModel createCompatibleSampleModel(int width, int height) {
        int[] bandOff;
        int minBandoff = this.bandOffsets[0];
        int numBands = this.bandOffsets.length;
        int i = 1;
        while (i < numBands) {
            if (this.bandOffsets[i] < minBandoff) {
                minBandoff = this.bandOffsets[i];
            }
            ++i;
        }
        if (minBandoff > 0) {
            bandOff = new int[numBands];
            int i2 = 0;
            while (i2 < numBands) {
                bandOff[i2] = this.bandOffsets[i2] - minBandoff;
                ++i2;
            }
        } else {
            bandOff = this.bandOffsets;
        }
        return new PixelInterleavedSampleModel(this.dataType, width, height, this.pixelStride, this.pixelStride * width, bandOff);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int[] subOffsets = new int[bands.length];
        int i = 0;
        while (i < bands.length) {
            subOffsets[i] = this.bandOffsets[bands[i]];
            ++i;
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, subOffsets);
    }
}

