/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import gnu.java.awt.ClasspathGraphicsEnvironment;
import gnu.java.awt.ComponentDataBlitOp;
import gnu.java.lang.CPStringBuilder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImage
extends Image
implements WritableRenderedImage,
Transparency {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    Vector<TileObserver> tileObservers;
    WritableRaster raster;
    ColorModel colorModel;
    Hashtable properties;
    boolean isPremultiplied;
    int type;
    private static final Point[] tileIndices = new Point[]{new Point()};

    public BufferedImage(int width, int height, int type) {
        SampleModel sm = null;
        ColorModel cm = null;
        boolean premultiplied = type == 3 || type == 7;
        switch (type) {
            case 1: {
                sm = new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF0000, 65280, 255});
                cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                break;
            }
            case 5: {
                int[] nArray = new int[3];
                nArray[0] = 2;
                nArray[1] = 1;
                sm = new PixelInterleavedSampleModel(0, width, height, 3, width * 3, nArray);
                cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                break;
            }
            case 2: 
            case 3: {
                sm = new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF0000, 65280, 255, -16777216});
                if (premultiplied) {
                    cm = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, Buffers.smallestAppropriateTransferType(32));
                    break;
                }
                cm = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = new int[4];
                nArray[0] = 3;
                nArray[1] = 2;
                nArray[2] = 1;
                sm = new PixelInterleavedSampleModel(0, width, height, 4, 4 * width, nArray);
                cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, premultiplied, 3, 0);
                break;
            }
            case 4: {
                sm = new SinglePixelPackedSampleModel(3, width, height, new int[]{255, 65280, 0xFF0000});
                cm = new DirectColorModel(24, 255, 65280, 0xFF0000);
                break;
            }
            case 8: {
                sm = new SinglePixelPackedSampleModel(1, width, height, new int[]{63488, 2016, 31});
                cm = new DirectColorModel(16, 63488, 2016, 31);
                break;
            }
            case 9: {
                sm = new SinglePixelPackedSampleModel(1, width, height, new int[]{31744, 992, 31});
                cm = new DirectColorModel(15, 31744, 992, 31);
                break;
            }
            case 13: {
                cm = this.createDefaultIndexedColorModel(false);
            }
            case 10: {
                sm = new PixelInterleavedSampleModel(0, width, height, 1, width, new int[1]);
                break;
            }
            case 11: {
                sm = new PixelInterleavedSampleModel(1, width, height, 1, width, new int[1]);
                break;
            }
            case 12: {
                cm = this.createDefaultIndexedColorModel(true);
                sm = new MultiPixelPackedSampleModel(0, width, height, 1);
                break;
            }
            default: {
                sm = null;
            }
        }
        if (sm == null) {
            throw new IllegalArgumentException("Unknown predefined image type.");
        }
        if (cm == null) {
            int buftype;
            int[] bits = new int[1];
            if (type == 10) {
                buftype = 0;
                bits[0] = 8;
            } else {
                buftype = 1;
                bits[0] = 16;
            }
            ColorSpace graySpace = ColorSpace.getInstance(1003);
            cm = new ComponentColorModel(graySpace, bits, false, false, 1, buftype);
        }
        WritableRaster rst = null;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (env instanceof ClasspathGraphicsEnvironment) {
            rst = ((ClasspathGraphicsEnvironment)env).createRaster(cm, sm);
        }
        if (rst == null) {
            rst = Raster.createWritableRaster(sm, new Point(0, 0));
        }
        this.init(cm, rst, premultiplied, null, type);
    }

    public BufferedImage(int w, int h, int type, IndexColorModel indexcolormodel) {
        if (type != 12 && type != 13) {
            throw new IllegalArgumentException("Type must be TYPE_BYTE_BINARY or TYPE_BYTE_INDEXED");
        }
        if (indexcolormodel.getMapSize() > 16 && type == 12) {
            throw new IllegalArgumentException("Type TYPE_BYTE_BINARY cannot have a larger than 16-color palette.");
        }
        if (indexcolormodel.getMapSize() > 256) {
            throw new IllegalArgumentException("Byte type cannot have a larger than 256-color palette.");
        }
        this.init(indexcolormodel, indexcolormodel.createCompatibleWritableRaster(w, h), indexcolormodel.isAlphaPremultiplied(), null, type);
    }

    public BufferedImage(ColorModel colormodel, WritableRaster writableraster, boolean premultiplied, Hashtable<?, ?> properties) {
        this.init(colormodel, writableraster, premultiplied, properties, 0);
    }

    private void init(ColorModel cm, WritableRaster writableraster, boolean premultiplied, Hashtable properties, int type) {
        this.raster = writableraster;
        this.colorModel = cm;
        this.properties = properties;
        this.isPremultiplied = premultiplied;
        this.type = type;
    }

    private IndexColorModel createDefaultIndexedColorModel(boolean binary) {
        if (binary) {
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] t = byArray;
            return new IndexColorModel(1, 2, t, t, t);
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        int index = 0;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 6) {
                int k = 0;
                while (k < 6) {
                    r[index] = (byte)(i * 51);
                    g[index] = (byte)(j * 51);
                    b[index] = (byte)(k * 51);
                    ++index;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        while (index < 256) {
            g[index] = b[index] = (byte)(18 + (index - 216) * 6);
            r[index] = b[index];
            ++index;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public void coerceData(boolean premultiplied) {
        this.colorModel = this.colorModel.coerceData(this.raster, premultiplied);
        this.isPremultiplied = premultiplied;
    }

    @Override
    public WritableRaster copyData(WritableRaster dest) {
        int h;
        int w;
        int y;
        int x;
        WritableRaster src;
        if (dest == null) {
            dest = this.raster.createCompatibleWritableRaster(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        }
        if ((src = this.raster.createWritableChild(x = dest.getMinX(), y = dest.getMinY(), w = dest.getWidth(), h = dest.getHeight(), x, y, null)).getSampleModel() instanceof ComponentSampleModel && dest.getSampleModel() instanceof ComponentSampleModel) {
            ComponentDataBlitOp.INSTANCE.filter(src, dest);
        } else {
            int[] samples = src.getPixels(x, y, w, h, (int[])null);
            dest.setPixels(x, y, w, h, samples);
        }
        return dest;
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return env.createGraphics(this);
    }

    @Override
    public void flush() {
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getData() {
        return this.copyData(null);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        WritableRaster dest = this.raster.createCompatibleWritableRaster(rectangle);
        return this.copyData(dest);
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getHeight(ImageObserver imageobserver) {
        return this.getHeight();
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public Object getProperty(String string) {
        Object v;
        if (string == null) {
            throw new NullPointerException("The property name cannot be null.");
        }
        Object result = Image.UndefinedProperty;
        if (this.properties != null && (v = this.properties.get(string)) != null) {
            result = v;
        }
        return result;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageobserver) {
        return this.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    public int getRGB(int x, int y) {
        Object rgbElem = this.raster.getDataElements(x, y, null);
        return this.colorModel.getRGB(rgbElem);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scanlineStride) {
        if (rgbArray == null) {
            int size = (h - 1) * scanlineStride + w;
            rgbArray = new int[size];
        }
        int endX = startX + w;
        int endY = startY + h;
        Object rgbElem = null;
        int y = startY;
        while (y < endY) {
            int xoffset = offset;
            int x = startX;
            while (x < endX) {
                rgbElem = this.raster.getDataElements(x, y, rgbElem);
                int rgb = this.colorModel.getRGB(rgbElem);
                rgbArray[xoffset++] = rgb;
                ++x;
            }
            offset += scanlineStride;
            ++y;
        }
        return rgbArray;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public ImageProducer getSource() {
        return new ImageProducer(){
            Vector<ImageConsumer> consumers = new Vector();

            public void addConsumer(ImageConsumer ic) {
                if (!this.consumers.contains(ic)) {
                    this.consumers.add(ic);
                }
            }

            public boolean isConsumer(ImageConsumer ic) {
                return this.consumers.contains(ic);
            }

            public void removeConsumer(ImageConsumer ic) {
                this.consumers.remove(ic);
            }

            public void startProduction(ImageConsumer ic) {
                int x = 0;
                int y = 0;
                int width = BufferedImage.this.getWidth();
                int height = BufferedImage.this.getHeight();
                int stride = width;
                int offset = 0;
                int[] pixels = BufferedImage.this.getRGB(x, y, width, height, null, offset, stride);
                DirectColorModel model = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                this.consumers.add(ic);
                int i = 0;
                while (i < this.consumers.size()) {
                    ImageConsumer c = this.consumers.elementAt(i);
                    c.setHints(8);
                    c.setDimensions(BufferedImage.this.getWidth(), BufferedImage.this.getHeight());
                    c.setPixels(x, y, width, height, (ColorModel)model, pixels, offset, stride);
                    c.imageComplete(3);
                    ++i;
                }
            }

            public void requestTopDownLeftRightResend(ImageConsumer ic) {
                this.startProduction(ic);
            }
        };
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        WritableRaster subRaster = this.getRaster().createWritableChild(x, y, w, h, 0, 0, null);
        return new BufferedImage(this.getColorModel(), subRaster, this.isPremultiplied, this.properties);
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.getWritableTile(tileX, tileY);
    }

    @Override
    public int getTileGridXOffset() {
        return 0;
    }

    @Override
    public int getTileGridYOffset() {
        return 0;
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getWidth(ImageObserver imageobserver) {
        return this.getWidth();
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        this.isTileWritable(tileX, tileY);
        return this.raster;
    }

    @Override
    public Point[] getWritableTileIndices() {
        return tileIndices;
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    public boolean isAlphaPremultiplied() {
        return this.isPremultiplied;
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new ArrayIndexOutOfBoundsException("only tile is (0,0)");
        }
        return true;
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        this.isTileWritable(tileX, tileY);
    }

    @Override
    public void setData(Raster src) {
        int x = src.getMinX();
        int y = src.getMinY();
        int w = src.getWidth();
        int h = src.getHeight();
        WritableRaster dest = this.raster.createWritableChild(x, y, w, h, x, y, null);
        if (src.getSampleModel() instanceof ComponentSampleModel && dest.getSampleModel() instanceof ComponentSampleModel) {
            ComponentDataBlitOp.INSTANCE.filter(src, dest);
        } else {
            int[] samples = src.getPixels(x, y, w, h, (int[])null);
            dest.setPixels(x, y, w, h, samples);
        }
    }

    public void setRGB(int x, int y, int argb) {
        Object rgbElem = this.colorModel.getDataElements(argb, null);
        this.raster.setDataElements(x, y, rgbElem);
    }

    public void setRGB(int startX, int startY, int w, int h, int[] argbArray, int offset, int scanlineStride) {
        int endX = startX + w;
        int endY = startY + h;
        Object rgbElem = null;
        int y = startY;
        while (y < endY) {
            int xoffset = offset;
            int x = startX;
            while (x < endX) {
                int argb = argbArray[xoffset++];
                rgbElem = this.colorModel.getDataElements(argb, rgbElem);
                this.raster.setDataElements(x, y, rgbElem);
                ++x;
            }
            offset += scanlineStride;
            ++y;
        }
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder(120);
        buf.append("BufferedImage@");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append(": type=");
        buf.append(this.type);
        buf.append(' ');
        buf.append(this.colorModel);
        buf.append(' ');
        buf.append(this.raster);
        return buf.toString();
    }

    @Override
    public void addTileObserver(TileObserver to) {
        if (this.tileObservers == null) {
            this.tileObservers = new Vector();
        }
        this.tileObservers.add(to);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
        if (this.tileObservers == null) {
            return;
        }
        this.tileObservers.remove(to);
    }

    @Override
    public int getTransparency() {
        return this.colorModel.getTransparency();
    }
}

