/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Signature {
    public static String computeClassSignature(Class theClass) {
        CPStringBuilder sb = new CPStringBuilder();
        Signature._addToSignature(sb, theClass);
        return sb.toString();
    }

    public static String computeFieldSignature(Field field) {
        return Signature.computeClassSignature(field.getType());
    }

    public static String computeMethodSignature(Method method) {
        return Signature._computeSignature(method.getReturnType(), method.getParameterTypes());
    }

    private static String _computeSignature(Class returnType, Class[] paramTypes) {
        CPStringBuilder sb = new CPStringBuilder("(");
        if (paramTypes != null) {
            int i = 0;
            while (i < paramTypes.length) {
                Signature._addToSignature(sb, paramTypes[i]);
                ++i;
            }
        }
        sb.append(")");
        Signature._addToSignature(sb, returnType);
        return sb.toString();
    }

    private static void _addToSignature(CPStringBuilder sb, Class k) {
        if (k.isPrimitive()) {
            if (k == Void.TYPE) {
                sb.append('V');
            } else if (k == Boolean.TYPE) {
                sb.append('Z');
            } else if (k == Byte.TYPE) {
                sb.append('B');
            } else if (k == Character.TYPE) {
                sb.append('C');
            } else if (k == Short.TYPE) {
                sb.append('S');
            } else if (k == Integer.TYPE) {
                sb.append('I');
            } else if (k == Float.TYPE) {
                sb.append('F');
            } else if (k == Double.TYPE) {
                sb.append('D');
            } else if (k == Long.TYPE) {
                sb.append('J');
            }
            return;
        }
        String name = k.getName();
        int len = name.length();
        sb.ensureCapacity(len);
        if (!k.isArray()) {
            sb.append('L');
        }
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (c == '.') {
                c = '/';
            }
            sb.append(c);
            ++i;
        }
        if (!k.isArray()) {
            sb.append(';');
        }
    }
}

