/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.WritableType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TypeImpl
implements Type,
WritableType {
    private String packageName;
    private String typeName;
    private String dimension;
    private static final Set primitiveNames;

    static {
        HashSet<String> _primitiveNames = new HashSet<String>();
        _primitiveNames.add("boolean");
        _primitiveNames.add("char");
        _primitiveNames.add("byte");
        _primitiveNames.add("short");
        _primitiveNames.add("int");
        _primitiveNames.add("long");
        _primitiveNames.add("float");
        _primitiveNames.add("double");
        primitiveNames = Collections.unmodifiableSet(_primitiveNames);
    }

    TypeImpl(String packageName, String typeName, String dimension) {
        this.packageName = packageName;
        this.typeName = typeName;
        this.dimension = dimension;
        if (typeName.indexOf(91) >= 0 || typeName.indexOf(93) >= 0) {
            throw new RuntimeException("Typename must not contain dimension information.");
        }
    }

    public ClassDoc asClassDoc() {
        if (this instanceof ClassDoc) {
            return ((ClassDocImpl)((ClassDoc)((Object)this))).getBaseClassDoc();
        }
        return null;
    }

    public String typeName() {
        return this.typeName;
    }

    public String qualifiedTypeName() {
        return this.packageName != null ? String.valueOf(this.packageName) + "." + this.typeName : this.typeName;
    }

    public String dimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String toString() {
        return "Type{" + this.qualifiedTypeName() + this.dimension() + "}";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isPrimitive() {
        return this.packageName == null && primitiveNames.contains(this.typeName);
    }

    public TypeVariable asTypeVariable() {
        if (this instanceof TypeVariable) {
            return (TypeVariable)((Object)this);
        }
        return null;
    }
}

