/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.DocImpl;
import gnu.classpath.tools.gjdoc.GjdocPackageDoc;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.ParseException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageDocImpl
extends DocImpl
implements GjdocPackageDoc {
    private String packageName;
    private File packageDirectory;
    private Set<ClassDoc> allClassesSet = new TreeSet<ClassDoc>();
    private List<ClassDoc> ordinaryClassesList = new ArrayList<ClassDoc>();
    private List<ClassDoc> exceptionsList = new ArrayList<ClassDoc>();
    private List<ClassDoc> interfacesList = new ArrayList<ClassDoc>();
    private List<ClassDoc> errorsList = new ArrayList<ClassDoc>();
    private ClassDoc[] allClasses;
    private ClassDoc[] ordinaryClasses;
    private ClassDoc[] exceptions;
    private ClassDoc[] interfaces;
    private ClassDoc[] errors;
    public static final PackageDocImpl DEFAULT_PACKAGE = new PackageDocImpl("");
    private boolean isIncluded = false;

    PackageDocImpl(String packageName) {
        super(null);
        this.packageName = packageName;
    }

    public void addClass(ClassDoc classDoc) {
        if (Main.getInstance().includeAccessLevel(((ClassDocImpl)classDoc).accessLevel)) {
            this.allClassesSet.add(classDoc);
        }
    }

    public void resolve() {
        for (ClassDocImpl classDocImpl : this.allClassesSet) {
            try {
                classDocImpl.resolve();
            }
            catch (ParseException e) {
                System.err.println("FIXME: add try-catch to force compilation" + e);
            }
            if (classDocImpl.isInterface()) {
                this.interfacesList.add(classDocImpl);
                continue;
            }
            if (classDocImpl.isException()) {
                this.exceptionsList.add(classDocImpl);
                continue;
            }
            if (classDocImpl.isError()) {
                this.errorsList.add(classDocImpl);
                continue;
            }
            this.ordinaryClassesList.add(classDocImpl);
        }
    }

    @Override
    public void resolveComments() {
        if (this.rawDocumentation != null) {
            this.tagMap = PackageDocImpl.parseCommentTags(this.rawDocumentation.toCharArray(), 0, this.rawDocumentation.length(), null, null, null, null);
        }
        this.resolveTags();
    }

    @Override
    public String name() {
        return this.packageName;
    }

    @Override
    public ClassDoc[] allClasses() {
        if (this.allClasses == null) {
            this.allClasses = this.toClassDocArray(this.allClassesSet);
        }
        return this.allClasses;
    }

    @Override
    public ClassDoc[] ordinaryClasses() {
        if (this.ordinaryClasses == null) {
            this.ordinaryClasses = this.toClassDocArray(this.ordinaryClassesList);
        }
        return this.ordinaryClasses;
    }

    @Override
    public ClassDoc[] exceptions() {
        if (this.exceptions == null) {
            this.exceptions = this.toClassDocArray(this.exceptionsList);
        }
        return this.exceptions;
    }

    @Override
    public ClassDoc[] interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.toClassDocArray(this.interfacesList);
        }
        return this.interfaces;
    }

    @Override
    public ClassDoc[] errors() {
        if (this.errors == null) {
            this.errors = this.toClassDocArray(this.errorsList);
        }
        return this.errors;
    }

    private ClassDoc[] toClassDocArray(Collection<ClassDoc> classDocList) {
        Object[] result = classDocList.toArray(new ClassDoc[classDocList.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public ClassDoc findClass(String name) {
        return Main.getRootDoc().classNamed(String.valueOf(this.packageName) + "." + name);
    }

    public void dump(int level) {
        Debug.log(level, "All classes:");
        Debug.dumpArray(level, this.allClasses());
        Debug.log(level, "Ordinary classes:");
        Debug.dumpArray(level, this.ordinaryClasses());
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    void setIsIncluded(boolean b) {
        this.isIncluded = b;
    }

    public String toString() {
        return this.packageName;
    }

    @Override
    public int compareTo(Doc d) {
        if (d != null && d instanceof PackageDocImpl) {
            return this.name().compareTo(((PackageDocImpl)d).name());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof PackageDocImpl) {
            return this.name().equals(((PackageDocImpl)o).name());
        }
        return false;
    }

    public void setPackageDirectory(File packageDirectory) {
        this.packageDirectory = packageDirectory;
    }

    @Override
    public File packageDirectory() {
        return this.packageDirectory;
    }
}

