/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Class<?> indexedPropertyType;
    private Method setIndex;
    private Method getIndex;

    public IndexedPropertyDescriptor(String name, Class<?> beanClass) throws IntrospectionException {
        super(name);
        String capitalized;
        try {
            capitalized = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            capitalized = "";
        }
        this.findMethods(beanClass, "get" + capitalized, "set" + capitalized, "get" + capitalized, "set" + capitalized);
    }

    public IndexedPropertyDescriptor(String name, Class<?> beanClass, String getMethodName, String setMethodName, String getIndexName, String setIndexName) throws IntrospectionException {
        super(name);
        this.findMethods(beanClass, getMethodName, setMethodName, getIndexName, setIndexName);
    }

    public IndexedPropertyDescriptor(String name, Method getMethod, Method setMethod, Method getIndex, Method setIndex) throws IntrospectionException {
        super(name);
        if (getMethod != null && getMethod.getParameterTypes().length > 0) {
            throw new IntrospectionException("get method has parameters");
        }
        if (getMethod != null && setMethod.getParameterTypes().length != 1) {
            throw new IntrospectionException("set method does not have exactly one parameter");
        }
        if (getMethod != null && setMethod != null) {
            if (!getMethod.getReturnType().equals(setMethod.getParameterTypes()[0])) {
                throw new IntrospectionException("set and get methods do not share the same type");
            }
            if (!getMethod.getDeclaringClass().isAssignableFrom(setMethod.getDeclaringClass()) && !setMethod.getDeclaringClass().isAssignableFrom(getMethod.getDeclaringClass())) {
                throw new IntrospectionException("set and get methods are not in the same class.");
            }
        }
        if (!(getIndex == null || getIndex.getParameterTypes().length == 1 && getIndex.getParameterTypes()[0].equals(Integer.TYPE))) {
            throw new IntrospectionException("get index method has wrong parameters");
        }
        if (!(setIndex == null || setIndex.getParameterTypes().length == 2 && setIndex.getParameterTypes()[0].equals(Integer.TYPE))) {
            throw new IntrospectionException("set index method has wrong parameters");
        }
        if (getIndex != null && setIndex != null) {
            if (!getIndex.getReturnType().equals(setIndex.getParameterTypes()[1])) {
                throw new IntrospectionException("set index methods do not share the same type");
            }
            if (!getIndex.getDeclaringClass().isAssignableFrom(setIndex.getDeclaringClass()) && !setIndex.getDeclaringClass().isAssignableFrom(getIndex.getDeclaringClass())) {
                throw new IntrospectionException("get and set index methods are not in the same class.");
            }
        }
        if (getIndex != null && getMethod != null && !getIndex.getDeclaringClass().isAssignableFrom(getMethod.getDeclaringClass()) && !getMethod.getDeclaringClass().isAssignableFrom(getIndex.getDeclaringClass())) {
            throw new IntrospectionException("methods are not in the same class.");
        }
        if (getIndex != null && getMethod != null && !Array.newInstance(getIndex.getReturnType(), 0).getClass().equals(getMethod.getReturnType())) {
            throw new IntrospectionException("array methods do not match index methods.");
        }
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.getIndex = getIndex;
        this.setIndex = setIndex;
        Class<?> clazz = this.indexedPropertyType = getIndex != null ? getIndex.getReturnType() : setIndex.getParameterTypes()[1];
        this.propertyType = getMethod != null ? getMethod.getReturnType() : (setMethod != null ? setMethod.getParameterTypes()[0] : Array.newInstance(this.indexedPropertyType, 0).getClass());
    }

    public Class<?> getIndexedPropertyType() {
        return this.indexedPropertyType;
    }

    public Method getIndexedReadMethod() {
        return this.getIndex;
    }

    public void setIndexedReadMethod(Method m) throws IntrospectionException {
        this.getIndex = m;
    }

    public Method getIndexedWriteMethod() {
        return this.setIndex;
    }

    public void setIndexedWriteMethod(Method m) throws IntrospectionException {
        this.setIndex = m;
    }

    private void findMethods(Class beanClass, String getMethodName, String setMethodName, String getIndexName, String setIndexName) throws IntrospectionException {
        try {
            if (getIndexName != null) {
                try {
                    Class[] getArgs = new Class[]{Integer.TYPE};
                    this.getIndex = beanClass.getMethod(getIndexName, getArgs);
                    this.indexedPropertyType = this.getIndex.getReturnType();
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (this.getIndex != null) {
                if (setIndexName != null) {
                    try {
                        Class[] setArgs = new Class[]{Integer.TYPE, this.indexedPropertyType};
                        this.setIndex = beanClass.getMethod(setIndexName, setArgs);
                        if (!this.setIndex.getReturnType().equals(Void.TYPE)) {
                            throw new IntrospectionException(String.valueOf(setIndexName) + " has non-void return type");
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            } else if (setIndexName != null) {
                Method[] m = beanClass.getMethods();
                int i = 0;
                while (i < m.length) {
                    Method current = m[i];
                    if (current.getName().equals(setIndexName) && current.getParameterTypes().length == 2 && current.getParameterTypes()[0].equals(Integer.TYPE) && current.getReturnType().equals(Void.TYPE)) {
                        if (this.setIndex != null) {
                            throw new IntrospectionException("Multiple, different set methods found that fit the bill!");
                        }
                        this.setIndex = current;
                        this.indexedPropertyType = current.getParameterTypes()[1];
                    }
                    ++i;
                }
                if (this.setIndex == null) {
                    throw new IntrospectionException("Cannot find get or set methods.");
                }
            } else {
                throw new IntrospectionException("Cannot find get or set methods.");
            }
            Class<? extends Object> arrayType = Array.newInstance(this.indexedPropertyType, 0).getClass();
            Class[] setArgs = new Class[]{arrayType};
            try {
                this.setMethod = beanClass.getMethod(setMethodName, setArgs);
                if (!this.setMethod.getReturnType().equals(Void.TYPE)) {
                    this.setMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            Class[] getArgs = new Class[]{};
            try {
                this.getMethod = beanClass.getMethod(getMethodName, getArgs);
                if (!this.getMethod.getReturnType().equals(arrayType)) {
                    this.getMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException("SecurityException while trying to find methods.");
        }
    }
}

