/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.HTTPDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Headers
implements Iterable<HeaderElement> {
    private final ArrayList<HeaderElement> headers = new ArrayList();
    private static final DateFormat dateFormat = new HTTPDateFormat();

    @Override
    public Iterator<HeaderElement> iterator() {
        return this.headers.iterator();
    }

    public String getValue(String header) {
        int i = this.headers.size() - 1;
        while (i >= 0) {
            HeaderElement e = this.headers.get(i);
            if (e.name.equalsIgnoreCase(header)) {
                return e.value;
            }
            --i;
        }
        return null;
    }

    public int getIntValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public long getLongValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return -1L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public Date getDateValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return null;
        }
        try {
            return dateFormat.parse(val);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void put(String name, String value) {
        int i = this.headers.size() - 1;
        while (i >= 0) {
            HeaderElement e = this.headers.get(i);
            if (e.name.equalsIgnoreCase(name)) {
                e.value = value;
                return;
            }
            --i;
        }
        this.addValue(name, value);
    }

    public void putAll(Headers o) {
        for (HeaderElement e : o) {
            this.remove(e.name);
            this.addValue(e.name, e.value);
        }
    }

    public void remove(String name) {
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            HeaderElement e = (HeaderElement)it.next();
            if (!e.name.equalsIgnoreCase(name)) continue;
            it.remove();
        }
    }

    public void parse(InputStream in) throws IOException {
        LineInputStream lin = in instanceof LineInputStream ? (LineInputStream)in : new LineInputStream(in);
        String name = null;
        CPStringBuilder value = new CPStringBuilder();
        while (true) {
            String line;
            if ((line = lin.readLine()) == null) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            int len = line.length();
            if (len < 2) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            char c1 = line.charAt(0);
            if (c1 == ' ' || c1 == '\t') {
                int last = len - 1;
                if (line.charAt(last) != '\r') {
                    ++last;
                }
                value.append(line.substring(0, last));
                continue;
            }
            if (name != null) {
                this.addValue(name, value.toString());
            }
            int di = line.indexOf(58);
            name = line.substring(0, di);
            value.setLength(0);
            while (++di < len && line.charAt(di) == ' ') {
            }
            int last = len - 1;
            if (line.charAt(last) != '\r') {
                ++last;
            }
            value.append(line.substring(di, last));
        }
    }

    public void addValue(String name, String value) {
        this.headers.add(this.headers.size(), new HeaderElement(name, value));
    }

    public Map<String, List<String>> getAsMap() {
        ArrayList l;
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        for (HeaderElement headerElement : this.headers) {
            l = (ArrayList)m.get(headerElement.name);
            if (l == null) {
                l = new ArrayList(1);
                l.add(headerElement.value);
                m.put(headerElement.name, l);
                continue;
            }
            l.add(0, headerElement.value);
        }
        for (Map.Entry entry : m.entrySet()) {
            l = (List)entry.getValue();
            entry.setValue(Collections.unmodifiableList(l));
        }
        return m;
    }

    public String getHeaderName(int i) {
        if (i >= this.headers.size() || i < 0) {
            return null;
        }
        return this.headers.get((int)i).name;
    }

    public String getHeaderValue(int i) {
        if (i >= this.headers.size() || i < 0) {
            return null;
        }
        return this.headers.get((int)i).value;
    }

    static class HeaderElement {
        String name;
        String value;

        HeaderElement(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

