/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.refactoring.IExceptionListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ChangeExceptionsControl
extends Composite {
    private final IExceptionListChangeListener fListener;
    private final IJavaProject fProject;
    private TableViewer fTableViewer;
    private Button fRemoveButton;
    private List fExceptionInfos;

    public ChangeExceptionsControl(Composite parent, int style, IExceptionListChangeListener listener, IJavaProject project) {
        super(parent, style);
        Assert.isNotNull((Object)listener);
        this.fListener = listener;
        Assert.isNotNull((Object)project);
        this.fProject = project;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createExceptionList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List exceptionInfos) {
        Assert.isNotNull((Object)exceptionInfos);
        this.fExceptionInfos = exceptionInfos;
        this.fTableViewer.setInput((Object)this.fExceptionInfos);
        if (this.fExceptionInfos.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fExceptionInfos.get(0)));
        }
    }

    private void createExceptionList(Composite parent) {
        Table table = new Table(parent, 2818);
        table.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ExceptionInfoContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ExceptionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeExceptionsControl.this.updateButtonsEnabledState();
            }
        });
    }

    private ExceptionInfo[] getSelectedItems() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection == null) {
            return new ExceptionInfo[0];
        }
        if (!(selection instanceof IStructuredSelection)) {
            return new ExceptionInfo[0];
        }
        List selected = ((IStructuredSelection)selection).toList();
        return selected.toArray(new ExceptionInfo[selected.size()]);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        this.createAddButton(buttonComposite);
        this.fRemoveButton = this.createRemoveButton(buttonComposite);
        this.updateButtonsEnabledState();
    }

    private void updateButtonsEnabledState() {
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createAddButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.ChangeExceptionsControl_buttons_add);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeExceptionsControl.this.doAddException();
            }
        });
        return button;
    }

    private void doAddException() {
        IType newException = this.chooseException();
        if (newException == null) {
            return;
        }
        ExceptionInfo info = this.findExceptionInfo(newException);
        if (info != null) {
            if (info.isDeleted()) {
                info.markAsOld();
                this.fTableViewer.refresh();
            }
            this.fListener.exceptionListChanged();
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)info), true);
            return;
        }
        info = ExceptionInfo.createInfoForAddedException(newException);
        this.fExceptionInfos.add(info);
        this.fListener.exceptionListChanged();
        this.fTableViewer.refresh();
        this.fTableViewer.getControl().setFocus();
        int row = this.getTableItemCount() - 1;
        this.getTable().setSelection(row);
        this.updateButtonsEnabledState();
    }

    private IType chooseException() {
        IJavaElement[] elements = new IJavaElement[]{this.fProject.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 5);
        dialog.setTitle(RefactoringMessages.ChangeExceptionsControl_choose_title);
        dialog.setMessage(RefactoringMessages.ChangeExceptionsControl_choose_message);
        dialog.setFilter("*Exception*");
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new StatusInfo(4, "");
                }
                try {
                    return ChangeExceptionsControl.this.checkException((IType)selection[0]);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return StatusInfo.OK_STATUS;
                }
            }
        });
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IStatus checkException(IType type) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType curr = type;
        while (curr != null) {
            String name = curr.getFullyQualifiedName();
            if ("java.lang.Throwable".equals(name)) {
                return StatusInfo.OK_STATUS;
            }
            curr = hierarchy.getSuperclass(curr);
        }
        return JavaUIStatus.createError(4, RefactoringMessages.ChangeExceptionsControl_not_exception, null);
    }

    private ExceptionInfo findExceptionInfo(IType exception) {
        for (ExceptionInfo info : this.fExceptionInfos) {
            if (!info.getType().equals(exception)) continue;
            return info;
        }
        return null;
    }

    private Button createRemoveButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.ChangeExceptionsControl_buttons_remove);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeExceptionsControl.this.getTable().getSelectionIndices()[0];
                ExceptionInfo[] selected = ChangeExceptionsControl.this.getSelectedItems();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i].isAdded()) {
                        ChangeExceptionsControl.this.fExceptionInfos.remove(selected[i]);
                    } else {
                        selected[i].markAsDeleted();
                    }
                    ++i;
                }
                this.restoreSelection(index);
            }

            private void restoreSelection(int index) {
                ChangeExceptionsControl.this.fTableViewer.refresh();
                ChangeExceptionsControl.this.fTableViewer.getControl().setFocus();
                int itemCount = ChangeExceptionsControl.this.getTableItemCount();
                if (itemCount != 0) {
                    if (index >= itemCount) {
                        index = itemCount - 1;
                    }
                    ChangeExceptionsControl.this.getTable().setSelection(index);
                }
                ChangeExceptionsControl.this.fListener.exceptionListChanged();
                ChangeExceptionsControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private static class ExceptionInfoContentProvider
    implements IStructuredContentProvider {
        private ExceptionInfoContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.removeMarkedAsDeleted((List)inputElement);
        }

        private ExceptionInfo[] removeMarkedAsDeleted(List exceptionInfos) {
            ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(exceptionInfos.size());
            for (ExceptionInfo info : exceptionInfos) {
                if (info.isDeleted()) continue;
                result.add(info);
            }
            return result.toArray(new ExceptionInfo[result.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ExceptionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get("org.eclipse.jdt.ui.class_obj.gif");

        public Image getColumnImage(Object element, int columnIndex) {
            return this.fInterfaceImage;
        }

        public String getColumnText(Object element, int columnIndex) {
            ExceptionInfo info = (ExceptionInfo)element;
            return info.getType().getFullyQualifiedName();
        }
    }
}

