/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;

public class DefaultRubyFoldingStructureProvider
implements IProjectionListener,
IRubyFoldingStructureProvider {
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private IDocument fCachedDocument;
    private ProjectionAnnotationModel fCachedModel;
    private boolean fAllowCollapsing;
    private IRubyElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fCollapseInnerTypes;
    private boolean fCollapseRubydoc;
    private boolean fCollapseMethods;
    static /* synthetic */ Class class$0;

    public void install(ITextEditor iTextEditor, ProjectionViewer projectionViewer) {
        if (iTextEditor instanceof RubyAbstractEditor) {
            this.fEditor = iTextEditor;
            this.fViewer = projectionViewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        try {
            IWorkingCopyManager iWorkingCopyManager;
            IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = true;
            if (this.fEditor instanceof RubyEditor) {
                iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
                this.fInput = iWorkingCopyManager.getWorkingCopy(this.fEditor.getEditorInput());
            }
            if (this.fInput != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iWorkingCopyManager = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) != null) {
                    Object object;
                    Object object2;
                    this.fCachedModel = iWorkingCopyManager;
                    if (this.fInput instanceof IRubyScript) {
                        object2 = (IRubyScript)this.fInput;
                        object = object2;
                        synchronized (object) {
                            try {
                                object2.reconcile();
                            }
                            catch (RubyModelException rubyModelException) {}
                        }
                    }
                    object2 = this.computeAdditions((IParent)this.fInput);
                    object = new LinkedList();
                    Iterator iterator = iWorkingCopyManager.getAnnotationIterator();
                    while (iterator.hasNext()) {
                        object.add(iterator.next());
                    }
                    iWorkingCopyManager.replaceAnnotations(object.toArray(new Annotation[object.size()]), (Map)object2);
                }
            }
            Object var6_8 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
            this.fCachedModel = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
            this.fCachedModel = null;
            throw throwable;
        }
    }

    private Map computeAdditions(IParent iParent) {
        HashMap hashMap = new HashMap();
        try {
            this.computeAdditions(iParent.getChildren(), hashMap);
        }
        catch (RubyModelException rubyModelException) {
            RubyPlugin.log(rubyModelException);
        }
        return hashMap;
    }

    private void computeAdditions(IRubyElement[] iRubyElementArray, Map map) throws RubyModelException {
        int n = 0;
        while (n < iRubyElementArray.length) {
            IRubyElement iRubyElement = iRubyElementArray[n];
            this.computeAdditions(iRubyElement, map);
            if (iRubyElement instanceof IParent) {
                IParent iParent = (IParent)iRubyElement;
                this.computeAdditions(iParent.getChildren(), map);
            }
            ++n;
        }
    }

    private void computeAdditions(IRubyElement iRubyElement, Map map) {
        IRegion[] iRegionArray;
        boolean bl = false;
        boolean bl2 = false;
        switch (iRubyElement.getElementType()) {
            case 3: {
                bl2 = this.fAllowCollapsing && this.fCollapseInnerTypes && this.isInnerType((IType)iRubyElement);
                bl = true;
                break;
            }
            case 4: {
                bl2 = this.fAllowCollapsing && this.fCollapseMethods;
                bl = true;
            }
        }
        if (bl && (iRegionArray = this.computeProjectionRanges(iRubyElement)) != null) {
            int n = 0;
            while (n < iRegionArray.length - 1) {
                Position position = this.createProjectionPosition(iRegionArray[n]);
                if (position != null) {
                    map.put(new RubyProjectionAnnotation(iRubyElement, this.fAllowCollapsing && this.fCollapseRubydoc, true), position);
                }
                ++n;
            }
            Position position = this.createProjectionPosition(iRegionArray[iRegionArray.length - 1]);
            if (position != null) {
                map.put(new RubyProjectionAnnotation(iRubyElement, bl2, false), position);
            }
        }
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = iPreferenceStore.getBoolean("editor_folding_default_innertypes");
        this.fCollapseRubydoc = iPreferenceStore.getBoolean("editor_folding_default_rdoc");
        this.fCollapseMethods = iPreferenceStore.getBoolean("editor_folding_default_methods");
    }

    private boolean isInnerType(IType iType) {
        IRubyElement iRubyElement = iType.getParent();
        if (iRubyElement != null) {
            int n = iRubyElement.getElementType();
            return n != 2;
        }
        return false;
    }

    private IRegion[] computeProjectionRanges(IRubyElement iRubyElement) {
        try {
            if (iRubyElement instanceof ISourceReference) {
                int n;
                ISourceReference iSourceReference = (ISourceReference)iRubyElement;
                ISourceRange iSourceRange = iSourceReference.getSourceRange();
                ArrayList<Region> arrayList = new ArrayList<Region>();
                int n2 = n = iSourceRange.getOffset();
                arrayList.add(new Region(n2, iSourceRange.getOffset() + iSourceRange.getLength() - n2));
                if (arrayList.size() > 0) {
                    IRegion[] iRegionArray = new IRegion[arrayList.size()];
                    arrayList.toArray(iRegionArray);
                    return iRegionArray;
                }
            }
        }
        catch (RubyModelException rubyModelException) {}
        return null;
    }

    private Position createProjectionPosition(IRegion iRegion) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int n = this.fCachedDocument.getLineOfOffset(iRegion.getOffset());
            int n2 = this.fCachedDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
            if (n != n2) {
                int n3 = this.fCachedDocument.getLineOffset(n);
                int n4 = this.fCachedDocument.getLineOffset(n2 + 1);
                return new Position(n3, n4 - n3);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof RubyAbstractEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            RubyCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fElementListener != null) {
            RubyCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processDelta(IRubyElementDelta iRubyElementDelta) {
        ProjectionAnnotationModel projectionAnnotationModel;
        if (!this.isInstalled()) {
            return;
        }
        if ((iRubyElementDelta.getFlags() & 9) == 0) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((projectionAnnotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) == null) {
            return;
        }
        try {
            Annotation[] annotationArray;
            Object object;
            IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput());
            this.fCachedModel = projectionAnnotationModel;
            this.fAllowCollapsing = false;
            HashMap<Object, Position> hashMap = new HashMap<Object, Position>();
            ArrayList<RubyProjectionAnnotation> arrayList = new ArrayList<RubyProjectionAnnotation>();
            ArrayList<RubyProjectionAnnotation> arrayList2 = new ArrayList<RubyProjectionAnnotation>();
            Map map = this.computeAdditions((IParent)this.fInput);
            Map map2 = this.createAnnotationMap((IAnnotationModel)projectionAnnotationModel);
            Iterator<Object> iterator = map.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                object = (RubyProjectionAnnotation)((Object)iterator.next());
                annotationArray = ((RubyProjectionAnnotation)((Object)object)).getElement();
                Position position = (Position)map.get(object);
                List list = (List)map2.get(annotationArray);
                if (list == null) {
                    hashMap.put(object, position);
                    continue;
                }
                Iterator iterator2 = list.iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Tuple tuple = (Tuple)iterator2.next();
                    RubyProjectionAnnotation rubyProjectionAnnotation = tuple.annotation;
                    Position position2 = tuple.position;
                    if (((RubyProjectionAnnotation)((Object)object)).isComment() != rubyProjectionAnnotation.isComment()) continue;
                    if (position2 != null && !position.equals((Object)position2)) {
                        position2.setOffset(position.getOffset());
                        position2.setLength(position.getLength());
                        arrayList2.add(rubyProjectionAnnotation);
                    }
                    bl = true;
                    iterator2.remove();
                    break;
                }
                if (!bl) {
                    hashMap.put(object, position);
                }
                if (!list.isEmpty()) continue;
                map2.remove(annotationArray);
            }
            iterator = map2.values().iterator();
            block7: while (true) {
                block16: {
                    if (iterator.hasNext()) break block16;
                    this.match(arrayList, hashMap, arrayList2);
                    object = new Annotation[arrayList.size()];
                    arrayList.toArray((T[])object);
                    annotationArray = new Annotation[arrayList2.size()];
                    arrayList2.toArray(annotationArray);
                    projectionAnnotationModel.modifyAnnotations((Annotation[])object, hashMap, annotationArray);
                    break;
                }
                object = (List)iterator.next();
                int n = object.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block7;
                    arrayList.add(((Tuple)object.get((int)n2)).annotation);
                    ++n2;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            this.fCachedModel = null;
            throw throwable;
        }
        {
            Object var19_23 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            this.fCachedModel = null;
            return;
        }
    }

    private Map createAnnotationMap(IAnnotationModel iAnnotationModel) {
        Object object;
        Object object2;
        Object object3;
        HashMap<IRubyElement, ArrayList<Tuple>> hashMap = new HashMap<IRubyElement, ArrayList<Tuple>>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!(object3 instanceof RubyProjectionAnnotation)) continue;
            object2 = (RubyProjectionAnnotation)((Object)object3);
            object = iAnnotationModel.getPosition((Annotation)object2);
            Assert.isNotNull((Object)object);
            ArrayList<Tuple> arrayList = (ArrayList<Tuple>)hashMap.get(((RubyProjectionAnnotation)((Object)object2)).getElement());
            if (arrayList == null) {
                arrayList = new ArrayList<Tuple>(2);
                hashMap.put(((RubyProjectionAnnotation)((Object)object2)).getElement(), arrayList);
            }
            arrayList.add(new Tuple((RubyProjectionAnnotation)((Object)object2), (Position)object));
        }
        object3 = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Tuple)object).position.getOffset() - ((Tuple)object2).position.getOffset();
            }
        };
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            object = (List)object2.next();
            Collections.sort(object, object3);
        }
        return hashMap;
    }

    private void match(List list, Map map, List list2) {
        if (list.isEmpty() || map.isEmpty() && list2.isEmpty()) {
            return;
        }
        ArrayList<RubyProjectionAnnotation> arrayList = new ArrayList<RubyProjectionAnnotation>();
        ArrayList<RubyProjectionAnnotation> arrayList2 = new ArrayList<RubyProjectionAnnotation>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RubyProjectionAnnotation rubyProjectionAnnotation = (RubyProjectionAnnotation)((Object)iterator.next());
            Position position = this.fCachedModel.getPosition((Annotation)rubyProjectionAnnotation);
            if (position == null) continue;
            Tuple tuple = new Tuple(rubyProjectionAnnotation, position);
            Tuple tuple2 = this.findMatch(tuple, list2, null);
            boolean bl = true;
            if (tuple2 == null) {
                tuple2 = this.findMatch(tuple, map.keySet(), map);
                bl = false;
            }
            if (tuple2 == null) continue;
            IRubyElement iRubyElement = tuple2.annotation.getElement();
            rubyProjectionAnnotation.setElement(iRubyElement);
            position.setLength(tuple2.position.getLength());
            if (position instanceof RubyElementPosition && iRubyElement instanceof IMember) {
                RubyElementPosition rubyElementPosition = (RubyElementPosition)position;
                rubyElementPosition.setMember((IMember)iRubyElement);
            }
            iterator.remove();
            arrayList2.add(rubyProjectionAnnotation);
            if (!bl) continue;
            arrayList.add(tuple2.annotation);
        }
        list.addAll(arrayList);
        list2.addAll(arrayList2);
    }

    private Tuple findMatch(Tuple tuple, Collection collection, Map map) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Position position;
            RubyProjectionAnnotation rubyProjectionAnnotation = (RubyProjectionAnnotation)((Object)iterator.next());
            if (tuple.annotation.isComment() != rubyProjectionAnnotation.isComment()) continue;
            Position position2 = position = map == null ? this.fCachedModel.getPosition((Annotation)rubyProjectionAnnotation) : (Position)map.get((Object)rubyProjectionAnnotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            iterator.remove();
            return new Tuple(rubyProjectionAnnotation, position);
        }
        return null;
    }

    private static final class Tuple {
        RubyProjectionAnnotation annotation;
        Position position;

        Tuple(RubyProjectionAnnotation rubyProjectionAnnotation, Position position) {
            this.annotation = rubyProjectionAnnotation;
            this.position = position;
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            IRubyElementDelta iRubyElementDelta = this.findElement(DefaultRubyFoldingStructureProvider.this.fInput, elementChangedEvent.getDelta());
            if (iRubyElementDelta != null) {
                DefaultRubyFoldingStructureProvider.this.processDelta(iRubyElementDelta);
            }
        }

        private IRubyElementDelta findElement(IRubyElement iRubyElement, IRubyElementDelta iRubyElementDelta) {
            if (iRubyElementDelta == null || iRubyElement == null) {
                return null;
            }
            IRubyElement iRubyElement2 = iRubyElementDelta.getElement();
            if (iRubyElement2.getElementType() > 2) {
                return null;
            }
            if (iRubyElement.equals(iRubyElement2)) {
                return iRubyElementDelta;
            }
            IRubyElementDelta[] iRubyElementDeltaArray = iRubyElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iRubyElementDeltaArray.length) {
                IRubyElementDelta iRubyElementDelta2 = this.findElement(iRubyElement, iRubyElementDeltaArray[n]);
                if (iRubyElementDelta2 != null) {
                    return iRubyElementDelta2;
                }
                ++n;
            }
            return null;
        }
    }

    private static class RubyProjectionAnnotation
    extends ProjectionAnnotation {
        private IRubyElement fRubyElement;
        private boolean fIsComment;

        public RubyProjectionAnnotation(IRubyElement iRubyElement, boolean bl, boolean bl2) {
            super(bl);
            this.fRubyElement = iRubyElement;
            this.fIsComment = bl2;
        }

        public IRubyElement getElement() {
            return this.fRubyElement;
        }

        public void setElement(IRubyElement iRubyElement) {
            this.fRubyElement = iRubyElement;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean bl) {
            this.fIsComment = bl;
        }
    }

    private static final class RubyElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public RubyElementPosition(int n, int n2, IMember iMember) {
            super(n, n2);
            Assert.isNotNull((Object)iMember);
            this.fMember = iMember;
        }

        public void setMember(IMember iMember) {
            Assert.isNotNull((Object)iMember);
            this.fMember = iMember;
        }

        public IRegion[] computeProjectionRegions(IDocument iDocument) throws BadLocationException {
            Region region;
            IRegion iRegion;
            int n;
            int n2 = this.offset;
            try {
                ISourceRange iSourceRange = this.fMember.getNameRange();
                if (iSourceRange != null) {
                    n2 = iSourceRange.getOffset();
                }
            }
            catch (RubyModelException rubyModelException) {}
            int n3 = iDocument.getLineOfOffset(this.offset);
            int n4 = iDocument.getLineOfOffset(n2);
            int n5 = iDocument.getLineOfOffset(this.offset + this.length);
            if (n4 < n3) {
                n4 = n3;
            }
            if (n4 > n5) {
                n4 = n5;
            }
            if (n3 < n4) {
                n = iDocument.getLineOffset(n3);
                iRegion = iDocument.getLineInformation(n4);
                int n6 = iRegion.getOffset();
                region = new Region(n, n6 - n);
            } else {
                region = null;
            }
            if (n4 < n5) {
                n = iDocument.getLineOffset(n4 + 1);
                iRegion = new Region(n, this.offset + this.length - n);
                if (region == null) {
                    return new IRegion[]{iRegion};
                }
                return new IRegion[]{region, iRegion};
            }
            if (region != null) {
                return new IRegion[]{region};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument iDocument) throws BadLocationException {
            int n = this.offset;
            try {
                ISourceRange iSourceRange = this.fMember.getNameRange();
                if (iSourceRange != null) {
                    n = iSourceRange.getOffset();
                }
            }
            catch (RubyModelException rubyModelException) {}
            return n - this.offset;
        }
    }
}

