/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;

public class FindSleepWithLockHeld
implements Detector {
    private BugReporter bugReporter;

    public FindSleepWithLockHeld(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.getCode() == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindSleepWithLockHeld caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindSleepWithLockHeld caught exception", (Throwable)e);
            }
        }
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        if (!bytecodeSet.get(194) && !method.isSynchronized()) {
            return false;
        }
        return bytecodeSet.get(184);
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        LockDataflow lockDataflow = classContext.getLockDataflow(method);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            LockSet lockSet;
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof INVOKESTATIC) || !this.isSleep((INVOKESTATIC)ins, classContext.getConstantPoolGen()) || (lockSet = lockDataflow.getFactAtLocation(location)).getNumLockedObjects() <= 0) continue;
            this.bugReporter.reportBug(new BugInstance("SWL_SLEEP_WITH_LOCK_HELD", 2).addClassAndMethod(classContext.getJavaClass(), method).addSourceLine(classContext, method, location));
        }
    }

    private boolean isSleep(INVOKESTATIC ins, ConstantPoolGen cpg) {
        String className = ins.getClassName(cpg);
        if (!className.equals("java.lang.Thread")) {
            return false;
        }
        String methodName = ins.getMethodName(cpg);
        String signature = ins.getSignature(cpg);
        return methodName.equals("sleep") && (signature.equals("(J)V") || signature.equals("(JI)V"));
    }

    public void report() {
    }
}

