/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.util.HttpHead;

public class ZipCache {
    static boolean cacheEnabled = true;
    private static final Primitive DISABLE_ZIP_CACHE = new disable_zip_cache();
    static HashMap<URL, Entry> zipCache = new HashMap();
    static final SimpleDateFormat ASCTIME = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    static final SimpleDateFormat RFC_1036 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
    static final SimpleDateFormat RFC_1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final Primitive REMOVE_ZIP_CACHE_ENTRY = new remove_zip_cache_entry();

    public static synchronized void disable() {
        cacheEnabled = false;
        zipCache.clear();
    }

    public static synchronized ZipFile get(Pathname p) {
        return ZipCache.get(Pathname.makeURL(p));
    }

    public static synchronized ZipFile get(URL url) {
        Entry entry;
        block28: {
            if (!cacheEnabled) {
                if (url.getProtocol().equals("file")) {
                    File f = new File(url.getPath());
                    try {
                        return new ZipFile(f);
                    }
                    catch (ZipException e) {
                        Lisp.error(new FileError("Failed to construct ZipFile because " + e, Pathname.makePathname(f)));
                        break block28;
                    }
                    catch (IOException e) {
                        Lisp.error(new FileError("Failed to contruct ZipFile because " + e, Pathname.makePathname(f)));
                        break block28;
                    }
                }
                Entry e = ZipCache.fetchURL(url, false);
                return e.file;
            }
        }
        if ((entry = zipCache.get(url)) != null) {
            try {
                int size = entry.file.size();
            }
            catch (IllegalStateException e) {
                zipCache.remove(url);
                entry = null;
            }
        }
        if (entry != null) {
            if (url.getProtocol().equals("file")) {
                File f = new File(url.getPath());
                long current = f.lastModified();
                if (current > entry.lastModified) {
                    try {
                        entry.file = new ZipFile(f);
                        entry.lastModified = current;
                    }
                    catch (IOException e) {
                        Debug.trace(e.toString());
                    }
                }
            } else if (url.getProtocol().equals("http")) {
                String dateString = HttpHead.get(url, "Last-Modified");
                Date date = null;
                ParsePosition pos = new ParsePosition(0);
                if (dateString != null && (date = RFC_1123.parse(dateString, pos)) == null && (date = RFC_1036.parse(dateString, pos)) == null) {
                    date = ASCTIME.parse(dateString, pos);
                }
                if (date == null || date.getTime() > entry.lastModified) {
                    entry = ZipCache.fetchURL(url, false);
                    zipCache.put(url, entry);
                }
                if (date == null) {
                    if (dateString == null) {
                        Debug.trace("Failed to retrieve request header: " + url.toString());
                    } else {
                        Debug.trace("Failed to parse Last-Modified date: " + dateString);
                    }
                }
            } else {
                entry = ZipCache.fetchURL(url, false);
                zipCache.put(url, entry);
            }
        } else {
            if (url.getProtocol().equals("file")) {
                String authority;
                entry = new Entry();
                String path = url.getPath();
                if (Utilities.isPlatformWindows && (authority = url.getAuthority()) != null) {
                    path = authority + path;
                }
                File f = new File(path);
                entry.lastModified = f.lastModified();
                try {
                    entry.file = new ZipFile(f);
                }
                catch (ZipException e) {
                    Lisp.error(new FileError("Failed to get cached ZipFile because " + e, Pathname.makePathname(f)));
                }
                catch (IOException e) {
                    Lisp.error(new FileError("Failed to get cached ZipFile because " + e, Pathname.makePathname(f)));
                }
            } else {
                entry = ZipCache.fetchURL(url, true);
            }
            zipCache.put(url, entry);
        }
        return entry.file;
    }

    private static Entry fetchURL(URL url, boolean cached) {
        Entry result = new Entry();
        URL jarURL = null;
        try {
            jarURL = new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            Lisp.error(new LispError("Failed to form a jar: URL from '" + url + "'" + " because " + e));
        }
        URLConnection connection = null;
        try {
            connection = jarURL.openConnection();
        }
        catch (IOException e) {
            Lisp.error(new LispError("Failed to open '" + jarURL + "'" + " with exception " + e));
        }
        if (!(connection instanceof JarURLConnection)) {
            Lisp.error(new LispError("Could not get a URLConnection from '" + jarURL + "'"));
        }
        JarURLConnection jarURLConnection = (JarURLConnection)connection;
        jarURLConnection.setUseCaches(cached);
        try {
            result.file = jarURLConnection.getJarFile();
        }
        catch (IOException e) {
            Lisp.error(new LispError("Failed to fetch URL '" + jarURLConnection + "'" + " because " + e));
        }
        result.lastModified = jarURLConnection.getLastModified();
        return result;
    }

    public static synchronized boolean remove(URL url) {
        Entry entry = zipCache.get(url);
        if (entry != null) {
            try {
                entry.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            zipCache.remove(entry);
            return true;
        }
        return false;
    }

    public static synchronized boolean remove(Pathname p) {
        URL url = Pathname.makeURL(p);
        if (url == null) {
            return false;
        }
        return ZipCache.remove(url);
    }

    public static synchronized boolean remove(File f) {
        Pathname p = Pathname.makePathname(f);
        return ZipCache.remove(p);
    }

    private static class remove_zip_cache_entry
    extends Primitive {
        remove_zip_cache_entry() {
            super("remove-zip-cache-entry", Lisp.PACKAGE_SYS, true, "pathname");
        }

        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            boolean result = ZipCache.remove(p);
            return result ? Lisp.T : Lisp.NIL;
        }
    }

    static final class disable_zip_cache
    extends Primitive {
        disable_zip_cache() {
            super("disable-zip-cache", Lisp.PACKAGE_SYS, true, "", "Disable all caching of ABCL FASLs and ZIPs.");
        }

        public LispObject execute() {
            ZipCache.disable();
            return Lisp.T;
        }
    }

    static class Entry {
        long lastModified;
        ZipFile file;

        Entry() {
        }
    }
}

