/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProgramError;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZipCache;

public class Pathname
extends LispObject {
    public static final char separator = '/';
    protected LispObject host = Lisp.NIL;
    protected LispObject device = Lisp.NIL;
    protected LispObject directory = Lisp.NIL;
    protected LispObject name = Lisp.NIL;
    protected LispObject type = Lisp.NIL;
    protected LispObject version = Lisp.NIL;
    private volatile String namestring;
    private static final Primitive _INVALIDATE_NAMESTRING = new pf_invalidate_namestring();
    static final Symbol SCHEME = Lisp.internKeyword("SCHEME");
    static final Symbol AUTHORITY = Lisp.internKeyword("AUTHORITY");
    static final Symbol QUERY = Lisp.internKeyword("QUERY");
    static final Symbol FRAGMENT = Lisp.internKeyword("FRAGMENT");
    private static final String jarSeparator = "!/";
    public static HashTable LOGICAL_PATHNAME_TRANSLATIONS = HashTable.newEqualHashTable(64, Lisp.NIL, Lisp.NIL);
    private static final Symbol _LOGICAL_PATHNAME_TRANSLATIONS_ = Lisp.exportSpecial("*LOGICAL-PATHNAME-TRANSLATIONS*", Lisp.PACKAGE_SYS, LOGICAL_PATHNAME_TRANSLATIONS);
    private static final Primitive _PATHNAME_HOST = new pf_pathname_host();
    private static final Primitive _PATHNAME_DEVICE = new pf_pathname_device();
    private static final Primitive _PATHNAME_DIRECTORY = new pf_pathname_directory();
    private static final Primitive _PATHNAME_NAME = new pf_pathname_name();
    private static final Primitive _PATHNAME_TYPE = new pf_pathname_type();
    private static final Primitive PATHNAME_VERSION = new pf_pathname_version();
    private static final Primitive NAMESTRING = new pf_namestring();
    private static final Primitive DIRECTORY_NAMESTRING = new pf_directory_namestring();
    private static final Primitive PATHNAME = new pf_pathname();
    private static final Primitive _PARSE_NAMESTRING = new pf_parse_namestring();
    private static final Primitive MAKE_PATHNAME = new pf_make_pathname();
    private static final Primitive PATHNAMEP = new pf_pathnamep();
    private static final Primitive LOGICAL_PATHNAME_P = new pf_logical_pathname_p();
    private static final Primitive USER_HOMEDIR_PATHNAME = new pf_user_homedir_pathname();
    private static final Primitive LIST_DIRECTORY = new pf_list_directory();
    @DocString(name="match-wild-jar-pathname", args="wild-jar-pathname", returns="pathnames", doc="Returns the pathnames matching WILD-JAR-PATHNAME which is both wild and a jar-pathname.")
    static final Primitive MATCH_WILD_JAR_PATHNAME = new pf_match_wild_jar_pathname();
    @DocString(name="pathname-jar-p", args="pathname", returns="generalized-boolean", doc="Predicate functionfor whether PATHNAME references a jar.")
    private static final Primitive PATHNAME_JAR_P = new pf_pathname_jar_p();
    @DocString(name="pathname-url-p", args="pathname", returns="generalized-boolean", doc="Predicate function for whether PATHNAME references a jaurl.")
    private static final Primitive PATHNAME_URL_P = new pf_pathname_url_p();
    private static final Primitive _WILD_PATHNAME_P = new pf_wild_pathname_p();
    static final Primitive MERGE_PATHNAMES = new pf_merge_pathnames();
    public static final Primitive GET_INPUT_STREAM = new pf_get_input_stream();
    private static final Primitive MKDIR = new pf_mkdir();
    private static final Primitive RENAME_FILE = new pf_rename_file();
    private static final Primitive FILE_NAMESTRING = new pf_file_namestring();
    private static final Primitive HOST_NAMESTRING = new pf_host_namestring();
    @DocString(name="uri-decode", args="string", returns="string", doc="Decode STRING percent escape sequences in the manner of URI encodings.")
    private static final Primitive URI_DECODE;
    @DocString(name="uri-encode", args="string", returns="string", doc="Encode percent escape sequences in the manner of URI encodings.")
    private static final Primitive URI_ENCODE;

    public void invalidateNamestring() {
        this.namestring = null;
    }

    protected Pathname() {
    }

    protected Pathname(Pathname p) {
        if (p.host != Lisp.NIL) {
            if (p.host instanceof SimpleString) {
                this.host = new SimpleString(((SimpleString)p.host).getStringValue());
            } else if (p.host instanceof Symbol) {
                this.host = p.host;
            } else if (p.host instanceof Cons) {
                this.host = new Cons((Cons)p.host);
            } else {
                Debug.assertTrue(false);
            }
        }
        if (p.device != Lisp.NIL) {
            if (p.device instanceof SimpleString) {
                this.device = new SimpleString(((SimpleString)p.device).getStringValue());
            } else if (p.device instanceof Cons) {
                Cons jars = (Cons)p.device;
                this.device = new Cons(Lisp.NIL, (LispObject)Lisp.NIL);
                LispObject first = jars.car();
                if (first instanceof Pathname) {
                    ((Cons)this.device).car = new Pathname((Pathname)first);
                } else {
                    Debug.assertTrue(false);
                }
                if (!jars.cdr().equals(Lisp.NIL)) {
                    if (jars.cdr() instanceof Cons) {
                        ((Cons)this.device).cdr = new Cons(new Pathname((Pathname)jars.cdr().car()), (LispObject)Lisp.NIL);
                    } else {
                        Debug.assertTrue(false);
                    }
                }
            } else if (p.device instanceof Symbol) {
                this.device = p.device;
            } else {
                Debug.assertTrue(false);
            }
        }
        if (p.directory != Lisp.NIL) {
            if (p.directory instanceof Cons) {
                this.directory = Lisp.NIL;
                for (LispObject list = p.directory; list != Lisp.NIL; list = list.cdr()) {
                    LispObject o = list.car();
                    if (o instanceof Symbol) {
                        this.directory = this.directory.push(o);
                        continue;
                    }
                    if (o instanceof SimpleString) {
                        this.directory = this.directory.push(new SimpleString(((SimpleString)o).getStringValue()));
                        continue;
                    }
                    Debug.assertTrue(false);
                }
                this.directory.nreverse();
            } else {
                Debug.assertTrue(false);
            }
        }
        if (p.name != Lisp.NIL) {
            if (p.name instanceof SimpleString) {
                this.name = new SimpleString(((SimpleString)p.name).getStringValue());
            } else if (p.name instanceof Symbol) {
                this.name = p.name;
            } else {
                Debug.assertTrue(false);
            }
        }
        if (p.type != Lisp.NIL) {
            if (p.type instanceof SimpleString) {
                this.type = new SimpleString(((SimpleString)p.type).getStringValue());
            } else if (p.type instanceof Symbol) {
                this.type = p.type;
            } else {
                Debug.assertTrue(false);
            }
        }
        if (p.version != Lisp.NIL) {
            if (p.version instanceof Symbol) {
                this.version = p.version;
            } else if (p.version instanceof LispInteger) {
                this.version = p.version;
            } else {
                Debug.assertTrue(false);
            }
        }
    }

    public Pathname(String s) {
        this.init(s);
    }

    public static boolean isSupportedProtocol(String protocol) {
        if ("jar".equals(protocol) || "file".equals(protocol)) {
            return true;
        }
        try {
            new URL(protocol, "example.org", "foo");
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Pathname(URL url) {
        this.init(url.toString());
    }

    private final void init(String s) {
        if (s == null) {
            return;
        }
        if (s.equals(".") || s.equals("./") || Utilities.isPlatformWindows && s.equals(".\\")) {
            this.directory = new Cons(Keyword.RELATIVE);
            return;
        }
        if (s.equals("..") || s.equals("../")) {
            this.directory = Lisp.list(Keyword.RELATIVE, Keyword.UP);
            return;
        }
        if (Utilities.isPlatformWindows && s.startsWith("\\\\")) {
            int shareIndex = s.indexOf(92, 2);
            int dirIndex = s.indexOf(92, shareIndex + 1);
            if (shareIndex == -1 || dirIndex == -1) {
                Lisp.error(new LispError("Unsupported UNC path format: \"" + s + '\"'));
            }
            this.host = new SimpleString(s.substring(2, shareIndex));
            this.device = new SimpleString(s.substring(shareIndex + 1, dirIndex));
            Pathname p = new Pathname(s.substring(dirIndex));
            this.directory = p.directory;
            this.name = p.name;
            this.type = p.type;
            this.version = p.version;
            this.invalidateNamestring();
            return;
        }
        if (s.startsWith("jar:") && s.endsWith(jarSeparator)) {
            LispObject jars = Lisp.NIL;
            int i = s.lastIndexOf(jarSeparator, s.length() - jarSeparator.length() - 1);
            String jar = null;
            if (i == -1) {
                jar = s;
            } else {
                jar = "jar:file:" + s.substring(i + jarSeparator.length());
                s = s.substring("jar:".length(), i + jarSeparator.length());
                Pathname p = new Pathname(s);
                jars = jars.push(p.device.car());
            }
            if (jar.startsWith("jar:file:")) {
                Pathname jarPathname;
                String file = jar.substring("jar:file:".length(), jar.length() - jarSeparator.length());
                if (file.length() > 0) {
                    URL url = null;
                    URI uri = null;
                    try {
                        url = new URL("file:" + file);
                        uri = url.toURI();
                    }
                    catch (MalformedURLException e1) {
                        Lisp.error(new SimpleError("Failed to create URI from '" + file + "'" + ": " + e1.getMessage()));
                    }
                    catch (URISyntaxException e2) {
                        Lisp.error(new SimpleError("Failed to create URI from '" + file + "'" + ": " + e2.getMessage()));
                    }
                    String path = uri.getPath();
                    jarPathname = path == null ? new Pathname(uri.getSchemeSpecificPart()) : new Pathname(new File(path).getPath());
                } else {
                    jarPathname = new Pathname("");
                }
                jars = jars.push(jarPathname);
            } else {
                URL url = null;
                try {
                    url = new URL(jar.substring("jar:".length(), jar.length() - 2));
                    Pathname p = new Pathname(url);
                    jars = jars.push(p);
                }
                catch (MalformedURLException e) {
                    Lisp.error(new LispError("Failed to parse URL '" + url + "'" + e.getMessage()));
                }
            }
            jars = jars.nreverse();
            this.device = jars;
            this.invalidateNamestring();
            return;
        }
        int separatorIndex = s.lastIndexOf(jarSeparator);
        if (separatorIndex > 0 && s.startsWith("jar:")) {
            String jarURL = s.substring(0, separatorIndex + jarSeparator.length());
            URL url = null;
            try {
                url = new URL(jarURL);
            }
            catch (MalformedURLException ex) {
                Lisp.error(new LispError("Failed to parse URL '" + jarURL + "'" + ex.getMessage()));
            }
            Pathname d = new Pathname(url);
            if (this.device instanceof Cons) {
                LispObject[] jars = d.copyToArray();
                Debug.assertTrue(false);
            } else {
                this.device = d.device;
            }
            s = "/" + s.substring(separatorIndex + jarSeparator.length());
            Pathname p = new Pathname("file:" + s);
            this.directory = p.directory;
            this.name = p.name;
            this.type = p.type;
            this.version = p.version;
            return;
        }
        if (Pathname.isValidURL(s)) {
            String fragment;
            String query;
            URL url = null;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e) {
                Debug.assertTrue(false);
            }
            String scheme = url.getProtocol();
            if (scheme.equals("file")) {
                URI uri = null;
                try {
                    uri = url.toURI();
                }
                catch (URISyntaxException ex) {
                    Lisp.error(new SimpleError("Improper URI syntax for '" + url.toString() + "'" + ": " + ex.toString()));
                }
                String uriPath = uri.getPath();
                if (null == uriPath && ((uriPath = uri.getSchemeSpecificPart()) == null || uriPath.equals(""))) {
                    Lisp.error(new LispError("The URI has no path: " + uri));
                }
                File file = new File(uriPath);
                Pathname p = new Pathname(file.getPath());
                this.host = p.host;
                this.device = p.device;
                this.directory = p.directory;
                this.name = p.name;
                this.type = p.type;
                this.version = p.version;
                return;
            }
            Debug.assertTrue(scheme != null);
            URI uri = null;
            try {
                uri = url.toURI().normalize();
            }
            catch (URISyntaxException e) {
                Lisp.error(new LispError("Couldn't form URI from '" + url + "'" + " because: " + e));
            }
            String authority = uri.getAuthority();
            if (authority == null && (authority = url.getAuthority()) == null) {
                Debug.trace(MessageFormat.format("{0} has a null authority.", url));
            }
            this.host = Lisp.NIL;
            this.host = this.host.push(SCHEME);
            this.host = this.host.push(new SimpleString(scheme));
            if (authority != null) {
                this.host = this.host.push(AUTHORITY);
                this.host = this.host.push(new SimpleString(authority));
            }
            this.device = Lisp.NIL;
            String path = uri.getRawPath();
            if (path == null) {
                path = "";
            }
            if ((query = uri.getRawQuery()) != null) {
                this.host = this.host.push(QUERY);
                this.host = this.host.push(new SimpleString(query));
            }
            if ((fragment = uri.getRawFragment()) != null) {
                this.host = this.host.push(FRAGMENT);
                this.host = this.host.push(new SimpleString(fragment));
            }
            Pathname p = new Pathname(path != null ? path : "");
            this.directory = p.directory;
            this.name = p.name;
            this.type = p.type;
            this.host = this.host.nreverse();
            this.invalidateNamestring();
            return;
        }
        if (Utilities.isPlatformWindows && s.contains("\\")) {
            s = s.replace("\\", "/");
        }
        if (Utilities.isPlatformUnix) {
            if (s.equals("~")) {
                s = System.getProperty("user.home").concat("/");
            } else if (s.startsWith("~/")) {
                s = System.getProperty("user.home").concat(s.substring(1));
            }
        }
        this.namestring = s;
        if (Utilities.isPlatformWindows && s.length() >= 2 && s.charAt(1) == ':') {
            this.device = new SimpleString(s.charAt(0));
            s = s.substring(2);
        }
        String d = null;
        int i = s.length();
        while (i-- > 0) {
            if (s.charAt(i) != '/') continue;
            d = s.substring(0, i + 1);
            s = s.substring(i + 1);
            break;
        }
        if (d != null) {
            if (s.equals("..")) {
                d = d.concat(s);
                s = "";
            }
            this.directory = Pathname.parseDirectory(d);
        }
        if (s.startsWith(".") && (s.indexOf(".", 1) == -1 || s.substring(s.length() - 1).equals("."))) {
            this.name = new SimpleString(s);
            return;
        }
        int index = s.lastIndexOf(46);
        String n = null;
        String t = null;
        if (index > 0) {
            n = s.substring(0, index);
            t = s.substring(index + 1);
        } else if (s.length() > 0) {
            n = s;
        }
        if (n != null) {
            this.name = n.equals("*") ? Keyword.WILD : new SimpleString(n);
        }
        if (t != null) {
            this.type = t.equals("*") ? Keyword.WILD : new SimpleString(t);
        }
    }

    private static final LispObject parseDirectory(String d) {
        if (d.equals("/") || Utilities.isPlatformWindows && d.equals("\\")) {
            return new Cons(Keyword.ABSOLUTE);
        }
        LispObject result = d.startsWith("/") || Utilities.isPlatformWindows && d.startsWith("\\") ? new Cons(Keyword.ABSOLUTE) : new Cons(Keyword.RELATIVE);
        StringTokenizer st = new StringTokenizer(d, "/\\");
        while (st.hasMoreTokens()) {
            LispObject obj;
            String token = st.nextToken();
            if (token.equals("*")) {
                obj = Keyword.WILD;
            } else if (token.equals("**")) {
                obj = Keyword.WILD_INFERIORS;
            } else if (token.equals("..")) {
                if (result.car() instanceof AbstractString) {
                    result = result.cdr();
                    continue;
                }
                obj = Keyword.UP;
            } else {
                obj = new SimpleString(token);
            }
            result = new Cons(obj, result);
        }
        return ((LispObject)result).nreverse();
    }

    public LispObject getParts() {
        LispObject parts = Lisp.NIL;
        parts = parts.push(new Cons("HOST", this.host));
        parts = parts.push(new Cons("DEVICE", this.device));
        parts = parts.push(new Cons("DIRECTORY", this.directory));
        parts = parts.push(new Cons("NAME", this.name));
        parts = parts.push(new Cons("TYPE", this.type));
        parts = parts.push(new Cons("VERSION", this.version));
        return parts.nreverse();
    }

    public LispObject typeOf() {
        if (this.isURL()) {
            return Symbol.URL_PATHNAME;
        }
        if (this.isJar()) {
            return Symbol.JAR_PATHNAME;
        }
        return Symbol.PATHNAME;
    }

    public LispObject classOf() {
        if (this.isURL()) {
            return BuiltInClass.URL_PATHNAME;
        }
        if (this.isJar()) {
            return BuiltInClass.JAR_PATHNAME;
        }
        return BuiltInClass.PATHNAME;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.PATHNAME) {
            return Lisp.T;
        }
        if (type == Symbol.JAR_PATHNAME && this.isJar()) {
            return Lisp.T;
        }
        if (type == Symbol.URL_PATHNAME && this.isURL()) {
            return Lisp.T;
        }
        if (type == BuiltInClass.PATHNAME) {
            return Lisp.T;
        }
        if (type == BuiltInClass.JAR_PATHNAME && this.isJar()) {
            return Lisp.T;
        }
        if (type == BuiltInClass.URL_PATHNAME && this.isURL()) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final LispObject getDevice() {
        return this.device;
    }

    public String getNamestring() {
        if (this.namestring != null) {
            return this.namestring;
        }
        if (this.name == Lisp.NIL && this.type != Lisp.NIL) {
            Debug.assertTrue(this.namestring == null);
            return null;
        }
        if (this.directory instanceof AbstractString) {
            Debug.assertTrue(false);
        }
        StringBuilder sb = new StringBuilder();
        if (this.host != Lisp.NIL) {
            Debug.assertTrue(this.host instanceof AbstractString || this.isURL());
            if (this.isURL()) {
                LispObject scheme = Symbol.GETF.execute(this.host, SCHEME, Lisp.NIL);
                LispObject authority = Symbol.GETF.execute(this.host, AUTHORITY, Lisp.NIL);
                Debug.assertTrue(scheme != Lisp.NIL);
                sb.append(scheme.getStringValue());
                sb.append(":");
                if (authority != Lisp.NIL) {
                    sb.append("//");
                    sb.append(authority.getStringValue());
                }
            } else if (this instanceof LogicalPathname) {
                sb.append(this.host.getStringValue());
                sb.append(':');
            } else {
                return null;
            }
        }
        boolean uriEncoded = false;
        if (this.device != Lisp.NIL && this.device != Keyword.UNSPECIFIC) {
            if (this.isJar()) {
                LispObject[] jars = ((Cons)this.device).copyToArray();
                StringBuilder prefix = new StringBuilder();
                for (int i = 0; i < jars.length; ++i) {
                    prefix.append("jar:");
                    LispObject component = jars[i];
                    if (!(component instanceof Pathname)) {
                        return null;
                    }
                    if (!((Pathname)component).isURL() && i == 0) {
                        sb.append("file:");
                        uriEncoded = true;
                    }
                    Pathname jar = (Pathname)component;
                    String encodedNamestring = uriEncoded ? Pathname.uriEncode(jar.getNamestring()) : jar.getNamestring();
                    sb.append(encodedNamestring);
                    sb.append(jarSeparator);
                }
                sb = prefix.append((CharSequence)sb);
            } else if (this.device instanceof AbstractString) {
                sb.append(this.device.getStringValue());
                if (this instanceof LogicalPathname || this.host == Lisp.NIL) {
                    sb.append(':');
                }
            } else {
                Debug.assertTrue(false);
            }
        }
        String directoryNamestring = this.getDirectoryNamestring();
        if (uriEncoded) {
            directoryNamestring = Pathname.uriEncode(directoryNamestring);
        }
        if (this.isJar()) {
            if (directoryNamestring.startsWith("/")) {
                sb.append(directoryNamestring.substring(1));
            } else {
                sb.append(directoryNamestring);
            }
        } else {
            sb.append(directoryNamestring);
        }
        if (this.name instanceof AbstractString) {
            String n = this.name.getStringValue();
            if (n.indexOf(47) >= 0) {
                Debug.assertTrue(this.namestring == null);
                return null;
            }
            if (uriEncoded) {
                sb.append(Pathname.uriEncode(n));
            } else {
                sb.append(n);
            }
        } else if (this.name == Keyword.WILD) {
            sb.append('*');
        }
        if (this.type != Lisp.NIL && this.type != Keyword.UNSPECIFIC) {
            sb.append('.');
            if (this.type instanceof AbstractString) {
                String t = this.type.getStringValue();
                if (!(t.endsWith(".lnk") && Utilities.isPlatformWindows || t.indexOf(46) < 0)) {
                    Debug.assertTrue(this.namestring == null);
                    return null;
                }
                if (uriEncoded) {
                    sb.append(Pathname.uriEncode(t));
                } else {
                    sb.append(t);
                }
            } else if (this.type == Keyword.WILD) {
                sb.append('*');
            } else {
                Debug.assertTrue(false);
            }
        }
        if (this.isURL()) {
            LispObject o = Symbol.GETF.execute(this.host, QUERY, Lisp.NIL);
            if (o != Lisp.NIL) {
                sb.append("?");
                sb.append(o.getStringValue());
            }
            if ((o = Symbol.GETF.execute(this.host, FRAGMENT, Lisp.NIL)) != Lisp.NIL) {
                sb.append("#");
                sb.append(o.getStringValue());
            }
        }
        if (this instanceof LogicalPathname) {
            if (this.version.integerp()) {
                sb.append('.');
                int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue());
                if (this.version instanceof Fixnum) {
                    sb.append(Integer.toString(((Fixnum)this.version).value, base).toUpperCase());
                } else if (this.version instanceof Bignum) {
                    sb.append(((Bignum)this.version).value.toString(base).toUpperCase());
                }
            } else if (this.version == Keyword.WILD) {
                sb.append(".*");
            } else if (this.version == Keyword.NEWEST) {
                sb.append(".NEWEST");
            }
        }
        this.namestring = sb.toString();
        return this.namestring;
    }

    protected String getDirectoryNamestring() {
        this.validateDirectory(true);
        StringBuilder sb = new StringBuilder();
        if (this.directory != Lisp.NIL) {
            int separatorChar = 47;
            LispObject temp = this.directory;
            LispObject part = temp.car();
            temp = temp.cdr();
            if (part == Keyword.ABSOLUTE) {
                sb.append('/');
            } else if (part == Keyword.RELATIVE) {
                if (temp == Lisp.NIL) {
                    sb.append('.');
                    sb.append('/');
                }
            } else {
                Lisp.error(new FileError("Unsupported directory component " + part.printObject() + ".", this));
            }
            while (temp != Lisp.NIL) {
                part = temp.car();
                if (part instanceof AbstractString) {
                    sb.append(part.getStringValue());
                } else if (part == Keyword.WILD) {
                    sb.append('*');
                } else if (part == Keyword.WILD_INFERIORS) {
                    sb.append("**");
                } else if (part == Keyword.UP) {
                    sb.append("..");
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.princToString() + ".", this));
                }
                sb.append('/');
                temp = temp.cdr();
            }
        }
        return sb.toString();
    }

    protected String asEntryPath() {
        Pathname p = new Pathname();
        p.directory = this.directory;
        p.name = this.name;
        p.type = this.type;
        p.invalidateNamestring();
        String path = p.getNamestring();
        StringBuilder result = new StringBuilder();
        result.append(path);
        if (result.length() > 1 && result.substring(0, 1).equals("/")) {
            return result.substring(1);
        }
        return result.toString();
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pathname) {
            Pathname p = (Pathname)obj;
            if (Utilities.isPlatformWindows) {
                if (!this.host.equalp(p.host)) {
                    return false;
                }
                if (!this.device.equalp(p.device)) {
                    return false;
                }
                if (!this.directory.equalp(p.directory)) {
                    return false;
                }
                if (!this.name.equalp(p.name)) {
                    return false;
                }
                if (!this.type.equalp(p.type)) {
                    return false;
                }
            } else {
                if (!this.host.equal(p.host)) {
                    return false;
                }
                if (!this.device.equal(p.device)) {
                    return false;
                }
                if (!this.directory.equal(p.directory)) {
                    return false;
                }
                if (!this.name.equal(p.name)) {
                    return false;
                }
                if (!this.type.equal(p.type)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean equalp(LispObject obj) {
        return this.equal(obj);
    }

    public int sxhash() {
        return (this.host.sxhash() ^ this.device.sxhash() ^ this.directory.sxhash() ^ this.name.sxhash() ^ this.type.sxhash()) & Integer.MAX_VALUE;
    }

    public String printObject() {
        boolean useNamestring;
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        String s = null;
        s = this.getNamestring();
        if (s != null) {
            useNamestring = true;
            if (printReadably) {
                if (this.host != Lisp.NIL && !this.isURL() || this.version != Lisp.NIL) {
                    useNamestring = false;
                } else if (this.name instanceof AbstractString) {
                    String n = this.name.getStringValue();
                    if (n.equals(".") || n.equals("..")) {
                        useNamestring = false;
                    } else if (n.indexOf(File.separatorChar) >= 0) {
                        useNamestring = false;
                    }
                }
            }
        } else {
            useNamestring = false;
        }
        StringBuilder sb = new StringBuilder();
        if (useNamestring) {
            if (printReadably || printEscape) {
                sb.append("#P\"");
            }
            int limit = s.length();
            for (int i = 0; i < limit; ++i) {
                char c = s.charAt(i);
                if ((printReadably || printEscape) && (c == '\"' || c == '\\')) {
                    sb.append('\\');
                }
                sb.append(c);
            }
            if (printReadably || printEscape) {
                sb.append('\"');
            }
            return sb.toString();
        }
        sb.append("PATHNAME (with no namestring) ");
        if (this.host != Lisp.NIL) {
            sb.append(":HOST ");
            sb.append(this.host.printObject());
            sb.append(" ");
        }
        if (this.device != Lisp.NIL) {
            sb.append(":DEVICE ");
            sb.append(this.device.printObject());
            sb.append(" ");
        }
        if (this.directory != Lisp.NIL) {
            sb.append(":DIRECTORY ");
            sb.append(this.directory.printObject());
            sb.append(" ");
        }
        if (this.name != Lisp.NIL) {
            sb.append(":NAME ");
            sb.append(this.name.printObject());
            sb.append(" ");
        }
        if (this.type != Lisp.NIL) {
            sb.append(":TYPE ");
            sb.append(this.type.printObject());
            sb.append(" ");
        }
        if (this.version != Lisp.NIL) {
            sb.append(":VERSION ");
            sb.append(this.version.printObject());
            sb.append(" ");
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return this.unreadableString(sb.toString());
    }

    public static Pathname parseNamestring(String s) {
        return new Pathname(s);
    }

    public static boolean isValidURL(String s) {
        if (Utilities.isPlatformWindows && s.length() >= 2 && s.charAt(1) == ':') {
            char c = s.charAt(0);
            if ('A' <= s.charAt(0) && s.charAt(0) <= 'Z' || 'a' <= s.charAt(0) && s.charAt(0) <= 'z') {
                return false;
            }
        }
        if (s.indexOf(58) == -1) {
            return false;
        }
        try {
            URL url = new URL(s);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    URLConnection getURLConnection() {
        Debug.assertTrue(this.isURL());
        URL url = this.toURL();
        URLConnection result = null;
        try {
            result = url.openConnection();
        }
        catch (IOException e) {
            Lisp.error(new FileError("Failed to open URL connection.", this));
        }
        return result;
    }

    public static Pathname parseNamestring(AbstractString namestring) {
        String h;
        String s = namestring.getStringValue();
        if (!Pathname.isValidURL(s) && (h = Pathname.getHostString(s)) != null && LOGICAL_PATHNAME_TRANSLATIONS.get(new SimpleString(h)) != null) {
            return new LogicalPathname(h, s.substring(s.indexOf(58) + 1));
        }
        return new Pathname(s);
    }

    public static LogicalPathname parseNamestring(AbstractString namestring, AbstractString host) {
        String s = namestring.getStringValue();
        String h = Pathname.getHostString(s);
        if (h != null) {
            if (!h.equals(host.getStringValue())) {
                Lisp.error(new LispError("Host in " + s + " does not match requested host " + host.getStringValue()));
                return null;
            }
            s = s.substring(s.indexOf(58) + 1);
        }
        if (LOGICAL_PATHNAME_TRANSLATIONS.get(host) != null) {
            return new LogicalPathname(host.getStringValue(), s);
        }
        Lisp.error(new LispError(host.princToString() + " is not defined as a logical pathname host."));
        return null;
    }

    protected static String getHostString(String s) {
        int colon = s.indexOf(58);
        if (colon >= 0) {
            return s.substring(0, colon).toUpperCase();
        }
        return null;
    }

    static final void checkCaseArgument(LispObject arg) {
        if (arg != Keyword.COMMON && arg != Keyword.LOCAL) {
            Lisp.type_error(arg, Lisp.list(Symbol.MEMBER, Keyword.COMMON, Keyword.LOCAL));
        }
    }

    public static final Pathname makePathname(LispObject args) {
        return Pathname._makePathname(args.copyToArray());
    }

    public static final Pathname makePathname(File file) {
        String namestring = null;
        try {
            namestring = file.getCanonicalPath();
        }
        catch (IOException e) {
            Debug.trace("Failed to make a Pathname from ." + file + "'");
            return null;
        }
        return new Pathname(namestring);
    }

    static final Pathname _makePathname(LispObject[] args) {
        boolean logical;
        Pathname p;
        if (args.length % 2 != 0) {
            Lisp.error(new ProgramError("Odd number of keyword arguments."));
        }
        LispObject host = Lisp.NIL;
        LispObject device = Lisp.NIL;
        LispObject directory = Lisp.NIL;
        LispObject name = Lisp.NIL;
        LispObject type = Lisp.NIL;
        LispObject version = Lisp.NIL;
        Pathname defaults = null;
        boolean deviceSupplied = false;
        boolean nameSupplied = false;
        boolean typeSupplied = false;
        boolean directorySupplied = false;
        boolean versionSupplied = false;
        for (int i = 0; i < args.length; i += 2) {
            LispObject key = args[i];
            LispObject value = args[i + 1];
            if (key == Keyword.HOST) {
                host = value;
                continue;
            }
            if (key == Keyword.DEVICE) {
                device = value;
                deviceSupplied = true;
                if (value instanceof AbstractString || value.equals(Keyword.UNSPECIFIC) || value.equals(Lisp.NIL) || value instanceof Cons) continue;
                Lisp.error(new TypeError("DEVICE is not a string, :UNSPECIFIC, NIL, or a list.", value, Lisp.NIL));
                continue;
            }
            if (key == Keyword.DIRECTORY) {
                directorySupplied = true;
                if (value instanceof AbstractString) {
                    directory = Lisp.list(Keyword.ABSOLUTE, value);
                    continue;
                }
                if (value == Keyword.WILD) {
                    directory = Lisp.list(Keyword.ABSOLUTE, Keyword.WILD);
                    continue;
                }
                if (value instanceof Cons || value == Keyword.UNSPECIFIC || value.equals(Lisp.NIL)) {
                    directory = value;
                    continue;
                }
                Lisp.error(new TypeError("DIRECTORY argument not a string, list of strings, nil, :WILD, or :UNSPECIFIC.", value, Lisp.NIL));
                continue;
            }
            if (key == Keyword.NAME) {
                name = value;
                nameSupplied = true;
                continue;
            }
            if (key == Keyword.TYPE) {
                type = value;
                typeSupplied = true;
                continue;
            }
            if (key == Keyword.VERSION) {
                version = value;
                versionSupplied = true;
                continue;
            }
            if (key == Keyword.DEFAULTS) {
                defaults = Lisp.coerceToPathname(value);
                continue;
            }
            if (key != Keyword.CASE) continue;
        }
        if (defaults != null) {
            if (host == Lisp.NIL) {
                host = defaults.host;
            }
            if (!directorySupplied) {
                directory = defaults.directory;
            }
            if (!deviceSupplied) {
                device = defaults.device;
            }
            if (!nameSupplied) {
                name = defaults.name;
            }
            if (!typeSupplied) {
                type = defaults.type;
            }
            if (!versionSupplied) {
                version = defaults.version;
            }
        }
        LispObject logicalHost = Lisp.NIL;
        if (host != Lisp.NIL) {
            if (host instanceof AbstractString) {
                logicalHost = LogicalPathname.canonicalizeStringComponent((AbstractString)host);
            }
            if (LOGICAL_PATHNAME_TRANSLATIONS.get(logicalHost) == null) {
                p = new Pathname();
                logical = false;
                p.host = host;
            } else {
                p = new LogicalPathname();
                logical = true;
                p.host = logicalHost;
            }
            p.device = Keyword.UNSPECIFIC;
        } else {
            p = new Pathname();
            logical = false;
        }
        if (device != Lisp.NIL) {
            if (logical) {
                if (device != Keyword.UNSPECIFIC) {
                    Lisp.error(new LispError("The device component of a logical pathname must be :UNSPECIFIC."));
                }
            } else {
                p.device = device;
            }
        }
        if (directory != Lisp.NIL) {
            if (logical) {
                if (directory.listp()) {
                    LispObject d = Lisp.NIL;
                    while (directory != Lisp.NIL) {
                        LispObject component = directory.car();
                        d = component instanceof AbstractString ? d.push(LogicalPathname.canonicalizeStringComponent((AbstractString)component)) : d.push(component);
                        directory = directory.cdr();
                    }
                    p.directory = d.nreverse();
                } else if (directory == Keyword.WILD || directory == Keyword.WILD_INFERIORS) {
                    p.directory = directory;
                } else {
                    Lisp.error(new LispError("Invalid directory component for logical pathname: " + directory.princToString()));
                }
            } else {
                p.directory = directory;
            }
        }
        if (name != Lisp.NIL) {
            p.name = logical && name instanceof AbstractString ? LogicalPathname.canonicalizeStringComponent((AbstractString)name) : (name instanceof AbstractString ? Pathname.validateStringComponent((AbstractString)name) : name);
        }
        if (type != Lisp.NIL) {
            p.type = logical && type instanceof AbstractString ? LogicalPathname.canonicalizeStringComponent((AbstractString)type) : type;
        }
        p.version = version;
        return p;
    }

    private static final AbstractString validateStringComponent(AbstractString s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (c != '/' && (c != '\\' || !Utilities.isPlatformWindows)) continue;
            Lisp.error(new LispError("Invalid character #\\" + c + " in pathname component \"" + s + '\"'));
            return null;
        }
        return s;
    }

    private final boolean validateDirectory(boolean signalError) {
        for (LispObject temp = this.directory; temp != Lisp.NIL; temp = temp.cdr()) {
            LispObject second;
            LispObject first = temp.car();
            if (first != Keyword.ABSOLUTE && first != Keyword.WILD_INFERIORS || (second = temp.car()) != Keyword.UP && second != Keyword.BACK) continue;
            if (signalError) {
                StringBuilder sb = new StringBuilder();
                sb.append(first.printObject());
                sb.append(" may not be followed immediately by ");
                sb.append(second.printObject());
                sb.append('.');
                Lisp.error(new FileError(sb.toString(), this));
            }
            return false;
        }
        return true;
    }

    public boolean isAbsolute() {
        return (!this.directory.equals(Lisp.NIL) || this.directory != null) && this.directory instanceof Cons && ((Cons)this.directory).car().equals(Keyword.ABSOLUTE);
    }

    public boolean isJar() {
        return this.device instanceof Cons;
    }

    public boolean isURL() {
        return this.host instanceof Cons;
    }

    public boolean isWild() {
        if (this.host == Keyword.WILD || this.host == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.device == Keyword.WILD || this.device == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.directory instanceof Cons) {
            if (Lisp.memq(Keyword.WILD, this.directory)) {
                return true;
            }
            if (Lisp.memq(Keyword.WILD_INFERIORS, this.directory)) {
                return true;
            }
            Cons d = (Cons)this.directory;
            while (true) {
                String s;
                if (d.car() instanceof AbstractString && (s = d.car().printObject()).contains("*")) {
                    return true;
                }
                if (d.cdr() == Lisp.NIL || !(d.cdr() instanceof Cons)) break;
                d = (Cons)d.cdr();
            }
        }
        if (this.name == Keyword.WILD || this.name == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.name instanceof AbstractString && this.name.printObject().contains("*")) {
            return true;
        }
        if (this.type == Keyword.WILD || this.type == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.type instanceof AbstractString && this.type.printObject().contains("*")) {
            return true;
        }
        return this.version == Keyword.WILD || this.version == Keyword.WILD_INFERIORS;
    }

    public static final Pathname mergePathnames(Pathname pathname, Pathname defaultPathname) {
        return Pathname.mergePathnames(pathname, defaultPathname, Keyword.NEWEST);
    }

    public static final Pathname mergePathnames(Pathname pathname, Pathname defaultPathname, LispObject defaultVersion) {
        Pathname d;
        Pathname result;
        Pathname p = new Pathname(pathname);
        if (pathname instanceof LogicalPathname) {
            result = new LogicalPathname();
            d = new Pathname(defaultPathname);
        } else {
            result = new Pathname();
            d = defaultPathname instanceof LogicalPathname ? LogicalPathname.translateLogicalPathname((LogicalPathname)defaultPathname) : new Pathname(defaultPathname);
        }
        result.host = pathname.host != Lisp.NIL ? p.host : d.host;
        if (pathname.device != Lisp.NIL) {
            result.device = p.device;
        } else if (!p.isURL()) {
            result.device = pathname.host == Lisp.NIL && pathname.device == Lisp.NIL && d.isJar() && !Utilities.isPlatformWindows ? (pathname.directory != Lisp.NIL && pathname.directory.car() == Keyword.ABSOLUTE ? Keyword.UNSPECIFIC : d.device) : d.device;
        }
        if (pathname.isJar()) {
            Cons jars = (Cons)result.device;
            LispObject jar = jars.car;
            if (jar instanceof Pathname) {
                Pathname defaults = new Pathname(d);
                if (defaults.isJar()) {
                    defaults.device = Lisp.NIL;
                }
                Pathname o = Pathname.mergePathnames((Pathname)jar, defaults);
                if (o.directory instanceof Cons && ((Cons)o.directory).length() == 1) {
                    o.directory = Lisp.NIL;
                }
                ((Cons)result.device).car = o;
            }
            result.directory = p.directory;
        } else {
            result.directory = Pathname.mergeDirectories(p.directory, d.directory);
        }
        result.name = pathname.name != Lisp.NIL ? p.name : d.name;
        result.type = pathname.type != Lisp.NIL ? p.type : d.type;
        if (p.version != Lisp.NIL) {
            result.version = p.version;
        } else if (p.name == Lisp.NIL) {
            result.version = defaultPathname.version == Lisp.NIL ? defaultVersion : defaultPathname.version;
        } else if (defaultVersion == Lisp.NIL) {
            result.version = p.version;
        }
        if (result.version == Lisp.NIL) {
            result.version = defaultVersion;
        }
        if (pathname instanceof LogicalPathname) {
            result.device = Keyword.UNSPECIFIC;
            if (result.directory.listp()) {
                LispObject canonical = Lisp.NIL;
                for (LispObject original = result.directory; original != Lisp.NIL; original = original.cdr()) {
                    LispObject component = original.car();
                    if (component instanceof AbstractString) {
                        component = LogicalPathname.canonicalizeStringComponent((AbstractString)component);
                    }
                    canonical = canonical.push(component);
                }
                result.directory = canonical.nreverse();
            }
            if (result.name instanceof AbstractString) {
                result.name = LogicalPathname.canonicalizeStringComponent((AbstractString)result.name);
            }
            if (result.type instanceof AbstractString) {
                result.type = LogicalPathname.canonicalizeStringComponent((AbstractString)result.type);
            }
        }
        result.invalidateNamestring();
        return result;
    }

    private static final LispObject mergeDirectories(LispObject dir, LispObject defaultDir) {
        if (dir == Lisp.NIL) {
            return defaultDir;
        }
        if (dir.car() == Keyword.RELATIVE && defaultDir != Lisp.NIL) {
            int i;
            LispObject result = Lisp.NIL;
            while (defaultDir != Lisp.NIL) {
                result = new Cons(defaultDir.car(), result);
                defaultDir = defaultDir.cdr();
            }
            for (dir = dir.cdr(); dir != Lisp.NIL; dir = dir.cdr()) {
                result = new Cons(dir.car(), result);
            }
            LispObject[] array = result.copyToArray();
            for (i = 0; i < array.length - 1; ++i) {
                if (array[i] != Keyword.BACK || !(array[i + 1] instanceof AbstractString) && array[i + 1] != Keyword.WILD) continue;
                array[i] = null;
                array[i + 1] = null;
            }
            result = Lisp.NIL;
            for (i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                result = new Cons(array[i], result);
            }
            return result;
        }
        return dir;
    }

    public static final LispObject truename(Pathname pathname) {
        return Pathname.truename(pathname, false);
    }

    public static final LispObject truename(LispObject arg) {
        return Pathname.truename(arg, false);
    }

    public static final LispObject truename(LispObject arg, boolean errorIfDoesNotExist) {
        Pathname pathname = Lisp.coerceToPathname(arg);
        return Pathname.truename(pathname, errorIfDoesNotExist);
    }

    public static final LispObject truename(Pathname pathname, boolean errorIfDoesNotExist) {
        block20: {
            String entryPath;
            ZipFile jarFile;
            block23: {
                Cons jars;
                block22: {
                    Pathname truePathname;
                    block21: {
                        block19: {
                            if (pathname == null || pathname.equals(Lisp.NIL)) {
                                return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
                            }
                            if (pathname instanceof LogicalPathname) {
                                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
                            }
                            if (pathname.isWild()) {
                                return Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
                            }
                            if (pathname.isJar() || pathname.isURL()) break block19;
                            Pathname result = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL);
                            File file = result.getFile();
                            if (file.exists()) {
                                if (file.isDirectory()) {
                                    result = Pathname.getDirectoryPathname(file);
                                } else {
                                    try {
                                        result = new Pathname(file.getCanonicalPath());
                                    }
                                    catch (IOException e) {
                                        return Lisp.error(new FileError(e.getMessage(), pathname));
                                    }
                                }
                                if (Utilities.isPlatformUnix) {
                                    result.device = Keyword.UNSPECIFIC;
                                }
                                return result;
                            }
                            break block20;
                        }
                        if (!pathname.isURL()) break block21;
                        if (pathname.getInputStream() != null) {
                            Pathname p;
                            if (pathname.name != Lisp.NIL && pathname.type == Lisp.NIL && Symbol.GETF.execute(pathname.host, QUERY, Lisp.NIL) == Lisp.NIL && Symbol.GETF.execute(pathname.host, FRAGMENT, Lisp.NIL) == Lisp.NIL && (p = new Pathname(pathname.getNamestring() + "/")).getInputStream() != null) {
                                return p;
                            }
                            return pathname;
                        }
                        break block20;
                    }
                    jars = (Cons)pathname.device;
                    LispObject o = jars.car();
                    if (!(o instanceof Pathname)) {
                        return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
                    }
                    if (!(o instanceof Pathname) || ((Pathname)o).isURL() || Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()).isJar()) break block22;
                    LispObject truename = Pathname.truename((Pathname)o, errorIfDoesNotExist);
                    if (truename == null || truename == Lisp.NIL || !(truename instanceof Pathname) || (truePathname = (Pathname)truename).getNamestring().endsWith("/")) break block20;
                    jars.car = truePathname;
                }
                jarFile = ZipCache.get((Pathname)jars.car());
                entryPath = pathname.asEntryPath();
                if (jarFile == null) break block20;
                if (!(jars.cdr() instanceof Cons)) break block23;
                Pathname inner = (Pathname)jars.cdr().car();
                InputStream inputStream = Utilities.getInputStream(jarFile, inner);
                if (inputStream != null) {
                    if (entryPath.length() == 0) {
                        return pathname;
                    }
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    ZipEntry entry = Utilities.getEntry(zipInputStream, entryPath, false);
                    if (entry != null) {
                        return pathname;
                    }
                }
                break block20;
            }
            if (entryPath.length() == 0) {
                return pathname;
            }
            ZipEntry entry = jarFile.getEntry(entryPath);
            if (entry == null || entry.isDirectory()) break block20;
            try {
                InputStream input = jarFile.getInputStream(entry);
                if (input != null) {
                    return pathname;
                }
            }
            catch (IOException e) {}
        }
        return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
    }

    private static LispObject doTruenameExit(Pathname pathname, boolean errorIfDoesNotExist) {
        if (errorIfDoesNotExist) {
            StringBuilder sb = new StringBuilder("The file ");
            sb.append(pathname.princToString());
            sb.append(" does not exist.");
            return Lisp.error(new FileError(sb.toString(), pathname));
        }
        return Lisp.NIL;
    }

    protected static URL makeURL(Pathname pathname) {
        URL result = null;
        try {
            result = pathname.isURL() ? new URL(pathname.getNamestring()) : new URL("file://" + pathname.getNamestring());
        }
        catch (MalformedURLException e) {
            Debug.trace("Could not form URL from " + pathname);
        }
        return result;
    }

    public InputStream getInputStream() {
        InputStream result = null;
        if (this.isJar()) {
            String entryPath = this.asEntryPath();
            Debug.assertTrue(entryPath != null);
            ZipFile jarFile = ZipCache.get((Pathname)this.device.car());
            Debug.assertTrue(jarFile != null);
            if (this.device.cdr() instanceof Cons) {
                Pathname inner = (Pathname)this.device.cdr().car();
                InputStream input = Utilities.getInputStream(jarFile, inner);
                ZipInputStream zipInputStream = new ZipInputStream(input);
                result = Utilities.getEntryAsInputStream(zipInputStream, entryPath);
            } else {
                ZipEntry entry = jarFile.getEntry(entryPath);
                if (entry == null) {
                    Debug.trace("Failed to get InputStream for '" + this.getNamestring() + "'");
                    Debug.assertTrue(false);
                }
                try {
                    result = jarFile.getInputStream(entry);
                }
                catch (IOException e) {
                    Debug.warn("Failed to get InputStream from '" + this.getNamestring() + "'" + ": " + e);
                }
            }
        } else if (this.isURL()) {
            URL url = this.toURL();
            try {
                result = url.openStream();
            }
            catch (IOException e) {
                Debug.warn("Failed to get InputStream from '" + this.getNamestring() + "'" + ": " + e);
            }
        } else {
            File file = this.getFile();
            try {
                result = new FileInputStream(file);
            }
            catch (IOException e) {
                Debug.warn("Failed to get InputStream from '" + this.getNamestring() + "'" + ": " + e);
            }
        }
        return result;
    }

    public long getLastModified() {
        if (!this.isJar() && !this.isURL()) {
            File f = this.getFile();
            return f.lastModified();
        }
        if (this.isJar()) {
            String entryPath = this.asEntryPath();
            Cons d = (Cons)this.device;
            if (d.cdr().equals(Lisp.NIL)) {
                if (entryPath.length() == 0) {
                    LispObject o = d.car();
                    return ((Pathname)o).getLastModified();
                }
                ZipEntry entry = ZipCache.get((Pathname)this.device.car()).getEntry(entryPath);
                if (entry == null) {
                    return 0L;
                }
                long time = entry.getTime();
                if (time == -1L) {
                    return 0L;
                }
                return time;
            }
            ZipFile outerJar = ZipCache.get((Pathname)d.car());
            if (entryPath.length() == 0) {
                String jarPath = ((Pathname)d.cdr()).asEntryPath();
                ZipEntry entry = outerJar.getEntry(jarPath);
                long time = entry.getTime();
                if (time == -1L) {
                    return 0L;
                }
                return time;
            }
            String innerJarPath = ((Pathname)d.cdr()).asEntryPath();
            ZipEntry entry = outerJar.getEntry(entryPath);
            ZipInputStream innerJarInputStream = Utilities.getZipInputStream(outerJar, innerJarPath);
            ZipEntry innerEntry = Utilities.getEntry(innerJarInputStream, entryPath);
            long time = innerEntry.getTime();
            if (time == -1L) {
                return 0L;
            }
            return time;
        }
        if (this.isURL()) {
            return this.getURLConnection().getLastModified();
        }
        return 0L;
    }

    public URL toURL() {
        try {
            if (this.isURL()) {
                return new URL(this.getNamestring());
            }
            return this.toFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            Lisp.error(new LispError(this.getNamestring() + " is not a valid URL"));
            return null;
        }
    }

    public File toFile() {
        if (!this.isURL()) {
            return new File(this.getNamestring());
        }
        throw new RuntimeException(this + " does not represent a file");
    }

    static String uriDecode(String s) {
        try {
            URI uri = new URI("file://foo?" + s);
            return uri.getQuery();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    static String uriEncode(String s) {
        String u = !s.startsWith("/") ? "/" + s : new String(s);
        try {
            URI uri = new URI("file", "", u, "");
            String result = uri.getRawPath();
            if (!s.startsWith("/")) {
                return result.substring(1);
            }
            return result;
        }
        catch (URISyntaxException e) {
            Debug.assertTrue(false);
            return null;
        }
    }

    File getFile() {
        String namestring = this.getNamestring();
        if (namestring != null) {
            return new File(namestring);
        }
        Lisp.error(new FileError("Pathname has no namestring: " + this.princToString(), this));
        return null;
    }

    public static Pathname getDirectoryPathname(File file) {
        try {
            String namestring = file.getCanonicalPath();
            if (namestring != null && namestring.length() > 0 && namestring.charAt(namestring.length() - 1) != File.separatorChar) {
                namestring = namestring.concat(File.separator);
            }
            return new Pathname(namestring);
        }
        catch (IOException e) {
            Lisp.error(new LispError(e.getMessage()));
            return null;
        }
    }

    static {
        LispObject obj = Symbol.DEFAULT_PATHNAME_DEFAULTS.getSymbolValue();
        Symbol.DEFAULT_PATHNAME_DEFAULTS.setSymbolValue(Lisp.coerceToPathname(obj));
        URI_DECODE = new pf_uri_decode();
        URI_ENCODE = new pf_uri_encode();
    }

    private static final class pf_uri_encode
    extends Primitive {
        pf_uri_encode() {
            super("uri-encode", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.error(new TypeError(arg, Symbol.STRING));
            }
            String result = Pathname.uriEncode(((AbstractString)arg).toString());
            return new SimpleString(result);
        }
    }

    private static final class pf_uri_decode
    extends Primitive {
        pf_uri_decode() {
            super("uri-decode", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.error(new TypeError(arg, Symbol.STRING));
            }
            String result = Pathname.uriDecode(((AbstractString)arg).toString());
            return new SimpleString(result);
        }
    }

    @DocString(name="host-namestring", args="pathname", returns="namestring", doc="Returns the host name of PATHNAME.")
    private static class pf_host_namestring
    extends Primitive {
        pf_host_namestring() {
            super("host-namestring", "pathname");
        }

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname((LispObject)arg).host;
        }
    }

    @DocString(name="file-namestring", args="pathname", returns="namestring", doc="Returns just the name, type, and version components of PATHNAME.")
    private static class pf_file_namestring
    extends Primitive {
        pf_file_namestring() {
            super("file-namestring", "pathname");
        }

        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            StringBuilder sb = new StringBuilder();
            if (p.name instanceof AbstractString) {
                sb.append(p.name.getStringValue());
            } else if (p.name == Keyword.WILD) {
                sb.append('*');
            } else {
                return Lisp.NIL;
            }
            if (p.type instanceof AbstractString) {
                sb.append('.');
                sb.append(p.type.getStringValue());
            } else if (p.type == Keyword.WILD) {
                sb.append(".*");
            }
            return new SimpleString(sb);
        }
    }

    @DocString(name="rename-file", args="filespec new-name", returns="defaulted-new-name, old-truename, new-truename", doc="Modifies the file system in such a way that the file indicated by FILESPEC is renamed to DEFAULTED-NEW-NAME.\n\nReturns three values if successful. The primary value, DEFAULTED-NEW-NAME, is \nthe resulting name which is composed of NEW-NAME with any missing components filled in by \nperforming a merge-pathnames operation using filespec as the defaults. The secondary \nvalue, OLD-TRUENAME, is the truename of the file before it was renamed. The tertiary \nvalue, NEW-TRUENAME, is the truename of the file after it was renamed.\n")
    private static class pf_rename_file
    extends Primitive {
        pf_rename_file() {
            super("rename-file", "filespec new-name");
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname oldPathname = Lisp.coerceToPathname(first);
            Pathname oldTruename = (Pathname)Pathname.truename(oldPathname, true);
            Pathname newName = Lisp.coerceToPathname(second);
            if (newName.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", newName));
            }
            if (oldTruename.isJar()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", oldTruename));
            }
            if (newName.isJar()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", newName));
            }
            if (oldTruename.isURL()) {
                Lisp.error(new FileError("Bad place for a URL pathname.", oldTruename));
            }
            if (newName.isURL()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", newName));
            }
            Pathname defaultedNewName = Pathname.mergePathnames(newName, oldTruename, Lisp.NIL);
            File source2 = oldTruename.getFile();
            File destination = null;
            destination = defaultedNewName instanceof LogicalPathname ? LogicalPathname.translateLogicalPathname((LogicalPathname)defaultedNewName).getFile() : defaultedNewName.getFile();
            if (Utilities.isPlatformWindows && destination.isFile()) {
                ZipCache.remove(destination);
                destination.delete();
            }
            if (source2.renameTo(destination)) {
                Pathname newTruename = (Pathname)Pathname.truename(defaultedNewName, true);
                return LispThread.currentThread().setValues(defaultedNewName, oldTruename, newTruename);
            }
            return Lisp.error(new FileError("Unable to rename " + oldTruename.princToString() + " to " + newName.princToString() + ".", oldTruename));
        }
    }

    @DocString(name="mkdir", args="pathname", returns="generalized-boolean", doc="Attempts to create directory at PATHNAME returning the success or failure.")
    private static class pf_mkdir
    extends Primitive {
        pf_mkdir() {
            super("mkdir", Lisp.PACKAGE_SYS, false, "pathname");
        }

        public LispObject execute(LispObject arg) {
            Pathname defaultedPathname;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            if ((defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL)).isURL() || defaultedPathname.isJar()) {
                return new FileError("Cannot mkdir with a " + (defaultedPathname.isURL() ? "URL" : "jar") + " Pathname.", defaultedPathname);
            }
            File file = defaultedPathname.getFile();
            return file.mkdir() ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="get-input-stream", args="pathname", doc="Returns a java.io.InputStream for resource denoted by PATHNAME.")
    private static final class pf_get_input_stream
    extends Primitive {
        pf_get_input_stream() {
            super("ensure-input-stream", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject pathname) {
            Pathname p = Lisp.coerceToPathname(pathname);
            return new JavaObject(p.getInputStream());
        }
    }

    @DocString(name="merge-pathnames", args="pathname &optional default-pathname default-version", returns="pathname", doc="Constructs a pathname from PATHNAME by filling in any unsupplied components\nwith the corresponding values from DEFAULT-PATHNAME and DEFAULT-VERSION.")
    static final class pf_merge_pathnames
    extends Primitive {
        pf_merge_pathnames() {
            super("merge-pathnames", "pathname &optional default-pathname default-version");
        }

        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            Pathname defaultPathname = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            LispObject defaultVersion = third;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }
    }

    @DocString(name="%wild-pathname-p", args="pathname keyword", returns="generalized-boolean", doc="Predicate for determing whether PATHNAME contains wild components.\nKEYWORD, if non-nil, should be one of :directory, :host, :device,\n:name, :type, or :version indicating that only the specified component\nshould be checked for wildness.")
    static final class pf_wild_pathname_p
    extends Primitive {
        pf_wild_pathname_p() {
            super("%wild-pathname-p", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            LispObject value;
            Pathname pathname = Lisp.coerceToPathname(first);
            if (second == Lisp.NIL) {
                return pathname.isWild() ? Lisp.T : Lisp.NIL;
            }
            if (second == Keyword.DIRECTORY) {
                if (pathname.directory instanceof Cons) {
                    if (Lisp.memq(Keyword.WILD, pathname.directory)) {
                        return Lisp.T;
                    }
                    if (Lisp.memq(Keyword.WILD_INFERIORS, pathname.directory)) {
                        return Lisp.T;
                    }
                }
                return Lisp.NIL;
            }
            if (second == Keyword.HOST) {
                value = pathname.host;
            } else if (second == Keyword.DEVICE) {
                value = pathname.device;
            } else if (second == Keyword.NAME) {
                value = pathname.name;
            } else if (second == Keyword.TYPE) {
                value = pathname.type;
            } else if (second == Keyword.VERSION) {
                value = pathname.version;
            } else {
                return Lisp.error(new ProgramError("Unrecognized keyword " + second.princToString() + "."));
            }
            if (value == Keyword.WILD || value == Keyword.WILD_INFERIORS) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    }

    private static class pf_pathname_url_p
    extends Primitive {
        pf_pathname_url_p() {
            super("pathname-url-p", Lisp.PACKAGE_EXT, true, "pathname", "Predicate for whether PATHNAME references a URL.");
        }

        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            return p.isURL() ? Lisp.T : Lisp.NIL;
        }
    }

    private static class pf_pathname_jar_p
    extends Primitive {
        pf_pathname_jar_p() {
            super("pathname-jar-p", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            return p.isJar() ? Lisp.T : Lisp.NIL;
        }
    }

    private static class pf_match_wild_jar_pathname
    extends Primitive {
        pf_match_wild_jar_pathname() {
            super("match-wild-jar-pathname", Lisp.PACKAGE_SYS, false, "wild-jar-pathname");
        }

        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname instanceof LogicalPathname) {
                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
            }
            if (!pathname.isJar()) {
                return new FileError("Not a jar pathname.", pathname);
            }
            if (!pathname.isWild()) {
                return new FileError("Not a wild pathname.", pathname);
            }
            Pathname jarPathname = new Pathname(pathname);
            jarPathname.directory = Lisp.NIL;
            jarPathname.name = Lisp.NIL;
            jarPathname.type = Lisp.NIL;
            jarPathname.invalidateNamestring();
            LispObject jarTruename = Pathname.truename(jarPathname, false);
            if (jarTruename == Lisp.NIL) {
                return Lisp.NIL;
            }
            LispObject result = Lisp.NIL;
            String wild = "/" + pathname.asEntryPath();
            SimpleString wildcard = new SimpleString(wild);
            if (pathname.device.cdr() instanceof Cons) {
                ZipFile outerJar = ZipCache.get((Pathname)pathname.device.car());
                String entryPath = ((Pathname)pathname.device.cdr().car()).getNamestring();
                if (entryPath.startsWith("/")) {
                    entryPath = entryPath.substring(1);
                }
                ZipEntry entry = outerJar.getEntry(entryPath);
                InputStream inputStream = null;
                try {
                    inputStream = outerJar.getInputStream(entry);
                }
                catch (IOException e) {
                    return new FileError("Failed to read zip input stream inside zip.", pathname);
                }
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                try {
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        String entryName = "/" + entry.getName();
                        LispObject matches = Symbol.PATHNAME_MATCH_P.execute((LispObject)new SimpleString(entryName), wildcard);
                        if (matches.equals(Lisp.NIL)) continue;
                        String namestring = new String(pathname.getNamestring());
                        namestring = namestring.substring(0, namestring.lastIndexOf(Pathname.jarSeparator) + 2) + entry.getName();
                        Pathname p = new Pathname(namestring);
                        result = new Cons(p, result);
                    }
                }
                catch (IOException e) {
                    return new FileError("Failed to seek through zip inputstream inside zip.", pathname);
                }
            }
            ZipFile jar = ZipCache.get((Pathname)pathname.device.car());
            Enumeration<? extends ZipEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = "/" + entry.getName();
                LispObject matches = Symbol.PATHNAME_MATCH_P.execute((LispObject)new SimpleString(entryName), wildcard);
                if (matches.equals(Lisp.NIL)) continue;
                String namestring = new String(pathname.getNamestring());
                namestring = namestring.substring(0, namestring.lastIndexOf(Pathname.jarSeparator) + 2) + entry.getName();
                Pathname p = new Pathname(namestring);
                result = new Cons(p, result);
            }
            return result;
        }
    }

    @DocString(name="list-directory", args="directory &optional (resolve-symlinks t)", returns="pathnames", doc="Lists the contents of DIRECTORY, optionally resolving symbolic links.")
    private static class pf_list_directory
    extends Primitive {
        pf_list_directory() {
            super("list-directory", Lisp.PACKAGE_SYS, true, "directory &optional (resolve-symlinks t)");
        }

        public LispObject execute(LispObject arg) {
            return this.execute(arg, Lisp.T);
        }

        public LispObject execute(LispObject arg, LispObject arg2) {
            File f;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname instanceof LogicalPathname) {
                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
            }
            LispObject result = Lisp.NIL;
            if (pathname.isJar()) {
                String directory = pathname.asEntryPath();
                Debug.assertTrue(directory != null);
                if (pathname.device.cdr() instanceof Cons) {
                    return Lisp.error(new FileError("Unimplemented directory listing of JAR within JAR.", pathname));
                }
                directory = directory.length() == 0 ? "/*" : (directory.endsWith("/") ? "/" + directory + "*" : "/" + directory + "/*");
                SimpleString wildcard = new SimpleString(directory);
                SimpleString wildcardDirectory = new SimpleString(directory + "/");
                ZipFile jar = ZipCache.get((Pathname)pathname.device.car());
                Enumeration<? extends ZipEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = "/" + entry.getName();
                    LispObject matches = entryName.endsWith("/") ? Symbol.PATHNAME_MATCH_P.execute((LispObject)new SimpleString(entryName), wildcardDirectory) : Symbol.PATHNAME_MATCH_P.execute((LispObject)new SimpleString(entryName), wildcard);
                    if (matches.equals(Lisp.NIL)) continue;
                    String namestring = new String(pathname.getNamestring());
                    namestring = namestring.substring(0, namestring.lastIndexOf(Pathname.jarSeparator) + 2) + entry.getName();
                    Pathname p = new Pathname(namestring);
                    result = new Cons(p, result);
                }
                return result;
            }
            if (pathname.isURL()) {
                return Lisp.error(new LispError("Unimplemented."));
            }
            String s = pathname.getNamestring();
            if (s != null && (f = new File(s)).isDirectory()) {
                try {
                    File[] files = f.listFiles();
                    int i = files.length;
                    while (i-- > 0) {
                        File file = files[i];
                        Pathname p = file.isDirectory() ? (arg2 != Lisp.NIL ? Pathname.getDirectoryPathname(file) : new Pathname(file.getAbsolutePath())) : (arg2 != Lisp.NIL ? new Pathname(file.getCanonicalPath()) : new Pathname(file.getAbsolutePath()));
                        result = new Cons(p, result);
                    }
                }
                catch (IOException e) {
                    return Lisp.error(new FileError("Unable to list directory " + pathname.princToString() + ".", pathname));
                }
                catch (SecurityException e) {
                    Debug.trace(e);
                }
                catch (NullPointerException e) {
                    Debug.trace(e);
                }
            }
            return result;
        }
    }

    @DocString(name="user-homedir-pathname", args="&optional host", returns="pathname", doc="Determines the pathname that corresponds to the user's home directory.\nThe value returned is obtained from the JVM system propoerty 'user.home'.\nIf HOST is specified, returns NIL.")
    private static class pf_user_homedir_pathname
    extends Primitive {
        pf_user_homedir_pathname() {
            super("user-homedir-pathname", "&optional host");
        }

        public LispObject execute(LispObject[] args) {
            switch (args.length) {
                case 0: {
                    String s = System.getProperty("user.home");
                    if (!s.endsWith(File.separator)) {
                        s = s.concat(File.separator);
                    }
                    return new Pathname(s);
                }
                case 1: {
                    return Lisp.NIL;
                }
            }
            return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 0, 1));
        }
    }

    @DocString(name="logical-pathname-p", args="object", returns="generalized-boolean", doc="Returns true if OBJECT is of type logical-pathname; otherwise, returns false.")
    private static class pf_logical_pathname_p
    extends Primitive {
        pf_logical_pathname_p() {
            super("logical-pathname-p", Lisp.PACKAGE_SYS, true, "object");
        }

        public LispObject execute(LispObject arg) {
            return arg instanceof LogicalPathname ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="pathnamep", args="object", returns="generalized-boolean", doc="Returns true if OBJECT is of type pathname; otherwise, returns false.")
    private static class pf_pathnamep
    extends Primitive {
        pf_pathnamep() {
            super("pathnamep", "object");
        }

        public LispObject execute(LispObject arg) {
            return arg instanceof Pathname ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="make-pathname", args="&key host device directory name type version defaults case", returns="pathname", doc="Constructs and returns a pathname from the supplied keyword arguments.")
    private static class pf_make_pathname
    extends Primitive {
        pf_make_pathname() {
            super("make-pathname", "&key host device directory name type version defaults case");
        }

        public LispObject execute(LispObject[] args) {
            return Pathname._makePathname(args);
        }
    }

    @DocString(name="%parse-namestring", args="namestring host default-pathname", returns="pathname, position")
    private static class pf_parse_namestring
    extends Primitive {
        pf_parse_namestring() {
            super("%parse-namestring", Lisp.PACKAGE_SYS, false, "namestring host default-pathname");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispThread thread = LispThread.currentThread();
            AbstractString namestring = Lisp.checkString(first);
            if (second == Lisp.NIL) {
                if ((third = Lisp.coerceToPathname(third)) instanceof LogicalPathname) {
                    second = ((LogicalPathname)third).host;
                } else {
                    return thread.setValues(Pathname.parseNamestring(namestring), namestring.LENGTH());
                }
            }
            Debug.assertTrue(second != Lisp.NIL);
            AbstractString host = Lisp.checkString(second);
            return thread.setValues(Pathname.parseNamestring(namestring, host), namestring.LENGTH());
        }
    }

    @DocString(name="pathname", args="pathspec", returns="pathname", doc="Returns the PATHNAME denoted by PATHSPEC.")
    private static class pf_pathname
    extends Primitive {
        pf_pathname() {
            super("pathname", "pathspec");
        }

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname(arg);
        }
    }

    @DocString(name="directory-namestring", args="pathname", returns="namestring", doc="Returns the NAMESTRING of directory porition of PATHNAME if it has one.")
    private static class pf_directory_namestring
    extends Primitive {
        pf_directory_namestring() {
            super("directory-namestring", "pathname");
        }

        public LispObject execute(LispObject arg) {
            return new SimpleString(Lisp.coerceToPathname(arg).getDirectoryNamestring());
        }
    }

    @DocString(name="namestring", args="pathname", returns="namestring", doc="Returns the NAMESTRING of PATHNAME if it has one.\n\nIf PATHNAME is of type url-pathname or jar-pathname the NAMESTRING is encoded\naccording to the uri percent escape rules.\n\nSignals an error if PATHNAME lacks a printable NAMESTRING representation.\n")
    private static class pf_namestring
    extends Primitive {
        pf_namestring() {
            super("namestring", "pathname");
        }

        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            String namestring = pathname.getNamestring();
            if (namestring == null) {
                Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.princToString()));
            }
            return new SimpleString(namestring);
        }
    }

    @DocString(name="pathname-version", args="pathname", returns="version", doc="Return the version component of PATHNAME.")
    private static class pf_pathname_version
    extends Primitive {
        pf_pathname_version() {
            super("pathname-version", "pathname");
        }

        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname((LispObject)arg).version;
        }
    }

    @DocString(name="%pathname-type")
    private static class pf_pathname_type
    extends Primitive {
        pf_pathname_type() {
            super("%pathname-type", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).type;
        }
    }

    @DocString(name="%pathname-name")
    private static class pf_pathname_name
    extends Primitive {
        pf_pathname_name() {
            super("%pathname-name", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).name;
        }
    }

    @DocString(name="%pathname-directory")
    private static class pf_pathname_directory
    extends Primitive {
        pf_pathname_directory() {
            super("%pathname-directory", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).directory;
        }
    }

    @DocString(name="%pathname-device")
    private static class pf_pathname_device
    extends Primitive {
        pf_pathname_device() {
            super("%pathname-device", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).device;
        }
    }

    @DocString(name="%pathname-host")
    private static class pf_pathname_host
    extends Primitive {
        pf_pathname_host() {
            super("%pathname-host", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname((LispObject)first).host;
        }
    }

    @DocString(name="%invalidate-namestring", args="pathname", returns="pathname")
    private static class pf_invalidate_namestring
    extends Primitive {
        pf_invalidate_namestring() {
            super("%invalidate-namestring", Lisp.PACKAGE_EXT, false);
        }

        public LispObject execute(LispObject first) {
            Lisp.coerceToPathname(first).invalidateNamestring();
            return first;
        }
    }
}

