-- Valyria Tear map editor begin. Do not edit this line or put anything before this line. --

-- Set the namespace according to the map name.
local ns = {};
setmetatable(ns, {__index = _G});
layna_village_center = ns;
setfenv(1, ns);

-- The map name, subname and location image
map_name = "Mountain Village of Layna"
map_image_filename = "img/menus/locations/mountain_village.png"
map_subname = "Village center"

-- The number of rows, and columns that compose the map
num_tile_cols = 60
num_tile_rows = 40

-- The contexts names and inheritance definition
-- Tells the context id the current context inherit from
-- This means that the parent context will be used as a base, and the current
-- context will only have its own differences from it.
-- At least, the base context (id:0) can't a parent context, thus it should be equal to -1.
-- Note that a context cannot inherit from itself or a context with a higher id
-- since it would lead to nasty and useless loading use cases.
contexts = {}
contexts[0] = {}
contexts[0].name = "Base"
contexts[0].inherit_from = -1

-- The music file used as default background music on this map.
-- Other musics will have to handled through scripting.
music_filename = "mus/Caketown_1-OGA-mat-pablo.ogg"

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "mountain_landscape"
tileset_filenames[2] = "mountain_house_exterior"
tileset_filenames[3] = "mountain_house_exterior2"
tileset_filenames[4] = "village_exterior"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable for all contexts. Valid range: [0:2^32-1]
-- Example: 1 (BIN 001) = wall for first context only, 2 (BIN 010) means wall for second context only, 5 (BIN 101) means Wall for first and third context.
map_grid = {}
map_grid[0] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[1] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[2] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[3] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[4] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[5] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[6] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[7] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[8] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[9] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[10] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[11] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[12] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[13] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[14] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[15] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[16] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 }
map_grid[17] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[18] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 }
map_grid[19] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[21] = { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[22] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[23] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[24] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 }
map_grid[25] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[26] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[27] = { 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[28] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[29] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[30] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[31] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[32] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[33] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[34] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[35] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[36] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[37] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[38] = { 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[39] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[40] = { 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[41] = { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[42] = { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[43] = { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[44] = { 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[45] = { 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[46] = { 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[47] = { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[48] = { 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[49] = { 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[50] = { 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[51] = { 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[52] = { 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[53] = { 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[54] = { 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[55] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0 }
map_grid[56] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[57] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[58] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[59] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[60] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 }
map_grid[61] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[62] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 }
map_grid[63] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[64] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0 }
map_grid[65] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[66] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[67] = { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[68] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[69] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[70] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[71] = { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[72] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[73] = { 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[74] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[75] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[76] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 }
map_grid[77] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0 }
map_grid[78] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0 }
map_grid[79] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0 }

-- The tile layers. The numbers are indeces to the tile_mappings table.
layers = {}
layers[0] = {}
layers[0].type = "ground"
layers[0].name = "Village ground"
layers[0][0] = { 10, 10, 10, 10, 10, 10, 111, 12, 13, 95, 78, 95, 11, 110, 42, 111, 110, 26, 26, 78, 78, 111, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 78, 78, 26, 10, 10, 10, 10, 111, 12, 13, 94, 78, 95, 95, 78 }
layers[0][1] = { 78, 78, 78, 78, 78, 10, 10, 10, 111, 13, 95, 78, 27, 10, 26, 42, 42, 78, 78, 78, 78, 78, 29, 78, 78, 78, 78, 78, 78, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 111, 12, 13, 95, 11, 13 }
layers[0][2] = { 78, 78, 78, 78, 78, 78, 78, 10, 10, 111, 12, 13, 27, 10, 10, 10, 78, 78, 78, 78, 78, 78, 111, 12, 12, 13, 78, 78, 11, 12, 12, 13, 11, 12, 110, 10, 10, 10, 10, 10, 10, 10, 10, 78, 78, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 10, 111, 13, 43, 45 }
layers[0][3] = { 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10, 111, 110, 42, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 12, 12, 110, 10, 10, 111, 110, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10, 13, 95, 95, 95, 79, 79, 27, 10, 78, 78, 78, 10, 10, 111, 13, 95 }
layers[0][4] = { 78, 78, 78, 78, 78, 78, 78, 78, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 10, 10, 42, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 111, 12, 13, 95, 79, 11, 110, 10, 10, 10, 10, 10, 127, 126, 29, 78 }
layers[0][5] = { 78, 78, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 111, 12, 12, 110, 127, 44, 126, 10, 10, 78, 111, 110, 29, 78 }
layers[0][6] = { 78, 79, 79, 79, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 95, 78, 79, 78, 79, 95, 78, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 42, 111, 13, 27, 28, 10, 78, 10, 10, 29, 78 }
layers[0][7] = { 78, 78, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 95, 78, 95, 78, 79, 78, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 78, 79, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 28, 10, 78, 78, 10, 111, 12 }
layers[0][8] = { 78, 78, 79, 79, 78, 79, 78, 78, 78, 78, 79, 78, 11, 12, 13, 78, 79, 78, 78, 79, 78, 79, 78, 79, 79, 95, 78, 78, 78, 78, 79, 78, 79, 95, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 127, 126, 10, 78, 78, 78, 10, 10 }
layers[0][9] = { 78, 78, 78, 79, 79, 11, 12, 12, 12, 13, 79, 11, 110, 10, 111, 12, 12, 13, 78, 79, 11, 12, 13, 78, 78, 79, 95, 78, 78, 78, 79, 79, 78, 11, 13, 95, 95, 79, 95, 79, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 29, 27, 10, 10, 10, 78, 78, 78 }
layers[0][10] = { 78, 78, 78, 11, 12, 110, 26, 26, 42, 111, 12, 110, 10, 42, 42, 26, 26, 29, 95, 11, 110, 28, 111, 12, 12, 12, 13, 78, 78, 95, 79, 79, 95, 43, 45, 79, 78, 79, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 28, 10, 10, 78, 78, 78 }
layers[0][11] = { 78, 78, 78, 27, 26, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 111, 13, 43, 44, 126, 28, 28, 28, 127, 45, 78, 78, 79, 78, 79, 79, 78, 79, 95, 79, 95, 79, 78, 79, 11, 12, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10 }
layers[0][12] = { 78, 78, 78, 27, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 30, 77, 26, 111, 13, 78, 43, 44, 44, 44, 45, 11, 12, 13, 79, 79, 79, 95, 79, 78, 79, 79, 78, 79, 95, 79, 43, 126, 111, 12, 12, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78 }
layers[0][13] = { 78, 78, 78, 27, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 127, 126, 111, 13, 11, 12, 12, 13, 11, 110, 10, 111, 12, 12, 13, 79, 78, 79, 79, 79, 79, 95, 79, 78, 78, 43, 44, 126, 28, 111, 13, 78, 78, 78, 78, 95, 95, 78, 78, 78, 78, 78, 78 }
layers[0][14] = { 42, 78, 78, 43, 126, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 30, 77, 111, 110, 28, 111, 110, 59, 61, 111, 110, 10, 10, 10, 42, 42, 111, 13, 79, 78, 79, 79, 95, 79, 95, 78, 79, 95, 78, 43, 44, 44, 45, 78, 95, 78, 95, 95, 79, 78, 78, 78, 78, 78, 79 }
layers[0][15] = { 42, 42, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 47, 61, 59, 60, 60, 60, 46, 47, 60, 60, 61, 10, 42, 28, 42, 42, 29, 78, 78, 78, 78, 95, 78, 95, 95, 95, 95, 79, 95, 79, 78, 79, 78, 79, 79, 79, 95, 78, 78, 78, 78, 78, 78, 78 }
layers[0][16] = { 126, 42, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 15, 77, 91, 62, 76, 76, 31, 76, 76, 14, 47, 61, 127, 126, 28, 127, 45, 79, 78, 95, 95, 95, 78, 79, 95, 79, 79, 78, 79, 78, 79, 78, 79, 79, 11, 12, 13, 78, 11, 12, 13, 78, 78, 78 }
layers[0][17] = { 27, 42, 78, 11, 110, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 31, 30, 47, 61, 91, 62, 76, 76, 76, 30, 76, 31, 77, 111, 110, 28, 29, 79, 79, 95, 79, 79, 79, 11, 13, 78, 95, 95, 95, 95, 78, 79, 79, 79, 79, 43, 44, 45, 11, 110, 28, 111, 12, 12, 12 }
layers[0][18] = { 27, 42, 78, 43, 126, 91, 62, 76, 76, 15, 31, 30, 76, 30, 76, 15, 63, 62, 77, 10, 91, 92, 92, 62, 76, 76, 15, 77, 28, 28, 28, 29, 11, 12, 12, 12, 12, 12, 110, 111, 12, 12, 12, 12, 13, 95, 78, 11, 13, 78, 79, 11, 12, 110, 28, 28, 28, 28, 28, 28 }
layers[0][19] = { 110, 78, 78, 78, 43, 126, 91, 92, 92, 62, 63, 92, 92, 92, 62, 63, 93, 91, 93, 42, 10, 127, 126, 91, 62, 76, 76, 77, 28, 28, 28, 111, 110, 28, 28, 28, 42, 28, 42, 28, 28, 42, 42, 28, 111, 12, 12, 110, 111, 12, 12, 110, 28, 28, 127, 44, 44, 44, 44, 44 }
layers[0][20] = { 78, 78, 78, 78, 78, 43, 44, 44, 126, 91, 93, 26, 127, 126, 91, 93, 42, 26, 42, 26, 42, 111, 110, 26, 75, 76, 76, 77, 28, 127, 44, 126, 28, 28, 10, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 42, 42, 127, 126, 29, 78, 78, 78, 78, 78 }
layers[0][21] = { 78, 78, 78, 78, 78, 78, 78, 78, 43, 126, 42, 42, 29, 43, 126, 28, 42, 26, 26, 42, 26, 28, 127, 126, 75, 76, 76, 77, 28, 29, 78, 27, 28, 42, 42, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 42, 42, 42, 111, 110, 111, 13, 78, 78, 78, 78 }
layers[0][22] = { 78, 78, 78, 78, 78, 78, 78, 78, 11, 110, 42, 26, 111, 12, 110, 26, 127, 44, 126, 42, 10, 127, 45, 27, 75, 76, 76, 77, 127, 45, 11, 110, 28, 28, 28, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 10, 10, 28, 111, 78, 78, 78, 78 }
layers[0][23] = { 78, 78, 78, 78, 78, 78, 78, 78, 43, 44, 44, 44, 44, 126, 42, 42, 111, 12, 110, 42, 26, 29, 78, 27, 75, 76, 76, 77, 29, 11, 110, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 28, 28, 78, 127, 44, 44, 44 }
layers[0][24] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 43, 44, 44, 126, 42, 26, 127, 44, 45, 11, 110, 75, 76, 76, 77, 29, 27, 28, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 111, 13, 78, 78 }
layers[0][25] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 78, 78, 78, 43, 126, 127, 45, 95, 78, 27, 26, 75, 14, 76, 77, 29, 43, 126, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 10, 111, 13, 78 }
layers[0][26] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 43, 45, 78, 78, 78, 78, 43, 45, 78, 11, 12, 110, 26, 75, 76, 31, 77, 29, 11, 110, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 10, 10, 29, 78 }
layers[0][27] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 26, 26, 26, 75, 15, 76, 77, 111, 110, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 127, 78, 10, 10, 29, 78 }
layers[0][28] = { 78, 11, 12, 78, 78, 318, 319, 78, 78, 28, 111, 13, 78, 10, 10, 78, 78, 78, 78, 78, 27, 127, 126, 28, 91, 92, 92, 93, 28, 127, 126, 75, 30, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 127, 45, 78, 10, 10, 29, 78 }
layers[0][29] = { 78, 27, 59, 60, 78, 334, 335, 78, 78, 28, 127, 45, 78, 10, 10, 78, 78, 78, 78, 11, 110, 111, 110, 28, 28, 28, 26, 26, 127, 45, 27, 91, 62, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 10, 111, 13 }
layers[0][30] = { 78, 27, 75, 15, 76, 350, 351, 78, 42, 42, 29, 78, 78, 26, 78, 78, 78, 78, 11, 110, 28, 28, 26, 28, 127, 44, 126, 127, 45, 78, 43, 126, 91, 62, 76, 31, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 78, 10, 29 }
layers[0][31] = { 78, 27, 75, 76, 15, 30, 31, 77, 42, 127, 45, 78, 78, 78, 78, 78, 78, 78, 27, 28, 26, 127, 44, 44, 45, 78, 43, 45, 78, 78, 78, 43, 126, 75, 76, 76, 14, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 78, 78, 111 }
layers[0][32] = { 78, 27, 91, 92, 62, 76, 14, 77, 42, 111, 13, 78, 78, 78, 78, 78, 78, 11, 110, 26, 127, 45, 78, 78, 11, 13, 78, 78, 78, 78, 78, 78, 27, 91, 92, 92, 62, 31, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 111, 13, 78, 78, 78, 78, 78 }
layers[0][33] = { 78, 43, 44, 126, 91, 62, 76, 77, 42, 10, 111, 12, 13, 78, 78, 78, 11, 110, 28, 127, 45, 78, 78, 78, 43, 45, 78, 78, 78, 78, 78, 78, 43, 44, 44, 126, 75, 15, 31, 76, 76, 76, 76, 76, 76, 76, 318, 319, 76, 76, 76, 76, 77, 26, 29, 78, 78, 78, 78, 78 }
layers[0][34] = { 78, 78, 78, 27, 42, 91, 92, 93, 42, 42, 28, 28, 111, 12, 13, 11, 110, 28, 127, 45, 78, 78, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 14, 14, 14, 334, 335, 14, 76, 76, 76, 77, 26, 111, 13, 78, 78, 78, 78 }
layers[0][35] = { 78, 78, 78, 43, 126, 127, 126, 42, 42, 42, 10, 42, 10, 42, 111, 110, 127, 44, 45, 78, 78, 127, 126, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 27, 91, 92, 62, 30, 76, 76, 76, 76, 76, 14, 350, 351, 76, 76, 76, 14, 77, 28, 26, 111, 13, 78, 78, 78 }
layers[0][36] = { 78, 78, 78, 78, 43, 45, 43, 126, 42, 127, 44, 44, 44, 44, 44, 44, 45, 78, 78, 78, 78, 29, 43, 126, 78, 78, 78, 78, 78, 78, 78, 78, 11, 110, 29, 27, 26, 26, 75, 76, 76, 31, 76, 76, 76, 76, 76, 76, 76, 76, 15, 31, 77, 28, 127, 44, 45, 78, 78, 78 }
layers[0][37] = { 126, 78, 78, 78, 78, 78, 78, 43, 44, 45, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 13, 27, 42, 13, 78, 78, 78, 78, 78, 78, 43, 44, 45, 43, 126, 26, 75, 76, 30, 76, 76, 14, 63, 92, 92, 92, 92, 92, 92, 92, 93, 127, 45, 78, 78, 78, 78, 78 }
layers[0][38] = { 43, 126, 42, 42, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 78, 78, 78, 78, 78, 78, 42, 28, 111, 110, 127, 44, 126, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 26, 91, 92, 92, 92, 92, 92, 93, 10, 127, 44, 44, 44, 44, 44, 44, 45, 78, 78, 78, 78, 78, 78 }
layers[0][39] = { 78, 43, 44, 44, 126, 42, 78, 78, 78, 78, 78, 78, 43, 45, 78, 78, 78, 78, 78, 42, 42, 28, 28, 28, 29, 78, 43, 126, 78, 78, 78, 78, 78, 78, 78, 78, 43, 126, 26, 42, 26, 42, 26, 127, 44, 44, 45, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 28 }

layers[1] = {}
layers[1].type = "ground"
layers[1].name = "Ground 2"
layers[1][0] = { -1, -1, -1, -1, 249, 250, -1, -1, -1, 823, 233, 234, -1, -1, -1, -1, -1, -1, -1, 57, 144, -1, 64, 65, 68, 69, 96, 97, 98, 99, 86, 87, 82, 83, 70, 71, 66, 67, 66, 67, 66, 67, 54, -1, -1, 57, 54, -1, -1, -1, -1, -1, -1, -1, -1, -1, 823, -1, -1, 837 }
layers[1][1] = { 66, 67, 66, 67, 54, -1, -1, -1, -1, -1, 249, 250, -1, -1, 235, -1, -1, 57, 72, 73, 160, 161, 80, 81, 84, 85, -1, 824, 821, 822, 102, 103, 98, 99, 86, 87, 82, 83, 82, 83, 82, 83, 70, 71, 72, 73, 70, 71, 66, 67, 66, 67, 54, -1, -1, -1, -1, 828, -1, -1 }
layers[1][2] = { 82, 83, 82, 83, 70, 71, 144, -1, -1, -1, -1, 252, -1, -1, 251, -1, 72, 73, 88, 89, 176, 177, 96, 97, 100, 101, 839, -1, -1, -1, -1, 251, -1, -1, 102, 103, 98, 99, 98, 99, 98, 99, 86, 87, 88, 89, 86, 87, 82, 83, 82, 83, 70, 71, 144, -1, -1, -1, -1, -1 }
layers[1][3] = { 98, 99, 98, 99, 86, 87, 160, 161, 252, -1, -1, -1, -1, -1, 194, 195, 88, 89, 104, 105, 64, 65, 66, 67, 54, -1, -1, -1, -1, -1, -1, -1, -1, 57, 66, 67, 66, 67, 66, 67, 54, -1, 102, 103, 104, 105, 102, 103, 98, 99, 98, 99, 86, 87, 160, 161, -1, -1, -1, -1 }
layers[1][4] = { -1, 78, -1, 838, 102, 103, 176, 177, -1, 57, 66, 67, 66, 67, 210, 211, 104, 105, -1, -1, 80, 81, 82, 83, 70, 71, 252, -1, 247, 248, 66, 67, 72, 73, 82, 83, 82, 83, 82, 83, 70, 71, -1, -1, -1, -1, -1, 249, 250, -1, -1, -1, 102, 103, 176, 177, -1, -1, -1, 840 }
layers[1][5] = { 78, -1, -1, -1, -1, 822, 64, 65, 72, 73, 82, 83, 82, 83, 226, 227, -1, -1, -1, 787, 96, 97, 98, 99, 86, 87, 192, 193, 194, 195, 82, 83, 88, 89, 98, 99, 98, 99, 98, 99, 86, 87, 192, 193, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 33, -1, -1, -1, -1 }
layers[1][6] = { -1, 79, -1, -1, -1, -1, 80, 81, 88, 89, 98, 99, 98, 99, 242, 243, -1, -1, 837, -1, -1, -1, -1, -1, 102, 103, 208, 209, 210, 211, 98, 99, 104, 105, 839, -1, 825, -1, -1, 825, 102, 103, 208, 209, 66, 67, 54, -1, -1, -1, -1, -1, -1, -1, 48, 49, -1, -1, -1, 857 }
layers[1][7] = { 95, -1, -1, -1, -1, -1, 96, 97, 104, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 825, -1, -1, -1, 825, 224, 225, 226, 227, 839, -1, -1, -1, -1, 825, 825, 825, 825, -1, -1, -1, 224, 225, 82, 83, 70, 71, 66, 67, 144, -1, -1, -1, 64, 65, 144, -1, -1, -1 }
layers[1][8] = { 37, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 821, -1, -1, -1, 240, 241, 242, 243, -1, -1, -1, -1, 825, -1, -1, 828, 828, -1, 825, -1, 240, 241, 98, 99, 86, 87, 82, 83, 160, 161, -1, -1, 80, 81, 192, 193, -1, -1 }
layers[1][9] = { 53, 839, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 825, -1, -1, -1, -1, -1, 828, 828, 828, -1, 825, 825, 825, -1, -1, -1, 102, 103, 98, 99, 176, 177, -1, -1, 96, 97, 208, 209, 66, 67 }
layers[1][10] = { 115, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 825, -1, -1, -1, -1, -1, 828, 828, 828, 828, 828, -1, -1, -1, -1, -1, 825, 825, -1, -1, -1, 48, 49, -1, -1, -1, -1, 224, 225, 82, 83 }
layers[1][11] = { -1, 37, -1, -1, -1, -1, -1, -1, 290, 291, 292, 293, 294, 295, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 825, -1, -1, 828, 828, 825, -1, -1, -1, -1, -1, -1, -1, -1, 825, 825, -1, 64, 65, 66, 67, 66, 67, 54, 241, 98, 99 }
layers[1][12] = { -1, 53, 821, -1, -1, -1, -1, 305, 306, 307, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 828, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 81, 82, 83, 82, 83, 70, 71, 66, 67 }
layers[1][13] = { -1, 115, 4, -1, -1, -1, -1, 321, 322, 323, 324, 325, 326, 327, 328, -1, 787, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 860, -1, -1, -1, 860, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 97, 98, 99, 98, 99, 86, 87, 82, 83 }
layers[1][14] = { -1, -1, 20, 21, -1, -1, -1, 337, 338, 339, 268, 269, 342, 343, 344, -1, 769, 770, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 860, -1, 860, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 823, -1, -1, -1, -1, -1, 828, 102, 103, 98, 99 }
layers[1][15] = { -1, -1, 36, 37, -1, -1, 787, 353, 354, 355, 284, 285, 358, 359, 360, 784, 785, 786, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 823, -1, -1, 825, -1, -1, 823, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 825, 838, 837 }
layers[1][16] = { -1, -1, 52, 53, -1, -1, 787, 369, 370, 371, 300, 301, 374, 375, 376, 377, 801, 802, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 823, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 838, 838 }
layers[1][17] = { -1, -1, 36, 37, -1, -1, 771, 385, 386, 387, 316, 317, 390, 391, 392, 393, 804, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 823, -1, -1, 825, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][18] = { -1, -1, 52, 53, -1, -1, -1, 401, 402, 403, 404, 405, 406, 407, 408, -1, -1, 771, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][19] = { -1, 147, 68, 69, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[1][20] = { 162, 163, 84, 85, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 838, 860, 838, -1 }
layers[1][21] = { 178, 179, 100, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 289, 290, 291, 292, 293, 292, 293, 294, 294, 292, 293, 292, 293, 292, 293, 294, 295, -1, -1, -1, -1, -1, 1, 2, 3, 2, 3 }
layers[1][22] = { 163, 69, -1, -1, -1, 292, 293, 294, 295, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 305, 306, 307, 308, 309, 512, 513, 516, 310, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 16, 17, 18, 19, 18, 19 }
layers[1][23] = { 179, 85, -1, -1, 307, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 322, 323, 324, 325, 324, 529, 530, 531, 292, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, -1, -1, -1 }
layers[1][24] = { 37, -1, -1, 322, 323, 324, 325, 326, 327, 328, 787, 788, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 337, 418, 419, 266, 267, 544, 545, 546, 547, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 48, 49, -1, -1, 840, -1 }
layers[1][25] = { 53, -1, 417, 418, 419, 270, 271, 422, 423, 424, 787, 772, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 433, 434, 435, 282, 283, 560, 561, 562, 563, 324, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, 196, 197, 198 }
layers[1][26] = { 69, -1, 433, 434, 435, 286, 287, 438, 439, 440, 787, -1, -1, 2, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 449, 450, 451, 298, 299, 576, 577, 578, 579, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 48, 49, -1, 228, 229, 230 }
layers[1][27] = { 85, -1, 449, 450, 451, 302, 303, 454, 455, 456, -1, -1, 17, 18, 19, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 466, 467, 314, 315, 592, 593, 594, 595, 324, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, 244, 245, 246 }
layers[1][28] = { 838, -1, 465, 466, 467, 366, 367, 470, 471, 472, -1, 48, 49, -1, -1, 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 481, 482, 483, 330, 331, 609, 305, 306, 307, 308, 309, 308, 309, 308, 309, 310, 311, 312, 787, -1, -1, 48, 49, -1, -1, -1, -1 }
layers[1][29] = { 825, -1, 481, 482, 483, 382, 383, 486, 487, 488, -1, 32, 33, -1, -1, 52, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 497, 498, 499, 346, 347, 625, 321, 322, 323, 324, 325, 324, 325, 324, 325, 326, 327, 328, 787, -1, -1, 64, 65, 144, -1, -1, -1 }
layers[1][30] = { -1, -1, 497, 498, 499, 398, 399, 502, 503, 504, -1, 48, 49, -1, 57, 68, 69, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 417, 418, 419, 266, 267, 420, 421, 270, 271, 422, 423, 424, 787, -1, -1, 80, 81, 192, 193, -1, -1 }
layers[1][31] = { 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64, 65, 72, 73, 84, 85, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 433, 434, 435, 282, 283, 436, 437, 286, 287, 438, 439, 440, 787, -1, -1, 96, 97, 208, 209, 144, -1 }
layers[1][32] = { 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 81, 88, 89, 100, 101, -1, -1, -1, -1, -1, 17, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 449, 450, 451, 298, 299, 452, 453, 302, 303, 454, 455, 456, 787, 787, -1, -1, -1, 224, 225, 160, 161 }
layers[1][33] = { 115, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 97, 104, 105, -1, -1, -1, -1, -1, -1, 112, -1, 36, 37, -1, 838, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 465, 466, 467, 314, 315, 468, 469, 366, 367, 470, 471, 472, 787, 788, -1, -1, -1, 240, 241, 176, 177 }
layers[1][34] = { 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, -1, 52, 53, 838, 822, 838, -1, -1, 839, -1, -1, -1, -1, -1, -1, -1, -1, 481, 482, 483, 330, 331, 484, 485, 382, 383, 486, 487, 488, 772, -1, -1, -1, -1, -1, 825, 32, 33 }
layers[1][35] = { 52, 53, 838, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 33, -1, -1, -1, 115, -1, 838, 823, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 497, 498, 499, 346, 347, 500, 501, 398, 399, 502, 503, 504, -1, -1, -1, -1, -1, -1, -1, 48, 49 }
layers[1][36] = { 114, 115, 2, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48, 49, -1, -1, -1, 131, 24, 25, -1, 838, 825, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 33 }
layers[1][37] = { -1, -1, -1, -1, -1, 25, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 828, -1, 112, -1, -1, -1, -1, -1, 40, 41, 20, -1, 838, 838, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 858, 48, 49 }
layers[1][38] = { -1, -1, -1, -1, -1, -1, -1, 25, 4, 825, -1, -1, -1, -1, -1, -1, -1, -1, 112, -1, -1, -1, -1, -1, -1, -1, -1, 114, 115, -1, 839, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 839, -1, 1, 112, 113 }
layers[1][39] = { 840, -1, -1, -1, -1, -1, -1, -1, -1, 21, -1, -1, -1, -1, -1, -1, -1, 32, 33, -1, -1, -1, -1, -1, -1, 840, -1, -1, 131, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, -1 }

layers[2] = {}
layers[2].type = "sky"
layers[2].name = "Sky"
layers[2][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 233, 234, -1, -1, 196, 197, 198, -1, -1, -1, -1, -1, -1 }
layers[2][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 212, 213, 214, -1, -1, -1, -1, -1, -1 }
layers[2][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 228, 229, 230, -1, -1, 215, 216, -1, -1 }
layers[2][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 252, -1, -1, -1, 244, 245, 246, -1, -1, 231, 232, -1, -1 }
layers[2][7] = { 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 247, 248, -1, -1 }
layers[2][8] = { 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][9] = { 53, -1, -1, -1, -1, -1, -1, 257, 258, -1, 260, 261, -1, 263, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][10] = { 115, 21, -1, -1, -1, -1, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][11] = { 36, 37, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 240, -1, -1, -1 }
layers[2][12] = { 52, 53, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][13] = { 114, 115, 4, -1, -1, -1, 320, 321, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][14] = { -1, 131, 20, 21, -1, -1, 336, 337, -1, -1, -1, -1, -1, -1, 344, 345, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][15] = { -1, -1, -1, -1, -1, -1, 352, 353, -1, -1, -1, -1, -1, -1, 360, 361, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][16] = { -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, 377, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][17] = { -1, -1, -1, -1, -1, -1, 384, -1, -1, -1, -1, -1, -1, -1, -1, 393, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, -1, 260, 261, 260, 261, -1, -1, 260, 261, 260, 261, 260, 261, -1, 263, 264, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][20] = { -1, -1, 257, 258, -1, 260, 261, -1, 263, 264, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 272, 273, 274, 275, 276, 277, 276, 277, 278, 278, 276, 277, 276, 277, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][21] = { -1, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][22] = { -1, 288, 289, 290, 291, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][23] = { -1, 304, 305, 306, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][24] = { -1, 320, 321, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][25] = { -1, 416, 337, -1, -1, -1, -1, -1, -1, 344, 425, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][26] = { -1, 432, 353, -1, -1, -1, -1, -1, -1, 360, 441, -1, 1, 2, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 369, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, 215, 216, -1, -1, -1 }
layers[2][27] = { -1, 448, -1, -1, -1, -1, -1, -1, -1, -1, 457, 16, 17, 18, 19, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 464, 465, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, 231, 232, -1, -1, -1 }
layers[2][28] = { -1, 464, -1, -1, -1, -1, -1, -1, -1, -1, 473, -1, 252, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 305, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, 247, 248, -1, -1, -1 }
layers[2][29] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][30] = { 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 247, 248, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 416, 337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 344, 425, -1, -1, -1, -1, -1, 252, -1, -1 }
layers[2][31] = { 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 360, 441, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][32] = { 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 369, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 376, 457, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][33] = { 115, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 112, 113, 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 464, 465, -1, -1, -1, -1, -1, -1, -1, -1, -1, 365, 472, 473, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][34] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, -1, 52, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][35] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, 114, 115, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][36] = { -1, 115, 2, 3, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48, -1, -1, -1, -1, 131, 24, 25, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][37] = { -1, 131, 18, 19, 24, 25, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 112, 113, -1, -1, -1, -1, -1, -1, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][38] = { -1, -1, -1, -1, 40, 41, 24, 25, 4, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, 196, 197, 198, -1, -1, -1, -1, -1, 115, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][39] = { -1, -1, -1, -1, -1, -1, 40, 41, 20, 21, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, 212, 213, 214, -1, -1, -1, -1, -1, -1, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }


-- Valyria Tear map editor end. Do not edit this line. Place your scripts after this line. --

-- c++ objects instances
local Map = {};
local ObjectManager = {};
local DialogueManager = {};
local EventManager = {};
local GlobalEvents = {};

local bronann = {};
local kalya = {};

-- Main npcs
local orlinn = {};
local georges = {};
local carson = {};
local herth = {};
local olivia = {}; -- Olivia npc, guarding the forest entrance

-- the main map loading code
function Load(m)

	Map = m;
	ObjectManager = Map.object_supervisor;
	DialogueManager = Map.dialogue_supervisor;
	EventManager = Map.event_supervisor;

	Map.unlimited_stamina = true;

	_CreateCharacters();
	-- Set the camera focus on Bronann
	Map:SetCamera(bronann);

	_CreateNPCs();
	_CreateObjects();

	_CreateEvents();
	_CreateZones();

	_TriggerPotentialDialogueAfterFadeIn();

	-- Add clouds overlay
	Map:GetEffectSupervisor():EnableAmbientOverlay("img/ambient/clouds.png", 5.0, 5.0, true);

    -- Set the world map current position
    GlobalManager:SetCurrentLocationId("layna village")

	_HandleCredits();
end

-- Handle the display of the new game credits
function _HandleCredits()
    -- Handle small credits triggering
    if (GlobalManager:DoesEventExist("game", "Start_Credits") == false) then
        -- Triggers the small credits display
        GlobalManager:SetEventValue("game", "Start_Credits", 1);
    end
    if (GlobalManager:DoesEventExist("game", "Credits_shown") == false) then
        Map:GetScriptSupervisor():AddScript("dat/credits/episode1_credits.lua");
    end
end

function Update()
	-- Check whether the character is in one of the zones
	_CheckZones();
end


-- Character creation
function _CreateCharacters()
	bronann = CreateSprite(Map, "Bronann", 12, 63);
	bronann:SetDirection(hoa_map.MapMode.SOUTH);
	bronann:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);

	-- set up the position according to the previous map
	if (GlobalManager:GetPreviousLocation() == "from_riverbank") then
		bronann:SetPosition(30, 77);
		bronann:SetDirection(hoa_map.MapMode.NORTH);
	elseif (GlobalManager:GetPreviousLocation() == "from_village_south") then
		bronann:SetPosition(79, 77);
		bronann:SetDirection(hoa_map.MapMode.NORTH);
	elseif (GlobalManager:GetPreviousLocation() == "from_kalya_house_path") then
		bronann:SetPosition(3, 11);
		bronann:SetDirection(hoa_map.MapMode.EAST);
	elseif (GlobalManager:GetPreviousLocation() == "from_shop") then
		bronann:SetPosition(94, 72);
		bronann:SetDirection(hoa_map.MapMode.SOUTH);
		AudioManager:PlaySound("snd/door_close.wav");
	elseif (GlobalManager:GetPreviousLocation() == "from_secret_path") then
		bronann:SetPosition(3, 60);
		bronann:SetDirection(hoa_map.MapMode.EAST);
	elseif (GlobalManager:GetPreviousLocation() == "from sophia's house") then
		AudioManager:PlaySound("snd/door_close.wav");
		bronann:SetPosition(22, 20);
		bronann:SetDirection(hoa_map.MapMode.NORTH);
	elseif (GlobalManager:GetPreviousLocation() == "from_layna_forest_entrance") then
		bronann:SetPosition(115, 37);
		bronann:SetDirection(hoa_map.MapMode.WEST);
	elseif (GlobalManager:GetPreviousLocation() == "from_bronanns_home") then
		AudioManager:PlaySound("snd/door_close.wav");
	end

	Map:AddGroundObject(bronann);
end

function _CreateNPCs()
	local npc = {}
	local text = {}
	local dialogue = {}
	local event = {}

	kalya = CreateSprite(Map, "Kalya", 42, 18);
	Map:AddGroundObject(kalya);
	event = hoa_map.RandomMoveSpriteEvent("Kalya random move", kalya, 1000, 2000);
	event:AddEventLinkAtEnd("Kalya random move", 2000); -- Loop on itself
	EventManager:RegisterEvent(event);
	EventManager:StartEvent("Kalya random move");
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Please, leave me alone, Bronann...");
	dialogue:AddLineEmote(text, kalya, "exclamation");
	DialogueManager:AddDialogue(dialogue);
	kalya:AddDialogueReference(dialogue);

	orlinn = CreateSprite(Map, "Orlinn", 40, 18);
	Map:AddGroundObject(orlinn);
	-- Setup Orlinn's state and dialogue depending on the story current context
	_UpdateOrlinnAndKalyaState();

	carson = CreateSprite(Map, "Carson", 0, 0);
	-- Default behaviour - not present on map.
	carson:SetVisible(false);
	carson:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	Map:AddGroundObject(carson);

	herth = CreateSprite(Map, "Herth", 0, 0);
	-- Default behaviour - not present on map.
	herth:SetVisible(false);
	herth:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	Map:AddGroundObject(herth);

	npc = CreateNPCSprite(Map, "Old Woman1", "Brymir", 72, 64);
	Map:AddGroundObject(npc);
	npc:SetDirection(hoa_map.MapMode.WEST);
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Ahh sure! (gossip, gossip)");
	dialogue:AddLine(text, npc);
	DialogueManager:AddDialogue(dialogue);
	npc:AddDialogueReference(dialogue);

	npc = CreateNPCSprite(Map, "Woman1", "Martha", 70, 64);
	Map:AddGroundObject(npc);
	npc:SetDirection(hoa_map.MapMode.EAST);
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Did you hear that? (gossip, gossip)");
	dialogue:AddLine(text, npc);
	DialogueManager:AddDialogue(dialogue);
	npc:AddDialogueReference(dialogue);

	npc = CreateNPCSprite(Map, "Woman2", "Sophia", 22, 38);
	Map:AddGroundObject(npc);
	npc:SetDirection(hoa_map.MapMode.SOUTH);
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("You're too young to trade stuff with me!");
	if (GlobalManager:DoesEventExist("layna_south_entrance", "quest1_orlinn_hide_n_seek1_done") == true) then
		if (GlobalManager:DoesEventExist("layna_riverbank", "quest1_orlinn_hide_n_seek2_done") == false) then
			text = hoa_system.Translate("If you're running after Orlinn, I just saw him disappear near your house.");
		end
	end
	dialogue:AddLine(text, npc);
	DialogueManager:AddDialogue(dialogue);
	npc:AddDialogueReference(dialogue);
	-- Add her cat, Nekko
	object = CreateObject(Map, "Cat1", 24, 37.6);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	georges = CreateNPCSprite(Map, "Man1", "Georges", 32, 76);
	Map:AddGroundObject(georges);
	georges:SetDirection(hoa_map.MapMode.WEST);
	_UpdateGeorgesDialogue(georges);

    -- Olivia, guardian of the forest access
    olivia = CreateNPCSprite(Map, "Girl1", "Olivia", 115, 34);
    olivia:SetDirection(hoa_map.MapMode.SOUTH);
	Map:AddGroundObject(olivia);
    _UpdateOliviaDialogue();

    -- Needed look at events
    event = hoa_map.LookAtSpriteEvent("Bronann looks at Olivia", bronann, olivia);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Bronann looks south", bronann, hoa_map.MapMode.SOUTH);
    EventManager:RegisterEvent(event);
end

function _CreateObjects()
	local object = {}

	object = CreateObject(Map, "Tree Big2", 22, 78);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Small1", 22, 16);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big1", 9, 16);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big1", 65, 18);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big2", 74, 20);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big1", 67, 32);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big2", 80, 36);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Small1", 92, 22);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Big2", 98, 24);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Tree Small2", 79, 16);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Rock1", 3, 64);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 2, 62);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock1", 33, 12);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	object = CreateObject(Map, "Rock2", 29, 16);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 109, 34);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 113, 34);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 117, 34);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 109, 42);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 117, 42);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Rock2", 113, 42);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	-- collision bug hidders
	object = CreateObject(Map, "Barrel1", 14, 38);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Vase1", 15, 39);
	if (object ~= nil) then Map:AddGroundObject(object) end;
	object = CreateObject(Map, "Barrel1", 30, 38);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	-- Lights
	-- big round windows light flares
	Map:AddLight("img/misc/lights/sun_flare_light_main.lua",
		    "img/misc/lights/sun_flare_light_secondary.lua",
	    74.0, 55.0,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);

	Map:AddLight("img/misc/lights/sun_flare_light_main.lua",
		    "img/misc/lights/sun_flare_light_secondary.lua",
	    86.0, 67.0,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);
	Map:AddLight("img/misc/lights/sun_flare_light_main.lua",
		    "img/misc/lights/sun_flare_light_secondary.lua",
	    22.0, 32.0,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);

	-- Small door lights
	Map:AddLight("img/misc/lights/sun_flare_light_small_main.lua",
		    "img/misc/lights/sun_flare_light_small_secondary.lua",
	    12.0, 57.5,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	  hoa_map.MapMode.CONTEXT_01);
	Map:AddLight("img/misc/lights/sun_flare_light_small_main.lua",
		    "img/misc/lights/sun_flare_light_small_secondary.lua",
	    94.0, 67.5,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);

	-- Treasure vase
	local nekko_vase = CreateTreasure(Map, "layna_center_nekko_vase", "Vase1", 27, 37);
	if (nekko_vase ~= nil) then
		nekko_vase:AddObject(11, 1);
		Map:AddGroundObject(nekko_vase);
	end

	-- Quest 2: Forest event
	-- The wooden sword sprite
	wooden_sword = CreateObject(Map, "Wooden Sword1", 1, 1);
	Map:AddGroundObject(wooden_sword);
	wooden_sword:SetVisible(false);
	wooden_sword:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
end

-- Creates all events and sets up the entire event sequence chain
function _CreateEvents()
	local event = {};
	local text = {};
	local dialogue = {};

	-- Triggered Events
	event = hoa_map.MapTransitionEvent("to Bronann's home", "dat/maps/layna_village/layna_village_bronanns_home.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Riverbank", "dat/maps/layna_village/layna_village_riverbank.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Village south entrance", "dat/maps/layna_village/layna_village_south_entrance.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Kalya house path", "dat/maps/layna_village/layna_village_kalya_house_path.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Flora's Shop", "dat/maps/layna_village/layna_village_center_shop.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to sophia house", "dat/maps/layna_village/layna_village_center_sophia_house.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to secret cliff", "dat/maps/layna_village/layna_village_riverbank.lua", "from_secret_path");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to layna forest entrance", "dat/maps/layna_forest/layna_forest_entrance.lua", "from_village_center");
	EventManager:RegisterEvent(event);

	-- Generic events
	event = hoa_map.ScriptedEvent("Map:PushState(SCENE)", "Map_SceneState", "");
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedEvent("Map:PopState()", "Map_PopState", "");
	EventManager:RegisterEvent(event);

	-- Quest events
	-- Bronann wonders where he can find barley meal
	event = hoa_map.ScriptedEvent("Quest1: Bronann wonders where he can find some barley meal", "Map_SceneState", "");
	event:AddEventLinkAtEnd("Quest1: Bronann wants to see Flora for the barley meal", 1000);
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Hmm, I'll go to Flora's shop. I hope she'll help me...");
	dialogue:AddLineEmote(text, bronann, "thinking dots");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest1: Bronann wants to see Flora for the barley meal", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("Map:PopState()");
	EventManager:RegisterEvent(event);

	-- Georges
	event = hoa_map.ScriptedEvent("Quest1: GeorgesDialogueDone", "Quest1GeorgesDialogueDone", "");
	EventManager:RegisterEvent(event);

	-- Orlinn
	event = hoa_map.ScriptedEvent("Quest1: Make Orlinn run and hide", "Quest1OrlinnRunAndHide", "");
	event:AddEventLinkAtEnd("Quest1: Make Orlinn run");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest1: Make Orlinn run", orlinn, 30, 79, true);
	event:AddEventLinkAtEnd("Quest1: Make Orlinn disappear");
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedSpriteEvent("Quest1: Make Orlinn disappear", orlinn, "MakeInvisible", "");
	EventManager:RegisterEvent(event);

	-- Georges event
	event = hoa_map.ScriptedEvent("Quest1: Georges tells whom the barley meal was for", "Quest1GeorgesTellsBronannAboutLilly", "");
	EventManager:RegisterEvent(event);

	-- Quest 2: Bronann wants to go to Flora's and buy a sword to go in the forest
	event = hoa_map.ScriptedEvent("Quest2: Bronann wants to buy a sword from Flora", "Map_SceneState", "");
	event:AddEventLinkAtEnd("Quest2: Bronann wants to see Flora for equipment", 1000);
	event:AddEventLinkAtEnd("Bronann is sad");
	EventManager:RegisterEvent(event);

	event = hoa_map.AnimateSpriteEvent("Bronann is sad", bronann, "hero_stance", 2000);
	EventManager:RegisterEvent(event);
	event = hoa_map.AnimateSpriteEvent("Bronann is frightnened", bronann, "frightened", 0);
	EventManager:RegisterEvent(event);
	event = hoa_map.AnimateSpriteEvent("Bronann searches", bronann, "searching", 0);
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Why doesn't anyone want to tell me what's going on!!");
	dialogue:AddLineEmote(text, bronann, "exclamation");
	text = hoa_system.Translate("Still, I have go there and figure out what they're trying to hide from me.");
	dialogue:AddLineEmote(text, bronann, "thinking dots");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Bronann wants to see Flora for equipment", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("Map:PopState()");
	EventManager:RegisterEvent(event);

	-- Quest 2: Bronann doesn't want to see his parents for the moment
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("No, I won't go there. I just can't talk to them at the moment...");
	dialogue:AddLine(text, bronann);
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Bronann doesn't want to see his parents", dialogue);
	event:SetStopCameraMovement(true);
	EventManager:RegisterEvent(event);

	-- Quest 2: The forest event
	event = hoa_map.ScriptedEvent("Quest2: Forest event", "Prepare_forest_event", "");
	event:AddEventLinkAtEnd("Quest2: Forest event - light", 1200);
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedEvent("Quest2: Forest event - light", "BrightLightStart", "BrightLightUpdate");
	event:AddEventLinkAtEnd("Quest2: Bronann wonders what was that", 500);
	event:AddEventLinkAtEnd("Bronann searches");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Huh? What was that light?");
	dialogue:AddLineEmote(text, bronann, "interrogation");
	text = hoa_system.Translate("... Bronann! Wait!");
	dialogue:AddLine(text, carson);
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Bronann wonders what was that", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("Quest2: Carson moves to Bronann");
    event:AddEventLinkAtEnd("Quest2: Bronann looks at his father");
	EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest2: Carson moves to Bronann", carson, 89.0, 74.0, false);
    event:AddEventLinkAtEnd("Quest2: Carson starts to talk to Bronann");
    EventManager:RegisterEvent(event);

    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Bronann looks at his father", bronann, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Herth looks at Carson", herth, hoa_map.MapMode.NORTH);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Herth looks at Kalya", herth, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Carson looks at Herth", carson, hoa_map.MapMode.SOUTH);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Carson looks at Kalya", carson, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Carson looks at Bronann", carson, hoa_map.MapMode.EAST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Kalya looks at Carson", kalya, hoa_map.MapMode.NORTH);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Kalya looks at Bronann", kalya, hoa_map.MapMode.EAST);
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("I suppose you just saw that light, right?");
	dialogue:AddLine(text, carson);
	text = hoa_system.Translate("... Hmmm...");
	dialogue:AddLine(text, bronann);
	text = hoa_system.Translate("Bronann, there is something that I have to tell you. We've been fearing for this moment. I mean your mother and I...");
	dialogue:AddLine(text, carson);
	text = hoa_system.Translate("They're coming!");
	dialogue:AddLineEvent(text, herth, "", "Quest2: Carson looks at Herth");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Carson starts to talk to Bronann", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("Quest2: Herth moves to Carson");
	EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest2: Herth moves to Carson", herth, 90.0, 76.0, false);
    event:AddEventLinkAtEnd("Quest2: Herth looks at Carson");
    event:AddEventLinkAtEnd("Quest2: Second part of talk");
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Carson, they've passed the river. They shall be here in no time.");
	dialogue:AddLine(text, herth);
	text = hoa_system.Translate("...");
	dialogue:AddLineEmote(text, carson, "sweat drop");
	text = hoa_system.Translate("Huh? Hey, what's happening here?!");
	dialogue:AddLineEventEmote(text, bronann, "", "Quest2: Carson looks at Bronann", "exclamation");
	text = hoa_system.Translate("Bronann, I ...");
	dialogue:AddLine(text, carson);
	text = hoa_system.Translate("Father!");
	dialogue:AddLineEvent(text, kalya, "", "Quest2: Herth looks at Kalya");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Second part of talk", dialogue);
	event:SetStopCameraMovement(true);
	event:AddEventLinkAtEnd("Quest2: Kalya runs to her father");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya runs to her father", kalya, 88.0, 76.0, true);
	event:AddEventLinkAtEnd("Quest2: Third part of talk");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Father! Orlinn has disappeared. I saw him taking the forest pathway!");
	dialogue:AddLineEvent(text, kalya, "", "Quest2: Carson looks at Herth");
	text = hoa_system.Translate("Kalya! You were supposed to keep an eye on him!");
	dialogue:AddLineEmote(text, herth, "exclamation");
	text = hoa_system.Translate("I did, but he just slipped through my fingers at the very second that strange light appeared.");
	dialogue:AddLineEmote(text, kalya, "sweat drop");
	text = hoa_system.Translate("Kalya, the army is coming. I'll deal with them, you, go and find Orlinn as fast as possible.");
	dialogue:AddLineEmote(text, herth, "thinking dots");
	text = hoa_system.Translate("But you might get hurt!");
	dialogue:AddLineEmote(text, kalya, "exclamation");
	text = hoa_system.Translate("No, don't worry. We'll simply talk to them and they'll move on. You know what you have to do, right?");
	dialogue:AddLine(text, herth);
	text = hoa_system.Translate("Herth, we both know it'll likely...");
	dialogue:AddLine(text, kalya);
	text = hoa_system.Translate("Do as I say and it'll be alright.");
	dialogue:AddLine(text, herth);
	text = hoa_system.Translate("But...");
	dialogue:AddLineEvent(text, kalya, "", "Quest2: Carson looks at Bronann");
	text = hoa_system.Translate("Bronann, you should go with her.");
	dialogue:AddLineEventEmote(text, carson, "", "Quest2: Kalya looks at Carson", "thinking dots");
	text = hoa_system.Translate("What?!?");
	dialogue:AddLineEventEmote(text, kalya, "", "Quest2: Kalya looks at Herth", "exclamation");
	text = hoa_system.Translate("Huh?");
	dialogue:AddLineEvent(text, bronann, "","Bronann is frightnened");
	text = hoa_system.Translate("Carson is right, Kalya. Bronann shall go with you.");
	dialogue:AddLineEvent(text, herth, "", "Quest2: Kalya looks at Bronann");
	text = hoa_system.Translate("But he would just be a burden!");
	dialogue:AddLineEvent(text, kalya, "", "Bronann is sad");
	text = hoa_system.Translate("Huh? Hey! But...");
	dialogue:AddLineEmote(text, bronann, "exclamation");
	text = hoa_system.Translate("He won't slow you down, believe me. Right, Bronann?");
	dialogue:AddLineEvent(text, carson, "", "Quest2: Carson looks at Bronann");
	text = hoa_system.Translate("But father!");
	dialogue:AddLineEvent(text, kalya, "", "Quest2: Kalya looks at Herth");
	text = hoa_system.Translate("Carson is right, Kalya. Bronann shall go with you. It's... it's an order.");
	dialogue:AddLineEmote(text, herth, "thinking dots");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Third part of talk", dialogue);
	event:AddEventLinkAtEnd("Quest2: Kalya goes back and forth");
	EventManager:RegisterEvent(event);

	-- Small event chain making kalya go back and forth.
	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya goes back and forth", kalya, 85.0, 76.0, false);
	event:AddEventLinkAtEnd("Quest2: Carson looks at Kalya");
	event:AddEventLinkAtEnd("Quest2: Kalya goes back and forth 2");
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya goes back and forth 2", kalya, 88.0, 76.0, false);
	event:AddEventLinkAtEnd("Quest2: Kalya goes back and forth 3");
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya goes back and forth 3", kalya, 85.0, 76.0, false);
	event:AddEventLinkAtEnd("Quest2: Kalya goes back and forth 4");
	EventManager:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya goes back and forth 4", kalya, 88.0, 76.0, false);
	event:AddEventLinkAtEnd("Quest2: Fourth part of talk");
	EventManager:RegisterEvent(event);

	event = hoa_map.ScriptedEvent("Quest2: Show the wooden sword item in front of carson", "Show_wooden_sword", "");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Gahh... ok.");
	dialogue:AddLineEvent(text, kalya, "", "Quest2: Carson looks at Bronann");
	text = hoa_system.Translate("Bronann, take this sword. You'll probably need it to make your way through there.");
	dialogue:AddLineEvent(text, carson, "", "Quest2: Show the wooden sword item in front of carson");
	text = hoa_system.Translate("What? But one minute ago you said...");
	dialogue:AddLineEmote(text, bronann, "exclamation");
	text = hoa_system.Translate("I know, but everything has changed. I'll explain it to you once it is all finished. Now go, my son.");
	dialogue:AddLine(text, carson);
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Fourth part of talk", dialogue);
	event:AddEventLinkAtEnd("Quest2: Bronann goes and take the sword");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest2: Bronann goes and take the sword", bronann, 92.0, 73.0, false);
	event:AddEventLinkAtEnd("Quest2: Hide the wooden sword item");
	event:AddEventLinkAtEnd("Quest2: Add the wooden sword in inventory");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedEvent("Quest2: Hide the wooden sword item", "Hide_wooden_sword", "");
	EventManager:RegisterEvent(event);
	event = hoa_map.TreasureEvent("Quest2: Add the wooden sword in inventory");
	event:AddObject(10001, 1); -- The wooden sword item
	event:AddEventLinkAtEnd("Quest2: Fifth part of talk");
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Thanks dad, we'll find him in no time.");
	dialogue:AddLine(text, bronann);
	text = hoa_system.Translate("We shall go now... Good luck, both of you.");
	dialogue:AddLineEvent(text, herth, "", "Quest2: Herth looks at Kalya");
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Fifth part of talk", dialogue);
	event:AddEventLinkAtEnd("Quest2: Herth leaves to south");
	event:AddEventLinkAtEnd("Quest2: Carson starts to leave to south");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest2: Herth leaves to south", herth, 92.0, 78.0, false);
	event:AddEventLinkAtEnd("Quest2: Herth disappears");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedSpriteEvent("Quest2: Herth disappears", herth, "MakeInvisible", "");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest2: Carson starts to leave to south", carson, 90.0, 76.0, false);
	event:AddEventLinkAtEnd("Quest2: Carson talks to Bronann once last time");
	event:AddEventLinkAtEnd("Quest2: Carson looks at Bronnan from south");
	EventManager:RegisterEvent(event);

	event = hoa_map.ChangeDirectionSpriteEvent("Quest2: Carson looks at Bronnan from south", carson, hoa_map.MapMode.NORTH);
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Good luck, son.");
	dialogue:AddLine(text, carson);
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Carson talks to Bronann once last time", dialogue);
	event:AddEventLinkAtEnd("Quest2: Carson leaves to south");
	EventManager:RegisterEvent(event);

	event = hoa_map.PathMoveSpriteEvent("Quest2: Carson leaves to south", carson, 92.0, 78.0, false);
	event:AddEventLinkAtEnd("Quest2: Carson disappears");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedSpriteEvent("Quest2: Carson disappears", carson, "MakeInvisible", "");
	event:AddEventLinkAtEnd("Quest2: End part of talk", 1000);
	EventManager:RegisterEvent(event);

	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Ok, we'll go together. But slow me down and I'll make you regret it...");
	dialogue:AddLine(text, kalya);
	text = hoa_system.Translate("Don't worry, we'll find him. Ok?");
	dialogue:AddLine(text, bronann);
	text = hoa_system.Translate("Ok ...");
	dialogue:AddLine(text, kalya);
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: End part of talk", dialogue);
	event:AddEventLinkAtEnd("Quest2: Kalya joins Bronann's party");
	EventManager:RegisterEvent(event);

	-- TODO: Turns this into an actual join party event once functional
	event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya joins Bronann's party", kalya, 92.0, 73.0, false);
	event:AddEventLinkAtEnd("Quest2: Kalya disappears");
	event:AddEventLinkAtEnd("Quest2: Add Kalya to the party");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedSpriteEvent("Quest2: Kalya disappears", kalya, "MakeInvisible", "");
	EventManager:RegisterEvent(event);
	event = hoa_map.ScriptedEvent("Quest2: Add Kalya to the party", "Add_kalya_to_party", "");
	event:AddEventLinkAtEnd("Quest2: Kalya joins speech");
	EventManager:RegisterEvent(event);
	dialogue = hoa_map.SpriteDialogue();
	text = hoa_system.Translate("Kalya joins your party!");
	dialogue:AddLine(text, kalya); --used for now to show her portrait
	DialogueManager:AddDialogue(dialogue);
	event = hoa_map.DialogueEvent("Quest2: Kalya joins speech", dialogue);
	event:AddEventLinkAtEnd("Map:PopState()");
	EventManager:RegisterEvent(event);

    -- Kalya explains Bronnan about dungeons and equipment,
    event = hoa_map.ScriptedEvent("Quest2: Kalya's equipment and dungeons speech start", "Quest2_equip_speech_start", "");
    event:AddEventLinkAtEnd("Quest2: Kalya walks off from Bronann");
    event:AddEventLinkAtEnd("Quest2: Bronann goes in front of Kalya");
    EventManager:RegisterEvent(event);

    event = hoa_map.ChangeDirectionSpriteEvent("Kalya looks east", kalya, hoa_map.MapMode.EAST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Bronann looks west", bronann, hoa_map.MapMode.WEST);
    EventManager:RegisterEvent(event);
    event = hoa_map.ScriptedSpriteEvent("Turn Kalya's collisions on", kalya, "Sprite_Collision_on", "");
    EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya walks off from Bronann", kalya, 114, 37, false);
    event:AddEventLinkAtEnd("Kalya looks east");
    event:AddEventLinkAtEnd("Turn Kalya's collisions on");
    event:AddEventLinkAtEnd("Quest2: Kalya's speech about equipment and dungeons.");
    EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest2: Bronann goes in front of Kalya", bronann, 116, 37, false);
    event:AddEventLinkAtEnd("Bronann looks west");
    EventManager:RegisterEvent(event);

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("By the way, did you ever prepare yourself for something like this before?");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("Huh? Well, Orlinn doesn't disappear every day, you know?");
    dialogue:AddLineEmote(text, bronann, "thinking dots");
    text = hoa_system.Translate("I see... Then there are two very important things that you need to know:");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("First of all before going there, you might need a better equipment. Go and see Flora first, ok?");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("And tell me that you equipped your sword ... If you haven't, open your inventory by pressing the menu key (")
           .. InputManager:GetMenuKeyName()
           .. hoa_system.Translate("), and select 'Equip'. Then you'll be able to select your sword and add it as your main weapon, ok?");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("You mean, like, I need to push a key to open my bag?");
    dialogue:AddLineEmote(text, bronann, "interrogation");
    text = hoa_system.Translate("Nevermind that, just do it.");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("The second thing is that the person in front of the battle line will lead the group in the forest. By that I mean that the person on the top of the battle formation will actually appear, while the others will stay hidden.");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("Hmm, right. I'm not sure that I fully get what you mean, but...");
    dialogue:AddLine(text, bronann);
    text = hoa_system.Translate("Rrrr... Bronann. Just listen.");
    dialogue:AddLine(text, kalya);
    text = hoa_system.Translate("That will be the case only in certain areas. Here in the village, you'll be the one leading, or at least you may believe that ...");
    dialogue:AddLine(text, kalya);
    DialogueManager:AddDialogue(dialogue);
    event = hoa_map.DialogueEvent("Quest2: Kalya's speech about equipment and dungeons.", dialogue);
    event:AddEventLinkAtEnd("Quest2: Kalya re-joins Bronann after speech");
    EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest2: Kalya re-joins Bronann after speech", kalya, 116, 37, false);
    event:AddEventLinkAtEnd("Quest2: Kalya disappears after speech");
    EventManager:RegisterEvent(event);

    event = hoa_map.ScriptedSpriteEvent("Quest2: Kalya disappears after speech", kalya, "MakeInvisible", "");
    event:AddEventLinkAtEnd("Map:PopState()");
    EventManager:RegisterEvent(event);
end

-- zones
local bronanns_home_entrance_zone = {};
local to_riverbank_zone = {};
local to_village_entrance_zone = {};
local to_kalya_house_path_zone = {};
local shop_entrance_zone = {};
local secret_path_zone = {};
local to_layna_forest_zone = {};
local sophia_house_entrance_zone = {};

function _CreateZones()
	-- N.B.: left, right, top, bottom
	bronanns_home_entrance_zone = hoa_map.CameraZone(10, 14, 60, 61, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(bronanns_home_entrance_zone);

	to_riverbank_zone = hoa_map.CameraZone(19, 35, 78, 79, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_riverbank_zone);

	to_village_entrance_zone = hoa_map.CameraZone(60, 113, 78, 79, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_village_entrance_zone);

	to_kalya_house_path_zone = hoa_map.CameraZone(0, 1, 8, 15, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_kalya_house_path_zone);

	shop_entrance_zone = hoa_map.CameraZone(92, 96, 70, 71, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(shop_entrance_zone);

	secret_path_zone = hoa_map.CameraZone(0, 1, 55, 61, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(secret_path_zone);

	to_layna_forest_zone = hoa_map.CameraZone(117, 119, 30, 43, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_layna_forest_zone);

	sophia_house_entrance_zone = hoa_map.CameraZone(21, 23, 21, 22, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(sophia_house_entrance_zone);
end

function _CheckZones()
	if (bronanns_home_entrance_zone:IsCameraEntering() == true) then
		-- If Bronann has started the quest 2, he doesn't want to go back and see his parents.
		if (GlobalManager:DoesEventExist("story", "Quest2_started") == true
			and GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == false) then
			EventManager:StartEvent("Quest2: Bronann doesn't want to see his parents");
			return;
		end
		bronann:SetMoving(false);
		AudioManager:PlaySound("snd/door_open2.wav");
		EventManager:StartEvent("to Bronann's home");
	elseif (to_riverbank_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		EventManager:StartEvent("to Riverbank");
	elseif (to_village_entrance_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		EventManager:StartEvent("to Village south entrance");
	elseif (to_kalya_house_path_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		EventManager:StartEvent("to Kalya house path");
	elseif (secret_path_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		EventManager:StartEvent("to secret cliff");
	elseif (to_layna_forest_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == false) then
			EventManager:StartEvent("Bronann can't enter the forest so easily");
		elseif (GlobalManager:DoesEventExist("story", "Quest2_kalya_equip_n_dungeons_speech_done") == false) then
			EventManager:StartEvent("Quest2: Kalya's equipment and dungeons speech start");
		else
			EventManager:StartEvent("to layna forest entrance");
		end
	elseif (shop_entrance_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		AudioManager:PlaySound("snd/door_open2.wav");
		EventManager:StartEvent("to Flora's Shop");
	elseif (sophia_house_entrance_zone:IsCameraEntering() == true) then
		bronann:SetMoving(false);
		EventManager:StartEvent("to sophia house");
		AudioManager:PlaySound("snd/door_open2.wav");
	end
end

-- Inner custom functions
function _TriggerPotentialDialogueAfterFadeIn()
	-- Trigger the forest and Orlinn runaway event
	if (GlobalManager:DoesEventExist("story", "Quest2_flora_dialogue_done") == true
			and GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == false) then
		EventManager:StartEvent("Quest2: Forest event");
		GlobalManager:SetEventValue("story", "Quest2_forest_event_done", 1);
		return;
	end

	if (GlobalManager:DoesEventExist("story", "Quest2_started") == true) then
		if (GlobalManager:DoesEventExist("story", "Quest2_wants_to_buy_sword_dialogue") == false) then
			EventManager:StartEvent("Quest2: Bronann wants to buy a sword from Flora");
			GlobalManager:SetEventValue("story", "Quest2_wants_to_buy_sword_dialogue", 1);
			return;
		end
	elseif (GlobalManager:DoesEventExist("layna_center", "first_time_in_village_center") == false) then
		EventManager:StartEvent("Quest1: Bronann wonders where he can find some barley meal");
		GlobalManager:SetEventValue("layna_center", "first_time_in_village_center", 1);
		return;
	end
end

-- Updates Olivia dialogues according to the story events
function _UpdateOliviaDialogue()
    olivia:ClearDialogueReferences();

    -- Don't grant access to the forest so easily
    if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == false) then
        if (GlobalManager:DoesEventExist("story", "Quest2_wants_to_buy_sword_dialogue") == false
            and GlobalManager:DoesEventExist("story", "Quest2_started") == true) then
            dialogue = hoa_map.SpriteDialogue();
            text = hoa_system.Translate("Bronann! Sorry, you can't access the forest without permission. You don't even have a sword...");
            dialogue:AddLineEmote(text, olivia, "exclamation");
            text = hoa_system.Translate("Aww...");
            dialogue:AddLineEventEmote(text, bronann, "Bronann looks at Olivia", "", "sweat drop");
            text = hoa_system.Translate("(Hmm, maybe I should get a sword then.)");
            dialogue:AddLineEventEmote(text, bronann, "Bronann looks south", "", "thinking dots");
            DialogueManager:AddDialogue(dialogue);
            olivia:AddDialogueReference(dialogue);
        else
            dialogue = hoa_map.SpriteDialogue();
            text = hoa_system.Translate("Bronann! Sorry, you know you can't access the forest without permission.");
            dialogue:AddLineEmote(text, olivia, "exclamation");
            text = hoa_system.Translate("Aww...");
            dialogue:AddLineEventEmote(text, bronann, "Bronann looks at Olivia", "", "sweat drop");
            DialogueManager:AddDialogue(dialogue);
            olivia:AddDialogueReference(dialogue);
        end
    else
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Good luck Bronann.");
        dialogue:AddLine(text, olivia);
        DialogueManager:AddDialogue(dialogue);
        olivia:AddDialogueReference(dialogue);
    end

    -- Special event triggered when Bronann hasn't go the right to enter the forest yet.
    -- Shouldn't trigger once access is granted.
    event = hoa_map.DialogueEvent("Bronann can't enter the forest so easily", dialogue);
	event:SetStopCameraMovement(true);
	EventManager:RegisterEvent(event);
end

-- Updates Georges dialogue depending on how far is the story going.
function _UpdateGeorgesDialogue()
	local text = {}
	local dialogue = {}

    georges:ClearDialogueReferences();

    if (GlobalManager:DoesEventExist("story", "quest1_barley_meal_done") == true) then
	-- default behaviour once the barley meal is given
    elseif (GlobalManager:DoesEventExist("layna_center", "quest1_pen_given_done") == true
        and GlobalManager:DoesEventExist("story", "quest1_barley_meal_done") == false) then
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Actually, the barley meal was for Lilly.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("!! What?");
        dialogue:AddLineEmote(text, bronann, "exclamation");
        text = hoa_system.Translate("Don't thank me for that. It's my pleasure.");
        dialogue:AddLine(text, georges);
        DialogueManager:AddDialogue(dialogue);
        georges:AddDialogueReference(dialogue);
	return;
        -- Quest 1 done as for Georges
    elseif (GlobalManager:DoesEventExist("layna_riverbank", "quest1_orlinn_hide_n_seek3_done") == true) then
        -- Give the pen to Georges
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Here it is, Georges.");
        dialogue:AddLine(text, bronann);
        text = hoa_system.Translate("You're the nicest person I know, Bronnan. I well tell everyone how brave you...");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("(Sigh...) Georges!");
        dialogue:AddLine(text, bronann);
        text = hoa_system.Translate("Ok ok. Just having a bit of spirit, young man.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Actually, the barley meal was for Lilly.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("!! What?");
        dialogue:AddLineEmote(text, bronann, "exclamation");
        text = hoa_system.Translate("Don't thank me for that, it's my pleasure.");
        dialogue:AddLineEvent(text, georges, "", "Quest1: Georges tells whom the barley meal was for");
        DialogueManager:AddDialogue(dialogue);
        georges:AddDialogueReference(dialogue);
        return;
    elseif (GlobalManager:DoesEventExist("layna_center", "quest1_georges_dialogue_done") == true) then
        -- Once talked to him after the shop conversation, just put the end of the dialogue
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("You see, I lost my beloved pen. Was it near a tree or next to the waving child of the mountain snow?");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Shall you find it, I would be entrustfully obliged to you!");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Inquire our comrades in the settlement, perhaps somebody has laid their eyes on it.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("(Sigh...) Hmm, fine.");
        dialogue:AddLine(text, bronann);
        DialogueManager:AddDialogue(dialogue);
        georges:AddDialogueReference(dialogue);
        return;
    elseif (GlobalManager:DoesEventExist("layna_center_shop", "quest1_flora_dialogue_done") == true) then
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Hi Georges. Erm, I'm coming from the shop and I ...");
        dialogue:AddLine(text, bronann);
        text = hoa_system.Translate("Can you hear this?");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Erm, ... Well, I don't hear anything special...");
        dialogue:AddLineEmote(text, bronann, "interrogation");
        text = hoa_system.Translate("That's the point! Can't you hear the magnificient sound of nature, so invisible to our adapted ears?");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Huh, please Georges. I do not want to run away like the last time...");
        dialogue:AddLine(text, bronann);
        text = hoa_system.Translate("... The incredible and amazing. I could even say, the stunning feel of it in the wind...");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Georges, I simply wanted to ask you whether you had some barley meal left!");
        dialogue:AddLineEmote(text, bronann, "sweat drop");
        text = hoa_system.Translate("Ah, I see. Well unfortunately, I'm so sad about a recent loss that, I can't find the right words with which to tell you.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Huh?");
        dialogue:AddLineEmote(text, bronann, "interrogation");
        text = hoa_system.Translate("You see, I lost my beloved pen. Was it near a tree or next to the waving child of the mountain snow?");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Shall you find it, I would be entrustfully obliged to you!");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("Inquire our comrades in the settlement, perhaps somebody has laid their eyes on it.");
        dialogue:AddLine(text, georges);
        text = hoa_system.Translate("(Sigh...) Hmm, fine.");
        dialogue:AddLineEvent(text, bronann, "", "Quest1: GeorgesDialogueDone");
        DialogueManager:AddDialogue(dialogue);
        georges:AddDialogueReference(dialogue);
        return;
    end

    dialogue = hoa_map.SpriteDialogue();
    text = hoa_system.Translate("Ah, the river is so beautiful at this time of the year. I feel like writing some poetry...");
    dialogue:AddLine(text, georges);
    DialogueManager:AddDialogue(dialogue);
    georges:AddDialogueReference(dialogue);
end

-- Updates Orlinn's dialogue and state depending on how far is the story going.
function _UpdateOrlinnAndKalyaState()
	local text = {};
	local dialogue = {};
    local event = {};

    orlinn:ClearDialogueReferences();
    if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == true) then
        -- At that moment, Orlinn has disappeared and Kalya is now in Bronann's party.
        orlinn:SetVisible(false);
        orlinn:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        kalya:ClearDialogueReferences();
        kalya:SetVisible(false);
        kalya:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        EventManager:TerminateAllEvents(kalya);
        kalya:SetMoving(false);
        return;
    end
    if (GlobalManager:DoesEventExist("layna_riverbank", "quest1_orlinn_hide_n_seek3_done") == true) then
        -- Bronann got Georges' pen, update orlinn dialogue
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("I promise I won't bother you again ...");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("Don't worry about that, Orlinn. Ok?");
        dialogue:AddLine(text, bronann);
        DialogueManager:AddDialogue(dialogue);
        orlinn:AddDialogueReference(dialogue);

        -- Update kalya's dialogue too
        kalya:ClearDialogueReferences();
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("...");
        dialogue:AddLine(text, kalya);
        DialogueManager:AddDialogue(dialogue);
        kalya:AddDialogueReference(dialogue);


    elseif (GlobalManager:DoesEventExist("layna_center", "quest1_orlinn_dialogue1_done") == true) then
        -- At that time, Orlinn isn't in the village center anymore.
        orlinn:SetVisible(false);
        orlinn:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        return;
    elseif (GlobalManager:DoesEventExist("layna_center", "quest1_georges_dialogue_done") == true) then
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Hee hee hee!");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("What are you laughing about, Orlinn?");
        dialogue:AddLineEmote(text, bronann, "interrogation");
        text = hoa_system.Translate("You'll never find it!");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("Huh? Wait! Are you talking about Georges' lost pen?");
        dialogue:AddLineEmote(text, bronann, "exclamation");
        text = hoa_system.Translate("Hee hee hee! Yes!");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("Please tell me! Have you found it?");
        dialogue:AddLine(text, bronann);
        text = hoa_system.Translate("Maybe yes, maybe no!");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("Oh no, please Orlinn! I need it!");
        dialogue:AddLineEmote(text, bronann, "sweat drop");
        text = hoa_system.Translate("Sure, I'll help you. But only if you can catch me!");
        dialogue:AddLine(text, orlinn);
        text = hoa_system.Translate("Hee hee! (He'll never find me hiding behind the buildings!)");
        dialogue:AddLineEvent(text, orlinn, "", "Quest1: Make Orlinn run and hide");

        DialogueManager:AddDialogue(dialogue);
        orlinn:AddDialogueReference(dialogue);
    else
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Heya bro! Wanna play with me?");
        dialogue:AddLine(text, orlinn);
        DialogueManager:AddDialogue(dialogue);
        orlinn:AddDialogueReference(dialogue);
    end

	-- Default behaviour
	EventManager:TerminateAllEvents(orlinn);
	event = hoa_map.RandomMoveSpriteEvent("Orlinn random move", orlinn, 4000, 2000);
	event:AddEventLinkAtEnd("Orlinn random move", 3000); -- Loop on itself
	EventManager:RegisterEvent(event);
	EventManager:StartEvent("Orlinn random move");
end

-- Helps with the two step fade in the forest event
local bright_light_time = {}

-- Map Custom functions
map_functions = {

	Quest1GeorgesDialogueDone = function()
        GlobalManager:SetEventValue("layna_center", "quest1_georges_dialogue_done", 1);
        -- Makes Orlinn aware that Bronann has talked to Georges.
        _UpdateOrlinnAndKalyaState();
        _UpdateGeorgesDialogue();
        GlobalManager:AddQuestLog("find_pen");
	end,

    Quest1OrlinnRunAndHide = function()
        orlinn:SetMoving(false); -- in case he's moving
        orlinn:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
        orlinn:SetCollisionMask(hoa_map.MapMode.WALL_COLLISION);
        orlinn:ClearDialogueReferences();
		EventManager:TerminateAllEvents(orlinn);

        -- Updates Orlinn's state
		GlobalManager:SetEventValue("layna_center", "quest1_orlinn_dialogue1_done", 1);
        GlobalManager:AddQuestLog("hide_n_seek_with_orlinn");
    end,

    Quest1GeorgesTellsBronannAboutLilly = function()
        GlobalManager:SetEventValue("layna_center", "quest1_pen_given_done", 1);

        -- Remove the pen key item from inventory
        local pen_item_id = 70001;
        if (GlobalManager:IsObjectInInventory(pen_item_id) == true) then
            GlobalManager:RemoveFromInventory(pen_item_id);
        end

        -- Updates Georges dialogue
        _UpdateGeorgesDialogue();
    end,

    Prepare_forest_event = function()
        -- Scene event
        Map:PushState(hoa_map.MapMode.STATE_SCENE);
        carson:SetPosition(75.0, 72.0);
        carson:SetVisible(true);
        carson:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);

        herth:SetPosition(75.0, 77.0);
        herth:SetVisible(true);
        herth:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);

        EventManager:TerminateAllEvents(kalya);
        kalya:SetPosition(75.0, 68.0);
        kalya:SetMoving(false);
        kalya:ClearDialogueReferences();

        -- hide Orlinn has he's into the forest
        EventManager:TerminateAllEvents(orlinn);
        orlinn:SetMoving(false);
        orlinn:SetVisible(false);
        orlinn:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
    end,

    BrightLightStart = function()
        bright_light_time = 0.0;
        VideoManager:ShakeScreen(0.6, 6000, hoa_video.GameVideo.VIDEO_FALLOFF_GRADUAL);
        AudioManager:PlaySound("snd/rumble.wav");
        AudioManager:FadeOutAllMusic(2000);
    end,

    BrightLightUpdate = function()
        bright_light_time = bright_light_time + 2.5 * SystemManager:GetUpdateTime();

        if (bright_light_time < 5000.0) then
            Map:GetEffectSupervisor():EnableLightingOverlay(hoa_video.Color(1.0, 1.0, 1.0, bright_light_time / 5000.0));
            return false;
        end

        if (bright_light_time < 10000) then
            Map:GetEffectSupervisor():EnableLightingOverlay(hoa_video.Color(1.0, 1.0, 1.0, ((10000.0 - bright_light_time) / 5000.0)));
            return false;
        end

        -- end of the two-step fade in and out
        return true;
    end,

    Show_wooden_sword = function()
        wooden_sword:SetPosition(carson:GetXPosition() + 1.5, carson:GetYPosition() - 2.0);
        wooden_sword:SetVisible(true);
        wooden_sword:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
    end,

    Hide_wooden_sword = function()
        wooden_sword:SetVisible(false);
        wooden_sword:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
    end,

    Add_kalya_to_party = function()
        if (GlobalManager:DoesEventExist("story", "kalya_has_joined") == false) then
            GlobalManager:AddCharacter(KALYA);
            GlobalManager:SetEventValue("story", "kalya_has_joined", 1);
            GlobalManager:AddQuestLog("bring_orlinn_back");
        end
        AudioManager:FadeInAllMusic(2000);

        -- Now, the event is done, update Olivia's dialogue as access to the forest is granted
        _UpdateOliviaDialogue();
    end,

    Quest2_equip_speech_start = function()
        Map:PushState(hoa_map.MapMode.STATE_SCENE);
        bronann:SetMoving(false);
        bronann:SetDirection(hoa_map.MapMode.WEST);
        kalya:SetPosition(bronann:GetXPosition(), bronann:GetYPosition());
        kalya:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        kalya:SetDirection(hoa_map.MapMode.WEST);
        kalya:SetVisible(true);
        kalya:ClearDialogueReferences();

        -- Set the event as done to prevent it to trigger again
        GlobalManager:SetEventValue("story", "Quest2_kalya_equip_n_dungeons_speech_done", 1)
    end,

    Sprite_Collision_on = function(sprite)
        if (sprite ~= nil) then
            sprite:SetCollisionMask(hoa_map.MapMode.ALL_COLLISION);
        end
    end,

    Map_SceneState = function()
        Map:PushState(hoa_map.MapMode.STATE_SCENE);
    end,

    Map_PopState = function()
        Map:PopState();
    end,

    MakeInvisible = function(sprite)
        if (sprite ~= nil) then
            sprite:SetVisible(false);
            sprite:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        end
    end
}
