if not modules then modules = { } end modules ['lang-txt'] = {
    version   = 1.001,
    comment   = "companion to lang-lab.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files"
}

-- The content of this file is derived from the mkii lang-* files and
-- early 2011 the mkii labels are generated from this file. The
-- translations have been collected over years by users, using named
-- glyphs. This file uses utf exclusively.
--
-- Many of the initial translations were done by Tobias Burnus but
-- completed by numerous users. The following list is incomplete so feel
-- free to send me corrections.
--
-- af    Afrikaans      ...
-- ar    Arabic         Idris Samawi Hamid, Khaled Hosny
-- ca    Catalan        ...
-- cn    Chinese        Wang Lei, ...
-- cs    Czech          Tom Hudec, Petr Sojka, Richard Gabriel
-- da    Danish         Arne Jorgensen
-- de    German         Tobias Burnus, ...
-- en    English        Hans Hagen, ...
-- es    Spanish        ...
-- fi    Finish         ...
-- fr    French         Daniel Flipo, Arthur Reutenauer
-- gr    Greek          Apostolos Syropoulos, Thomas Schmitz
-- hr    Croatian       Željko Vrba, Richard Gabriel, Vedran Miletić
-- hu    Hungarian      Adam Reviczky
-- it    Italian        Giuseppe Bilotta, Luigi Scarso
-- ja    Japanese       Richard Gabriel
-- kr    Korean         Jeong Dalyoung
-- la    Latin          ...
-- lt    Lithuanian     Marius Aleknevičius
-- nb    Norwegian      Hans Fredrik Nordhaug, ...
-- nn    Norwegian      Hans Fredrik Nordhaug, ...
-- nl    Dutch          Hans Hagen
-- pl    Polish         Grzegorz Sapijaszko
-- pt    Portuguese     Pedro F. M. Mendonça
-- ro    Romanian       Dan Seracu, ...
-- ru    Russian        Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- sk    Slovak         ...
-- sl    Slovenian      Mojca Miklavec
-- sv    Swedish        ...
-- tk    Turkish        Tobias Burnus
-- tr    Turkmen        Nazar Annagurban
-- ua    Ukrainian      Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- vi    Vietnamese     Han The Thanh

-- For the moment we keep this table in memory. In the future we can then
-- enable labels.

-- thinspace == sixperemspace = 0x2006
-- print("!"..utf.char(0x2006).."!")

languages       = languages or { }
local languages = languages

languages.data  = languages.data or utilities.storage.allocate { }
local data      = languages.data

data.labels={
 functions={
  Pr={
   labels={
    en="Pr",
   },
  },
  arccos={
   labels={
    en="arccos",
    hr="arc\\sixperemspace cos",
    pl="arc\\sixperemspace cos",
   },
  },
  arcctg={
   labels={
    en="arccot",
    hr="arc\\sixperemspace ctg",
    pl="arc\\sixperemspace ctg",
   },
  },
  arcsin={
   labels={
    en="arcsin",
    hr="arc\\sixperemspace sin",
    pl="arc\\sixperemspace sin",
   },
  },
  arctan={
   labels={
    en="arctan",
    hr="arc\\sixperemspace tg",
    pl="arc\\sixperemspace tg",
   },
  },
  arctg={
   labels={
    en="arctan",
    hr="arc\\sixperemspace tg",
    pl="arc\\sixperemspace tg",
   },
  },
  arg={
   labels={
    en="arg",
   },
  },
  cos={
   labels={
    en="cos",
   },
  },
  cosh={
   labels={
    en="cosh",
   },
  },
  cot={
   labels={
    en="cot",
    hr="ctg",
    pl="ctg",
   },
  },
  coth={
   labels={
    en="coth",
   },
  },
  csc={
   labels={
    en="csc",
   },
  },
  ctg={
   labels={
    en="cot",
    hr="ctg",
    pl="ctg",
   },
  },
  deg={
   labels={
    en="deg",
   },
  },
  det={
   labels={
    en="det",
   },
  },
  dim={
   labels={
    en="dim",
   },
  },
  exp={
   labels={
    en="exp",
   },
  },
  gcd={
   labels={
    en="gcd",
    hr="nzd",
    nl="ggd",
   },
  },
  hom={
   labels={
    en="hom",
   },
  },
  inf={
   labels={
    en="inf",
   },
  },
  injlim={
   labels={
    en="inj\\sixperemspace lim",
   },
  },
  ker={
   labels={
    en="ker",
   },
  },
  lcm={
   labels={
    en="lcm",
    hr="nzv",
    nl="kgv",
   },
  },
  lg={
   labels={
    en="lg",
   },
  },
  lim={
   labels={
    en="lim",
   },
  },
  liminf={
   labels={
    en="lim\\sixperemspace inf",
   },
  },
  limsup={
   labels={
    en="lim\\sixperemspace sup",
   },
  },
  ln={
   labels={
    en="ln",
   },
  },
  log={
   labels={
    en="log",
   },
  },
  max={
   labels={
    en="max",
   },
  },
  median={
   labels={
    en="median",
   },
  },
  min={
   labels={
    en="min",
   },
  },
  mod={
   labels={
    en="mod",
   },
  },
  projlim={
   labels={
    en="proj\\sixperemspace lim",
   },
  },
  sec={
   labels={
    en="sec",
   },
  },
  sin={
   labels={
    en="sin",
   },
  },
  sinh={
   labels={
    en="sinh",
   },
  },
  sup={
   labels={
    en="sup",
   },
  },
  tan={
   labels={
    en="tan",
    hr="tg",
    pl="tg",
   },
  },
  tanh={
   labels={
    en="tanh",
   },
  },
  tg={
   labels={
    en="tan",
    hr="tg",
    pl="tg",
   },
  },
 },
 texts={
  ["and"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="und",
    en="and",
    es="",
    fi="",
    fr="",
    gr="",
    hr="i",
    hu="és",
    it="",
    la="",
    lt="",
    nb="",
    nl="en",
    nn="",
    pl="i",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  appendix={
   hidden=true,
   labels={
    af="Bylae ",
    ar="ملحق ",
    ca="Apèndix ",
    cn="附录",
    cs="Příloha ",
    da="Bilag ",
    de="Anhang ",
    en="Appendix ",
    es="Apéndice ",
    fi="",
    fr="Annexe ",
    gr="Παράρτημα",
    hr="Dodatak ",
    hu="Melléklet ",
    it="",
    ja="付録",
    kr="부록",
    la="",
    lt="",
    nb="Tillegg ",
    nl="",
    nn="Tillegg ",
    pl="Dodatek ",
    pt="",
    ro="",
    ru="",
    sk="Príloha ",
    sl="Dodatek ",
    sv="",
    tk="Goşmaça",
    tr="",
    ua="",
    vi="",
   },
  },
  april={
   labels={
    af="april",
    ar="أبريل",
    ["ar-dz"]="أفريل",
    ["ar-sy"]="نيسان",
    ca="abril",
    cn="四月",
    cs="dubna",
    da="april",
    de="April",
    en="April",
    es="abril",
    fi="huhtikuu",
    fr="avril",
    gr="Απρίλιος",
    hr="travnja",
    hu="április",
    it="aprile",
    ja="4",
    kr="4월",
    la="Aprilis",
    lt="balandžio",
    nb="april",
    nl="april",
    nn="april",
    pl="kwietnia",
    pt="abril",
    ro="aprilie",
    ru="апреля",
    sk="apríla",
    sl="april",
    sv="april",
    tk="aprel",
    tr="nisan",
    ua="квітня",
    vi="tháng tư",
   },
  },
  ["april:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="apr",
    es="",
    fi="",
    fr="",
    gr="",
    hr="tra",
    hu="ápr.",
    it="",
    la="",
    lt="apr",
    nb="april",
    nl="",
    nn="april",
    pl="kwi.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  atpage={
   labels={
    af="",
    ar="في صفحة ",
    ca="",
    cs="na straně ",
    da="på side ",
    de="auf Seite ",
    en="at page ",
    es="",
    fi="",
    fr="à la page ",
    gr="",
    hr="na stranici ",
    hu="oldal ",
    it="a pagina ",
    la="",
    lt="puslapyje ",
    nb="på side ",
    nl="op pagina ",
    nn="på side ",
    pl="na stronie ",
    pt="",
    ro="",
    ru="на странице ",
    sk="",
    sl="na strani ",
    sv="på sida ",
    tk="",
    tr="",
    ua="на сторінці ",
    vi="",
   },
  },
  august={
   labels={
    af="augustus",
    ar="أغسطس",
    ["ar-dz"]="أوت",
    ["ar-ma"]="غشت",
    ["ar-sy"]="آب",
    ca="agost",
    cn="八月",
    cs="srpna",
    da="august",
    de="August",
    en="August",
    es="agosto",
    fi="elokuu",
    fr="août",
    gr="Αύγουστος",
    hr="kolovoza",
    hu="augusztus",
    it="agosto",
    ja="8",
    kr="8월",
    la="Augustus",
    lt="rugpjūčio",
    nb="august",
    nl="augustus",
    nn="august",
    pl="sierpnia",
    pt="agosto",
    ro="august",
    ru="августа",
    sk="augusta",
    sl="avgust",
    sv="augusti",
    tk="awgust",
    tr="ağustos",
    ua="серпня",
    vi="tháng tám",
   },
  },
  ["august:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="aug",
    es="",
    fi="",
    fr="",
    gr="",
    hr="kol",
    hu="aug.",
    it="",
    la="",
    lt="aug",
    nb="aug.",
    nl="",
    nn="aug.",
    pl="sier.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  chapter={
   hidden=true,
   labels={
    af="Hoofstuk ",
    ar="باب ",
    ca="Capítol ",
    cn={"第","章"},
    cs="Kapitola ",
    da="",
    de="Kapitel ",
    en="Chapter ",
    es="Capítulo ",
    fi="",
    fr="Chapitre ",
    gr="Κεφάλαιο",
    hr="Poglavlje ",
    hu=",. fejezet:",
    it="",
    ja={"第","章"},
    kr={"제","장"},
    la="",
    lt="",
    nb="",
    nl="",
    nn="",
    pl="Rozdział ",
    pt="",
    ro="",
    ru="",
    sk="Kapitola ",
    sl="Poglavje ",
    sv="",
    tk="Bap",
    tr="",
    ua="",
    vi="Chương ",
   },
  },
  continued={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en=" (continued)",
    es="",
    fi="",
    fr="",
    gr="",
    hr=" (nastavak)",
    hu=" (folytatás)",
    it="",
    la="",
    lt="",
    nb="",
    nl=" (vervolgd)",
    nn="",
    pl="",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  december={
   labels={
    af="desember",
    ar="ديسمبر",
    ["ar-ma"]="دجنبر",
    ["ar-sy"]="كانون الأول",
    ca="desembre",
    cn="十二月",
    cs="prosince",
    da="december",
    de="Dezember",
    en="December",
    es="diciembre",
    fi="joulukuu",
    fr="décembre",
    gr="Δεκέμβριος",
    hr="prosinca",
    hu="december",
    it="dicembre",
    ja="12",
    kr="12월",
    la="December",
    lt="gruodžio",
    nb="desember",
    nl="december",
    nn="desember",
    pl="grudnia",
    pt="dezembro",
    ro="decembrie",
    ru="декабря",
    sk="decembra",
    sl="december",
    sv="december",
    tk="dekabr",
    tr="aralık",
    ua="грудня",
    vi="tháng mười hai",
   },
  },
  ["december:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="dec",
    es="",
    fi="",
    fr="",
    gr="",
    hr="pro",
    hu="dec.",
    it="",
    la="",
    lt="dec",
    nb="des.",
    nl="",
    nn="des.",
    pl="gru.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  february={
   labels={
    af="februarie",
    ar="فبراير",
    ["ar-dz"]="فيفري",
    ["ar-sy"]="شباط",
    ca="febrer",
    cn="二月",
    cs="února",
    da="februar",
    de="Februar",
    en="February",
    es="febrero",
    fi="helmikuu",
    fr="février",
    gr="Φεβρουάριος",
    hr="veljače",
    hu="február",
    it="febbraio",
    ja="2",
    kr="2월",
    la="Februarius",
    lt="vasario",
    nb="februar",
    nl="februari",
    nn="februar",
    pl="lutego",
    pt="fevereiro",
    ro="februarie",
    ru="февраля",
    sk="februára",
    sl="februar",
    sv="februari",
    tk="fewral",
    tr="Şubat",
    ua="лютого",
    vi="tháng hai",
   },
  },
  ["february:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="feb",
    es="",
    fi="",
    fr="",
    gr="",
    hr="velj",
    hu="feb.",
    it="",
    la="",
    lt="feb",
    nb="feb.",
    nl="",
    nn="feb.",
    pl="lut.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  figure={
   labels={
    af="Figuur ",
    ar="شكل ",
    ca="Figura ",
    cn="图",
    cs="Obrázek ",
    da="Figur ",
    de="Abbildung ",
    en="Figure ",
    es="Ilustración ",
    fi="Kuva ",
    fr="Figure ",
    gr="Σχήμα",
    hr="Slika ",
    hu=",. ábra:",
    it="Fig. ",
    ja="図",
    kr="그림",
    la="Imago ",
    lt=", pav.",
    nb="Figur ",
    nl="Figuur ",
    nn="Figur ",
    pl="Ilustracja ",
    pt="Figura ",
    ro="Figura ",
    ru="Рисунок ",
    sk="Obrázok ",
    sl="Slika ",
    sv="Figur ",
    tk="Surat",
    tr="Şekil ",
    ua="Малюнок ",
    vi="Hình ",
   },
  },
  friday={
   labels={
    af="vrydag",
    ar="الجمعة",
    ca="divendres",
    cn="星期五",
    cs="pátek",
    da="fredag",
    de="Freitag",
    en="Friday",
    es="viernes",
    fi="perjantai",
    fr="vendredi",
    gr="Παρασκευή",
    hr="petak",
    hu="péntek",
    it="venerdì",
    ja="金曜日",
    kr="금요일",
    la="Dies Veneris",
    lt="penktadienis",
    nb="fredag",
    nl="vrijdag",
    nn="fredag",
    pl="piątek",
    pt="sexta-feira",
    ro="vineri",
    ru="пятница",
    sk="",
    sl="petek",
    sv="fredag",
    tk="bäşinji gün",
    tr="cuma",
    ua="п'ятниця",
    vi="thứ sáu",
   },
  },
  graphic={
   labels={
    af="Grafiek ",
    ar="رسم ",
    ca="Gràfica ",
    cn="插图",
    cs="Graf ",
    da="Grafik ",
    de="Graphik ",
    en="Graphic ",
    es="Gráfico ",
    fi="Grafiikka ",
    fr="Illustration ",
    gr="Γραφικό",
    hr="Slika ",
    hu=",. kép:",
    it="Grafico ",
    ja="イラスト",
    la="Typus ",
    lt="Graphic ",
    nb="Bilde ",
    nl="Grafiek ",
    nn="Bilete ",
    pl="Grafika ",
    pt="Gráfico ",
    ro="Graficul ",
    ru="График ",
    sk="Graf ",
    sl="Slika ",
    sv="Grafik ",
    tk="Grafik",
    tr="Grafik",
    ua="График ",
    vi="Đồ thị",
   },
  },
  hencefore={
   labels={
    af="",
    ar="كما وضحنا سابقا",
    ca="",
    cs="viz výše",
    da="se foroven",
    de="siehe oben",
    en="as we show above",
    es="",
    fi="",
    fr="ci-dessus",
    gr="",
    hr="vidi gore",
    hu="lásd feljebb",
    kr="그러므로",
    it="come mostrato sopra",
    la="",
    lt="kaip parodyta aukščiau",
    nb="som vist over",
    nl="hierboven",
    nn="som vist over",
    pl="jak pokazano wyżej",
    pt="",
    ro="",
    ru="см. выше",
    sk="",
    sl="glej zgoraj",
    sv="se ovan",
    tk="",
    tr="",
    ua="як показано вище",
    vi="",
   },
  },
  hereafter={
   labels={
    af="",
    ar="كما نوضح لاحقا",
    ca="",
    cs="viz níže",
    da="se forneden",
    de="siehe unten",
    en="as we show below",
    es="",
    fi="",
    fr="ci-dessous",
    gr="",
    hr="vidi ispod",
    hu="lásd lejjebb",
    it="come mostrato sotto",
    la="",
    lt="kaip parodyta žemiau",
    nb="som vist under",
    nl="hieronder",
    nn="som vist under",
    pl="jak pokazano niżej",
    pt="",
    ro="",
    ru="см. ниже",
    sk="",
    sl="glej spodaj",
    sv="se nedan",
    tk="",
    tr="",
    ua="як показано нижче",
    vi="",
   },
  },
  intermezzo={
   labels={
    af="Intermezzo ",
    ar="فسحة ",
    ca="Intermedi ",
    cn="퉣",
    cs="Intermezzo ",
    da="Intermezzo ",
    de="Intermezzo ",
    en="Intermezzo ",
    es="Intermedio ",
    fi="Intermezzo ",
    fr="Intermède ",
    gr="Παύση",
    hr="Intermeco ",
    hu=",. intermezzo:",
    it="Intermezzo ",
    ja="間奏曲",
    kr="간주곡",
    la="Intermissum ",
    lt="Intermezzo ",
    nb="Intermesso ",
    nl="Intermezzo ",
    nn="Intermesso ",
    pl="Intermezzo ",
    pt="Intermédio ",
    ro="Intermezzo ",
    ru="Вставка ",
    sk="Intermezzo ",
    sl="Intermezzo ",
    sv="Intermezzo ",
    tk="Arakesme",
    tr="",
    ua="Вставка ",
    vi="intermezzo",
   },
  },
  january={
   labels={
    af="januarie",
    ar="يناير",
    ["ar-dz"]="جانفي",
    ["ar-sy"]="كانون الثاني",
    ca="gener",
    cn="一月",
    cs="ledna",
    da="januar",
    de="Januar",
    en="January",
    es="enero",
    fi="tammikuu",
    fr="janvier",
    gr="Ιανουάριος",
    hr="siječnja",
    hu="január",
    it="gennaio",
    ja="1",
    kr="1월",
    la="Ianuarius",
    lt="sausio",
    nb="januar",
    nl="januari",
    nn="januar",
    pl="stycznia",
    pt="janeiro",
    ro="ianuarie",
    ru="января",
    sk="januára",
    sl="januar",
    sv="januari",
    tk="ýanwar",
    tr="ocak",
    ua="січня",
    vi="tháng giêng",
   },
  },
  ["january:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="jan",
    es="",
    fi="",
    fr="",
    gr="",
    hr="sij",
    hu="jan.",
    it="",
    la="",
    lt="jan",
    nb="jan.",
    nl="",
    nn="jan.",
    pl="sty.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  july={
   labels={
    af="julie",
    ar="يوليو",
    ["ar-dz"]="جويلة",
    ["ar-ma"]="يوليوز",
    ["ar-sy"]="تموز",
    ca="juliol",
    cn="七月",
    cs="července",
    da="juli",
    de="Juli",
    en="July",
    es="julio",
    fi="heinäkuu",
    fr="juillet",
    gr="Ιούλιος",
    hr="srpnja",
    hu="július",
    it="luglio",
    ja="7",
    kr="7월",
    la="Iulius",
    lt="liepos",
    nb="juli",
    nl="juli",
    nn="juli",
    pl="lipca",
    pt="julho",
    ro="iulie",
    ru="июля",
    sk="júla",
    sl="julij",
    sv="juli",
    tk="iýul",
    tr="temmuz",
    ua="липня",
    vi="tháng bảy",
   },
  },
  ["july:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="jul",
    es="",
    fi="",
    fr="",
    gr="",
    hr="srp",
    hu="júl.",
    it="",
    la="",
    lt="jul",
    nb="juli",
    nl="",
    nn="juli",
    pl="lip.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  june={
   labels={
    af="junie",
    ar="يونيو",
    ["ar-dz"]="جوان",
    ["ar-sy"]="حزيران",
    ca="juny",
    cn="六月",
    cs="června",
    da="juni",
    de="Juni",
    en="June",
    es="junio",
    fi="kesäkuu",
    fr="juin",
    gr="Ιούνιος",
    hr="lipnja",
    hu="június",
    it="giugno",
    ja="6",
    kr="6월",
    la="Iunius",
    lt="birželio",
    nb="juni",
    nl="juni",
    nn="juni",
    pl="czerwca",
    pt="junho",
    ro="iunie",
    ru="июня",
    sk="júna",
    sl="junij",
    sv="juni",
    tk="iýun",
    tr="haziran",
    ua="червня",
    vi="tháng sáu",
   },
  },
  ["june:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="jun",
    es="",
    fi="",
    fr="",
    gr="",
    hr="lip",
    hu="jún.",
    it="",
    la="",
    lt="jun",
    nb="juni",
    nl="",
    nn="juni",
    pl="czerw.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  line={
   labels={
    af="reël ",
    ar="سطر ",
    ca="línia ",
    cn="行",
    cs="řádek ",
    da="linie ",
    de="Zeile ",
    en="line ",
    es="línea ",
    fi="rivi ",
    fr="ligne ",
    gr="Γραμμή",
    hr="redak ",
    hu=",. sor:",
    it="riga ",
    ja="線",
    kr="행",
    la="versus ",
    lt="line ",
    nb="linje ",
    nl="regel ",
    nn="linje ",
    pl="wiersz ",
    pt="linha ",
    ro="linia ",
    ru="строка ",
    sk="riadok ",
    sl="vrstica ",
    sv="rad ",
    tk="setir",
    tr="satır ",
    ua="рядок ",
    vi="dòng ",
   },
  },
  lines={
   labels={
    af="reëls ",
    ar="السطور ",
    ca="línies ",
    cn="行",
    cs="řádky ",
    da="linier ",
    de="Zeilen ",
    en="lines ",
    es="líneas ",
    fi="rivie ",
    fr="lignes ",
    gr="Γραμμές",
    hr="retci ",
    hu="sorok ",
    it="righe ",
    ja="線",
    kr="행",
    la="versus ",
    lt="lines ",
    nb="linjer ",
    nl="regels ",
    nn="linjer ",
    pl="wiersze ",
    pt="linhas ",
    ro="liniile ",
    ru="строки ",
    sk="riadky ",
    sl="vrstice ",
    sv="rader ",
    tk="setirler",
    tr="satırlar ",
    ua="рядки ",
    vi="dòng ",
   },
  },
  march={
   labels={
    af="maart",
    ar="مارس",
    ["ar-sy"]="آذار",
    ca="març",
    cn="三月",
    cs="března",
    da="marts",
    de="März",
    en="March",
    es="marzo",
    fi="maaliskuu",
    fr="mars",
    gr="Μάρτιος",
    hr="ožujka",
    hu="március",
    it="marzo",
    ja="3",
    kr="3월",
    la="Martius",
    lt="kovo",
    nb="mars",
    nl="maart",
    nn="mars",
    pl="marca",
    pt="março",
    ro="martie",
    ru="марта",
    sk="marca",
    sl="marec",
    sv="mars",
    tk="mart",
    tr="mart",
    ua="березня",
    vi="tháng ba",
   },
  },
  ["march:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="mar",
    es="",
    fi="",
    fr="",
    gr="",
    hr="ožu",
    hu="már.",
    it="",
    la="",
    lt="mar",
    nb="mars",
    nl="",
    nn="mars",
    pl="mar.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  may={
   labels={
    af="mei",
    ar="مايو",
    ["ar-dz"]="ماي",
    ["ar-ma"]="ماي",
    ["ar-sy"]="أيار",
    ca="maig",
    cn="五月",
    cs="května",
    da="maj",
    de="Mai",
    en="May",
    es="mayo",
    fi="toukokuu",
    fr="mai",
    gr="Μάιος",
    hr="svibnja",
    hu="május",
    it="maggio",
    ja="5",
    kr="5월",
    la="Maius",
    lt="gegužės",
    nb="mai",
    nl="mei",
    nn="mai",
    pl="maja",
    pt="maio",
    ro="mai",
    ru="мая",
    sk="mája",
    sl="maj",
    sv="maj",
    tk="maý",
    tr="mayıs",
    ua="травня",
    vi="tháng năm",
   },
  },
  ["may:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="may",
    es="",
    fi="",
    fr="",
    gr="",
    hr="svi",
    hu="máj.",
    it="",
    la="",
    lt="may",
    nb="mai",
    nl="",
    nn="mai",
    pl="maja",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  monday={
   labels={
    af="maandag",
    ar="الاثنين",
    ca="dilluns",
    cn="星期一",
    cs="pondělí",
    da="mandag",
    de="Montag",
    en="Monday",
    es="lunes",
    fi="maanantai",
    fr="lundi",
    gr="Δευτέρα",
    hr="ponedjeljak",
    hu="hétfő",
    it="lunedì",
    ja="月曜日",
    kr="월요일",
    la="Dies Lunae",
    lt="pirmadienis",
    nb="mandag",
    nl="maandag",
    nn="måndag",
    pl="poniedziałek",
    pt="segunda-feira",
    ro="luni",
    ru="понедельник",
    sk="",
    sl="ponedeljek",
    sv="måndag",
    tk="birinji gün",
    tr="pazartesi",
    ua="понеділок",
    vi="thứ hai",
   },
  },
  november={
   labels={
    af="november",
    ar="نوفمبر",
    ["ar-ma"]="نونبر",
    ["ar-sy"]="تشرين الثاني",
    ca="novembre",
    cn="十一月",
    cs="listopadu",
    da="november",
    de="November",
    en="November",
    es="noviembre",
    fi="marraskuu",
    fr="novembre",
    gr="Νοέμβριος",
    hr="studenog",
    hu="november",
    it="novembre",
    ja="11",
    kr="11월",
    la="November",
    lt="lapkričio",
    nb="november",
    nl="november",
    nn="november",
    pl="listopada",
    pt="novembro",
    ro="noiembrie",
    ru="ноября",
    sk="novembra",
    sl="november",
    sv="november",
    tk="noýabr",
    tr="kasım",
    ua="листопада",
    vi="tháng mười một",
   },
  },
  ["november:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="nov",
    es="",
    fi="",
    fr="",
    gr="",
    hr="stu",
    hu="nov.",
    it="",
    la="",
    lt="nov",
    nb="nov.",
    nl="",
    nn="nov.",
    pl="lis.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  october={
   labels={
    af="oktober",
    ar="أكتوبر",
    ["ar-sy"]="تشرين الأول",
    ca="octubre",
    cn="十月",
    cs="října",
    da="oktober",
    de="Oktober",
    en="October",
    es="octubre",
    fi="lokakuu",
    fr="octobre",
    gr="Οκτώβριος",
    hr="listopada",
    hu="október",
    it="ottobre",
    ja="10",
    kr="10월",
    la="October",
    lt="spalio",
    nb="oktober",
    nl="oktober",
    nn="oktober",
    pl="października",
    pt="outubro",
    ro="octombrie",
    ru="октября",
    sk="októbra",
    sl="oktober",
    sv="oktober",
    tk="oktýabr",
    tr="ekim",
    ua="жовтня",
    vi="tháng mười",
   },
  },
  ["october:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="oct",
    es="",
    fi="",
    fr="",
    gr="",
    hr="lis",
    hu="okt.",
    it="",
    la="",
    lt="oct",
    nb="okt.",
    nl="",
    nn="okt.",
    pl="paź.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  page={
   labels={
    af="",
    ar="صفحة ",
    ca="",
    cs="strana ",
    da="Side ",
    de="Seite ",
    en="page ",
    es="",
    fi="",
    fr="page ",
    gr="",
    hr="stranica ",
    hu="oldal ",
    it="pagina ",
    kr="쪽",
    la="",
    lt="puslapis ",
    nb="side ",
    nl="pagina ",
    nn="side ",
    pl="strona ",
    pt="",
    ro="",
    ru="страница ",
    sk="",
    sl="stran ",
    sv="Sida ",
    tk="",
    tr="",
    ua="сторінка ",
    vi="",
   },
  },
  part={
   labels={
    af="Deel ",
    ar="جزء ",
    ca="Part ",
    cn={"第","部分"},
    cs="Část ",
    da="Del ",
    de="Teil ",
    en="Part ",
    es="Parte ",
    fi="Osa ",
    fr="Partie ",
    gr="Μέρος",
    hr="Dio ",
    hu=",. rész:",
    it="Parte ",
    ja={"第","パート"},
    kr={"제","부"},
    la="Pars ",
    lt=", dalis",
    nb="Del",
    nl="Deel ",
    nn="Del",
    pl="Część ",	
    pt="Parte ",
    ro="Partea ",
    ru="Часть ",
    sk="Časť ",
    sl="Del ",
    sv="Del ",
    tk="Bölüm",
    tr="Cilt ",
    ua="Частина ",
    vi="Phần ",
   },
  },
  saturday={
   labels={
    af="saterdag",
    ar="السبت",
    ca="dissabte",
    cn="星期六",
    cs="sobota",
    da="lørdag",
    de="Samstag",
    en="Saturday",
    es="sábado",
    fi="lauantai",
    fr="samedi",
    gr="Σάββατο",
    hr="subota",
    hu="szombat",
    it="sabato",
    ja="土曜日",
    kr="토요일",
    la="Dies Saturni",
    lt="šeštadienis",
    nb="lørdag",
    nl="zaterdag",
    nn="laurdag",
    pl="sobota",
    pt="sábado",
    ro="sâmbătă",
    ru="суббота",
    sk="",
    sl="sobota",
    sv="lördag",
    tk="altynjy gün",
    tr="cumartesi",
    ua="субота",
    vi="thứ bảy",
   },
  },
  section={
   hidden=true,
   labels={
    af="Paragraaf ",
    ar="فصل ",
    ca="Secció ",
    cn={"第","节"},
    cs="Sekce ",
    da="",
    de="",
    en="",
    es="Sección ",
    fi="",
    fr="Section ",
    gr="Ενότητα",
    hr="Odjeljak ",
    hu="Fejezet ",
    it="",
    ja={"第","項"},
    kr={"제","절"},
    la="",
    lt="",
    nb="",
    nl="",
    nn="",
    pl="Podrozdział ",
    pt="",
    ro="",
    ru="",
    sk="Sekcia ",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  see={
   labels={
    af="",
    ar="انظر ",
    ca="",
    cs="viz ",
    da="se ",
    de="siehe ",
    en="see ",
    es="",
    fi="",
    fr="cf. ",
    gr="",
    hr="vidi ",
    hu="lásd ",
    it="cf. ",
    kr="",
    la="",
    lt="žiūrėti ",
    nb="se ",
    nl="zie ",
    nn="sjå ",
    pl="patrz ",
    pt="",
    ro="",
    ru="см. ",
    sk="",
    sl="glej ",
    sv="se ",
    tk="",
    tr="",
    ua="див. ",
    vi="",
   },
  },
  september={
   labels={
    af="september",
    ar="سبتمبر",
    ["ar-ma"]="شتنبر",
    ["ar-sy"]="أيلول",
    ca="setembre",
    cn="九月",
    cs="září",
    da="september",
    de="September",
    en="September",
    es="septiembre",
    fi="syyskuu",
    fr="septembre",
    gr="Σεπτέμβριος",
    hr="rujna",
    hu="szeptember",
    it="settembre",
    ja="9",
    kr="9월",
    la="September",
    lt="rugsėjo",
    nb="september",
    nl="september",
    nn="september",
    pl="września",
    pt="setembro",
    ro="septembrie",
    ru="сентября",
    sk="septembra",
    sl="september",
    sv="september",
    tk="sentýabr",
    tr="eylül",
    ua="вересня",
    vi="tháng chín",
   },
  },
  ["september:mnem"]={
   labels={
    af="",
    ca="",
    cs="",
    da="",
    de="",
    en="sep",
    es="",
    fi="",
    fr="",
    gr="",
    hr="ruj",
    hu="szep.",
    it="",
    la="",
    lt="sep",
    nb="sep.",
    nl="",
    nn="sep.",
    pl="wrz.",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  subsection={
   hidden=true,
   labels={
    af="",
    ar="فصل أدنى ",
    ca="Subsecció ",
    cn="",
    cs="Podsekce ",
    da="",
    de="",
    en="",
    es="Subsección ",
    fi="",
    fr="Soussection ",
    gr="Υπόενότητα",
    hr="Pododjeljak ",
    hu="Alfejezet ",
    it="",
    ja="",
    la="",
    lt="",
    nb="",
    nl="",
    nn="",
    pl="Podpodrozdział ",
    pt="",
    ro="",
    ru="",
    sk="Podsekcia ",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  subsubsection={
   hidden=true,
   labels={
    af="",
    ar="فصل أ دنى أدنى ",
    ca="Subsubsecció ",
    cn="",
    cs="Podpodsekce ",
    da="",
    de="",
    en="",
    es="Subsubsección ",
    fi="",
    fr="Soussoussection ",
    gr="",
    hr="Podpododjeljak ",
    hu="Al-alfejezet ",
    it="",
    ja="",
    la="",
    lt="",
    nb="",
    nl="",
    nn="",
    pl="",
    pt="",
    ro="",
    ru="",
    sk="Podpodsekcia ",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  subsubsubsection={
   hidden=true,
   labels={
    af="",
    ar="فصل أدنى أدنى أدنى ",
    ca="Subsubsubsecció ",
    cn="",
    cs="Podpodpodsekce ",
    da="",
    de="",
    en="",
    es="Subsubsubsección ",
    fi="",
    fr="Soussoussoussection ",
    gr="",
    hr="Podpodpododjeljak ",
    hu="Al-al-alfejezet ",
    it="",
    ja="",
    la="",
    lt="",
    nb="",
    nl="",
    nn="",
    pl="", -- not used in Polish
    pt="",
    ro="",
    ru="",
    sk="Podpodpodsekcia ",
    sl="",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  sunday={
   labels={
    af="sondag",
    ar="الأحد",
    ca="diumenge",
    cn="星期日",
    cs="neděle",
    da="søndag",
    de="Sonntag",
    en="Sunday",
    es="domingo",
    fi="sunnuntai",
    fr="dimanche",
    gr="Κυριακή",
    hr="nedjelja",
    hu="vasárnap",
    it="domenica",
    ja="日曜日",
    kr="일요일",
    la="Dies Solis",
    lt="sekmadienis",
    nb="søndag",
    nl="zondag",
    nn="sundag",
    pl="niedziela",
    pt="domingo",
    ro="duminică",
    ru="воскресенье",
    sk="",
    sl="nedelja",
    sv="söndag",
    tk="dynç gün",
    tr="pazar",
    ua="неділя",
    vi="chủ nhật",
   },
  },
  table={
   labels={
    af="Tabel",
    ar="جدول ",
    ca="Taula ",
    cn="表",
    cs="Tabulka ",
    da="Tabel ",
    de="Tabelle ",
    en="Table ",
    es="Tabla ",
    fi="Taulukko ",
    fr="Tableau ",
    gr="Πίνακας",
    hr="Tablica ",
    hu=",. táblázat:",
    it="Tabella ",
    ja="表",
    kr="표",
    la="Tabula ",
    lt=", lentelė.",
    nb="Tabell ",
    nl="Tabel ",
    nn="Tabell ",
    pl="Tabela ",
    pt="Tabela ",
    ro="Tabelul ",
    ru="Таблица ",
    sk="Tabuľka ",
    sl="Tabela ",
    sv="Tabell ",
    tk="Tablisa",
    tr="Tablo ",
    ua="Таблиця ",
    vi="Bảng ",
   },
  },
  thursday={
   labels={
    af="donderdag",
    ar="الخميس",
    ca="dijous",
    cn="星期四",
    cs="čtvrtek",
    da="torsdag",
    de="Donnerstag",
    en="Thursday",
    es="jueves",
    fi="torstai",
    fr="jeudi",
    gr="Πέμπτη",
    hr="četvrtak",
    hu="csütörtök",
    it="giovedì",
    ja="木曜日",
    kr="목요일",
    la="Dies Iovis",
    lt="ketvirtadienis",
    nb="torsdag",
    nl="donderdag",
    nn="torsdag",
    pl="czwartek",
    pt="quinta-feira",
    ro="joi",
    ru="четверг",
    sk="",
    sl="četrtek",
    sv="torsdag",
    tk="dördünji gün",
    tr="perşembe",
    ua="четвер",
    vi="thứ năm",
   },
  },
  tuesday={
   labels={
    af="dinsdag",
    ar="الثلاثاء",
    ca="dimarts",
    cn="星期二",
    cs="úterý",
    da="tirsdag",
    de="Dienstag",
    en="Tuesday",
    es="martes",
    fi="tiistai",
    fr="mardi",
    gr="Τρίτη",
    hr="utorak",
    hu="kedd",
    it="martedì",
    ja="火曜日",
    kr="화요일",
    la="Dies Martis",
    lt="antradienis",
    nb="tirsdag",
    nl="dinsdag",
    nn="tysdag",
    pl="wtorek",
    pt="terça-feira",
    ro="marți",
    ru="вторник",
    sk="",
    sl="torek",
    sv="tisdag",
    tk="ikinji gün",
    tr="salı",
    ua="вівторок",
    vi="thứ ba",
   },
  },
  wednesday={
   labels={
    af="woensdag",
    ar="الأربعاء",
    ca="dimecres",
    cn="星期三",
    cs="středa",
    da="onsdag",
    de="Mittwoch",
    en="Wednesday",
    es="miércoles",
    fi="keskiviikko",
    fr="mercredi",
    gr="Τετάρτη",
    hr="srijeda",
    hu="szerda",
    it="mercoledì",
    ja="水曜日",
    kr="수요일",
    la="Dies Mercuri",
    lt="trečiadienis",
    nb="onsdag",
    nl="woensdag",
    nn="onsdag",
    pl="środa",
    pt="quarta-feira",
    ro="miercuri",
    ru="среда",
    sk="",
    sl="sreda",
    sv="onsdag",
    tk="üçünji",
    tr="çarşamba",
    ua="середа",
    vi="thứ tư",
   },
  },
 },
 titles={
  abbreviations={
   labels={
    af="Afkortings",
    ar="الاختصارات",
    ca="Abreviacions",
    cn="缩略语",
    cs="Zkratky",
    da="Forkortelser",
    de="Abkürzungen",
    en="Abbreviations",
    es="Abreviaturas",
    fi="Lyhennyksi",
    fr="Abréviations",
    gr="Συντομογραφίες",
    hr="Kratice",
    hu="Rövidítések",
    it="Abbreviazioni",
    ja="略語",
    kr="약어",
    la="Notae",
    lt="Santrumpos",
    nb="Forkortelser",
    nl="Afkortingen",
    nn="Forkortingar",
    pl="Wykaz skrótów",
    pt="Abreviaturas",
    ro="Abrevieri",
    ru="Список сокращений",
    sk="Skratky",
    sl="Kratice",
    sv="Förkortningar",
    tk="Gysgaltmalar",
    tr="Kısaltmalar",
    ua="Перелік скорочень",
    vi="Chữ viết tắt",
   },
  },
  content={
   labels={
    af="Inhoud",
    ar="المحتويات",
    ca="Índex de continguts",
    cn="目录",
    cs="Obsah",
    da="Indhold",
    de="Inhalt",
    en="Contents",
    es="Índice",
    fi="Sisällys",
    fr="Table des matières",
    gr="Περιεχόμενα",
    hr="Sadržaj",
    hu="Tartalom",
    it="Indice",
    ja="目次",
    kr="목차",
    la="Quod in libro continetur",
    lt="Turinys",
    nb="Innhold",
    nl="Inhoud",
    nn="Innhald",
    pl="Spis treści",
    pt="Conteúdo",
    ro="Cuprins",
    ru="Содержание",
    sk="Obsah",
    sl="Kazalo",
    sv="Innehåll",
    tk="Mazmuny",
    tr="Fihrist",
    ua="Зміст",
    vi="Mục lục",
   },
  },
  figures={
   labels={
    af="Figure",
    ar="الأشكال",
    ca="Figures",
    cn="图形",
    cs="Obrázky",
    da="Figurer",
    de="Abbildungen",
    en="Figures",
    es="Ilustraciones",
    fi="Kuvi",
    fr="Figures",
    gr="Σχήματα",
    hr="Slike",
    hu="Ábrák",
    it="Figure",
    ja="図",
    kr="그림",
    la="Imagines",
    lt="Iliustracijos",
    nb="Figurer",
    nl="Figuren",
    nn="Figurar",
    pl="Ilustracje",
    pt="Figuras",
    ro="Figuri",
    ru="Список иллюстраций",
    sk="Obrázkov",
    sl="Slike",
    sv="Figurer",
    tk="Suratlar",
    tr="Şekiller",
    ua="Перелік ілюстрацій",
    vi="Danh sách hình vẽ",
   },
  },
  graphics={
   labels={
    af="Grafieke",
    ar="الرسوم",
    ca="Gràfiques",
    cn="图",
    cs="Grafy",
    da="Grafik",
    de="Graphiken",
    en="Graphics",
    es="Gráficos",
    fi="Grafiikkaoi",
    fr="Graphiques",
    gr="Γραφικά",
    hr="Slike",
    hu="Grafikák",
    it="Grafici",
    ja="グラフ",
    kr="그래픽",
    la="Typi",
    lt="Graphics",
    nb="Bilde",
    nl="Grafieken",
    nn="Bilete",
    pl="Grafiki",
    pt="Gráficos",
    ro="Grafice",
    ru="Список графиков",
    sk="Graf",
    sl="Slike",
    sv="Grafik",
    tk="Grafikler",
    tr="Grafikler",
    ua="Перелік графіков",
    vi="Đồ thị",
   },
  },
  index={
   labels={
    af="Indeks",
    ar="الفهرس",
    ca="Índex alfabètic",
    cn="索引",
    cs="Rejstřík",
    da="Indeks",
    de="Index",
    en="Index",
    es="Índice alfabético",
    fi="Indeksiluku",
    fr="Index",
    gr="Ευρετήριο",
    hr="Indeks",
    hu="Index",
    it="Indice",
    ja="目次",
    kr="색인",
    la="Indices",
    lt="Rodyklė",
    nb="Register",
    nl="Index",
    nn="Register",
    pl="Indeks",
    pt="Índice",
    ro="Index",
    ru="Алфавитный указатель",
    sk="Zoznam",
    sl="Stvarno kazalo",
    sv="Sakregister",
    tk="Indeks",
    tr="İndex",
    ua="Покажчик",
    vi="Chỉ số",
   },
  },
  intermezzi={
   labels={
    af="Intermezzos",
    ar="فسح",
    ca="Intermedis",
    cn="퉣",
    cs="Intermezza",
    da="Intermezzoer",
    de="Intermezzi",
    en="Intermezzos",
    es="Intermedios",
    fi="Intermezzos",
    fr="Intermèdes",
    gr="Παύσεις",
    hr="Intermeci",
    hu="Intermezzok",
    it="Intermezzi",
    ja="間奏曲",
    kr="간주곡",
    la="Intermissa",
    lt="Intermezzos",
    nb="Intermesso",
    nl="Intermezzo's",
    nn="Intermesso",
    pl="Intermezza",
    pt="Intermédios",
    ro="Intermzzo",
    ru="Список вставок",
    sk="Intermezzá",
    sl="Intermezzi",
    sv="Intermezzon",
    tk="Arakesmeler",
    tr="",
    ua="Перелік вставок",
    vi="Intermezzos",
   },
  },
  logos={
   labels={
    af="Logos",
    ar="الشعارات",
    ca="Logotips",
    cn="徽贬",
    cs="Loga",
    da="Logoer",
    de="Logos",
    en="Logos",
    es="Logotipos",
    fi="Vertauskuva",
    fr="Logos",
    gr="Λογότυπα",
    hr="Logotipi",
    hu="Fejlécek",
    it="Logotipi",
    ja="理性",
    kr="이성",
    la="Typi negotiales",
    lt="Logos",
    nb="Logoer",
    nl="Logo's",
    nn="Logoar",
    pl="Znaki",
    pt="Logotipos",
    ro="Logo-uri",
    ru="Логотипы",
    sk="Logá",
    sl="Logotipi",
    sv="Loggor",
    tk="Logolar",
    tr="Logolar",
    ua="Логотипи",
    vi="Biểu tượng",
   },
  },
  pubs={
   labels={
    af="",
    ca="Referències",
    cs="Literatura",
    da="",
    de="Literatur",
    en="References",
    es="Bibliografía",
    fi="",
    fr="Bibliographie",
    gr="",
    hr="Literatura",
    hu="Bibliográfia",
    it="Bibliografia",
    la="",
    lt="Literatūra",
    nb="",
    nl="Literatuur",
    nn="",
    pl="Bibliografia",
    pt="",
    ro="",
    ru="",
    sk="",
    sl="Literatura",
    sv="",
    tk="",
    tr="",
    ua="",
    vi="",
   },
  },
  tables={
   labels={
    af="Tabelle",
    ar="الجداول",
    ca="Taules",
    cn="表格",
    cs="Tabulky",
    da="Tabeller",
    de="Tabellen",
    en="Tables",
    es="Tablas",
    fi="Taulukkoj",
    fr="Tableaux",
    gr="Πίνακες",
    hr="Tablice",
    hu="Táblázatok",
    it="Tabelle",
    ja="机",
    kr="표",
    la="Tabulae",
    lt="Lentelės",
    nb="Tabeller",
    nl="Tabellen",
    nn="Tabellar",
    pl="Tabele",
    pt="Tabelas",
    ro="Tabele",
    ru="Список таблиц",
    sk="Tabuliek",
    sl="Tabele",
    sv="Tabeller",
    tk="Tablisalar",
    tr="Tablolar",
    ua="Перелік таблиць",
    vi="Danh sách bảng",
   },
  },
  units={
   labels={
    af="Eenhede",
    ar="الوحدات",
    ca="Unitats",
    cn="计量单位",
    cs="Jednotky",
    da="Enheder",
    de="Einheiten",
    en="Units",
    es="Unidades",
    fi="Yksiköt",
    fr="Unités",
    gr="Μονάδες",
    hr="Jedinice",
    hu="Mértékegységek",
    it="Unità",
    ja="ユニッツ",
    kr="측정단위",
    la="Modi",
    lt="Units",
    nb="Enheter",
    nl="Eenheden",
    nn="Einingar",
    pl="Jednostki",
    pt="Unidades",
    ro="Unități",
    ru="Единицы измерения",
    sk="Jednotky",
    sl="Enote",
    sv="Enheter",
    tk="Birlikler",
    tr="Birimler",
    ua="Одиниці виміру",
    vi="Đơn vị",
   },
  },
 },
}
