/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.context;

import java.util.SortedSet;
import java.util.TreeSet;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.SimpleAdapter;
import org.python.pydev.refactoring.ast.visitors.context.AbstractContextVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAttributeVisitor
extends AbstractContextVisitor<SimpleAdapter> {
    private SortedSet<String> uniqueAttributes = new TreeSet<String>();
    private FunctionDef lastFunctionDef;

    public GlobalAttributeVisitor(ModuleAdapter module, AbstractScopeNode<?> parent) {
        super(module, parent);
    }

    @Override
    protected void registerInContext(SimpleNode node) {
        this.addUniqueOnly(node);
    }

    private void addUniqueOnly(SimpleNode node) {
        if (!this.uniqueAttributes.contains(this.getUniqueID(node))) {
            this.uniqueAttributes.add(this.getUniqueID(node));
            if (!this.moduleAdapter.isImport(this.nodeHelper.getName(node))) {
                super.registerInContext(node);
            }
        }
    }

    private String getUniqueID(SimpleNode node) {
        String parentName = this.nodeHelper.getName((SimpleNode)((AbstractScopeNode)this.parents.peek()).getASTNode());
        String nodeName = this.nodeHelper.getName(node);
        return new StringBuffer(String.valueOf(parentName)).append(nodeName).toString();
    }

    protected boolean isInAttribute() {
        for (SimpleNode node : this.stack) {
            if (!this.nodeHelper.isAttribute(node)) continue;
            return true;
        }
        return false;
    }

    public Object visitImport(Import node) throws Exception {
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        return null;
    }

    public Object visitName(Name node) throws Exception {
        if (this.nodeHelper.isSelf(node.id)) {
            return null;
        }
        if (this.isInClassDef()) {
            if (!this.isInFunctionDef()) {
                if (!this.moduleAdapter.isGlobal(this.nodeHelper.getName((SimpleNode)node))) {
                    this.registerInContext((SimpleNode)node);
                }
            } else if (this.lastFunctionDef != null) {
                stmtType[] stmtTypeArray = this.lastFunctionDef.body;
                int n = this.lastFunctionDef.body.length;
                int n2 = 0;
                while (n2 < n) {
                    stmtType stmt = stmtTypeArray[n2];
                    if (this.nodeHelper.isClassDef((SimpleNode)stmt) && stmt.equals(((AbstractScopeNode)this.parents.peek()).getASTNode())) {
                        this.registerInContext((SimpleNode)node);
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        if (this.isParentClassDecl() && this.isInAttribute() && this.nodeHelper.isAttribute((SimpleNode)this.stack.peek())) {
            this.registerInContext((SimpleNode)node);
        }
        return super.visitNameTok(node);
    }

    public Object visitAttribute(Attribute node) throws Exception {
        Object parent;
        this.before((SimpleNode)node);
        if (this.isParentClassDecl() && this.nodeHelper.isName((SimpleNode)node.value) && this.nodeHelper.isFullyQualified((SimpleNode)node.value, (SimpleNode)(parent = ((AbstractScopeNode)this.parents.peek()).getASTNode())) && this.nodeHelper.isNameTok((SimpleNode)node.attr)) {
            this.visit((SimpleNode)node.attr);
        }
        this.after();
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.visit((SimpleNode[])node.args);
        this.visit((SimpleNode[])node.keywords);
        this.visit((SimpleNode)node.starargs);
        this.visit((SimpleNode)node.kwargs);
        return null;
    }

    @Override
    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.lastFunctionDef = node;
        this.updateASTContext((SimpleNode)node);
        return null;
    }

    @Override
    public Object visitClassDef(ClassDef node) throws Exception {
        AbstractNodeAdapter<SimpleNode> context = this.before((SimpleNode)node);
        this.pushParent(context);
        this.visit((SimpleNode[])node.body);
        this.parents.pop();
        this.after();
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        if (this.nodeHelper.isPropertyAssign(node)) {
            return null;
        }
        this.before((SimpleNode)node);
        this.visit((SimpleNode[])node.targets);
        this.after();
        return null;
    }

    @Override
    protected SimpleAdapter createAdapter(AbstractScopeNode<?> parent, SimpleNode node) {
        return new SimpleAdapter(this.moduleAdapter, parent, node, this.moduleAdapter.getEndLineDelimiter());
    }

    @Override
    protected /* synthetic */ Object createAdapter(AbstractScopeNode abstractScopeNode, SimpleNode simpleNode) {
        return this.createAdapter(abstractScopeNode, simpleNode);
    }
}

