/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class MetaFieldProperty
extends MetaProperty {
    private Field field;

    public MetaFieldProperty(Field field) {
        super(field.getName(), field.getType());
        this.field = field;
    }

    public Object getProperty(final Object object) {
        try {
            Object value = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException {
                    MetaFieldProperty.this.field.setAccessible(true);
                    return MetaFieldProperty.this.field.get(object);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pe) {
            throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", pe.getException());
        }
    }

    public void setProperty(final Object object, Object newValue) {
        final Object goalValue = DefaultTypeTransformation.castToType(newValue, this.field.getType());
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, GroovyRuntimeException {
                    MetaFieldProperty.this.field.setAccessible(true);
                    MetaFieldProperty.this.field.set(object, goalValue);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "'.", ex.getException());
        }
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }
}

