/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.event.DateSelectionEvent;
import net.sf.nachocalendar.event.DateSelectionListener;
import net.sf.nachocalendar.model.DateSelectionModel;

public class DefaultDateSelectionModel
implements DateSelectionModel {
    private DateSelectionModel model = new MultipleInterval();
    private boolean isAdjusting;
    private boolean pendingEvent;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$net$sf$nachocalendar$event$DateSelectionListener;

    public void addSelectionInterval(Date from, Date to) {
        this.model.addSelectionInterval(from, to);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    public void clearSelection() {
        this.model.clearSelection();
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    public boolean isSelectedDate(Date date) {
        return this.model.isSelectedDate(date);
    }

    public boolean isSelectionEmpty() {
        return this.model.isSelectionEmpty();
    }

    public void removeSelectionInterval(Date from, Date to) {
        this.model.removeSelectionInterval(from, to);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    public synchronized void addDateSelectionListener(DateSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$net$sf$nachocalendar$event$DateSelectionListener == null ? (class$net$sf$nachocalendar$event$DateSelectionListener = DefaultDateSelectionModel.class$("net.sf.nachocalendar.event.DateSelectionListener")) : class$net$sf$nachocalendar$event$DateSelectionListener, listener);
    }

    public synchronized void removeDateSelectionListener(DateSelectionListener listener) {
        this.listenerList.remove(class$net$sf$nachocalendar$event$DateSelectionListener == null ? (class$net$sf$nachocalendar$event$DateSelectionListener = DefaultDateSelectionModel.class$("net.sf.nachocalendar.event.DateSelectionListener")) : class$net$sf$nachocalendar$event$DateSelectionListener, listener);
    }

    private void fireDateSelectionListenerValueChanged(DateSelectionEvent event) {
        if (this.isAdjusting) {
            this.pendingEvent = true;
            return;
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$net$sf$nachocalendar$event$DateSelectionListener == null ? DefaultDateSelectionModel.class$("net.sf.nachocalendar.event.DateSelectionListener") : class$net$sf$nachocalendar$event$DateSelectionListener)) continue;
            ((DateSelectionListener)listeners[i + 1]).valueChanged(event);
        }
    }

    public int getSelectionMode() {
        return this.model.getSelectionMode();
    }

    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: {
                this.model = new SingleSelection();
                break;
            }
            case 1: {
                this.model = new SingleInterval();
                break;
            }
            default: {
                this.model = new MultipleInterval();
            }
        }
    }

    public Date getLeadSelectionDate() {
        return this.model.getLeadSelectionDate();
    }

    public void setLeadSelectionDate(Date date) {
        this.model.setLeadSelectionDate(date);
    }

    public Object getSelectedDate() {
        return this.model.getSelectedDate();
    }

    public Object[] getSelectedDates() {
        return this.model.getSelectedDates();
    }

    public void setSelectedDate(Object date) {
        this.model.setSelectedDate(date);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    public void setSelectedDates(Object[] dates) {
        this.model.setSelectedDates(dates);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    private static Object[] getDates(Date from, Date to) {
        ArrayList<Date> retorno = new ArrayList<Date>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(from);
        while (to.after(cal.getTime()) || CalendarUtils.isSameDay(to, cal.getTime())) {
            retorno.add(cal.getTime());
            ((Calendar)cal).add(6, 1);
        }
        Collections.sort(retorno);
        return retorno.toArray();
    }

    public void setValueIsAdjusting(boolean b) {
        this.isAdjusting = b;
        if (!b && this.pendingEvent) {
            this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
            this.pendingEvent = false;
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MultipleInterval
    implements DateSelectionModel {
        private List selection = new ArrayList();
        private Calendar calendar = new GregorianCalendar();
        private Date leadSelection;

        MultipleInterval() {
        }

        public void addSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                return;
            }
            Date d1 = null;
            Date d2 = null;
            if (from.before(to)) {
                d1 = from;
                d2 = to;
            } else {
                d1 = to;
                d2 = from;
            }
            this.calendar.setTime(d1);
            do {
                this.selection.add(this.calendar.getTime());
                this.calendar.add(6, 1);
            } while (d2.after(this.calendar.getTime()) || CalendarUtils.isSameDay(d2, this.calendar.getTime()));
            this.leadSelection = to;
        }

        public void clearSelection() {
            this.selection.clear();
        }

        public boolean isSelectedDate(Date date) {
            if (this.selection.isEmpty()) {
                return false;
            }
            if (date == null) {
                return false;
            }
            Iterator it = this.selection.iterator();
            while (it.hasNext()) {
                Date d = (Date)it.next();
                if (!CalendarUtils.isSameDay(d, date)) continue;
                return true;
            }
            return false;
        }

        public boolean isSelectionEmpty() {
            return this.selection.isEmpty();
        }

        public void removeSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                return;
            }
            if (from == null || to == null) {
                return;
            }
            Object[] dates = DefaultDateSelectionModel.getDates(from, to);
            block0: for (int i = 0; i < dates.length; ++i) {
                Iterator it = this.selection.iterator();
                Date d = (Date)dates[i];
                while (it.hasNext()) {
                    Date dd = (Date)it.next();
                    if (!CalendarUtils.isSameDay(d, dd)) continue;
                    this.selection.remove(dd);
                    continue block0;
                }
            }
            this.leadSelection = to;
        }

        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        public int getSelectionMode() {
            return 2;
        }

        public void setSelectionMode(int selectionMode) {
        }

        public Date getLeadSelectionDate() {
            return this.leadSelection;
        }

        public void setLeadSelectionDate(Date date) {
            this.leadSelection = date;
        }

        public Object getSelectedDate() {
            if (this.selection.isEmpty()) {
                return null;
            }
            return this.leadSelection;
        }

        public Object[] getSelectedDates() {
            Collections.sort(this.selection);
            return this.selection.toArray();
        }

        public void setSelectedDate(Object date) {
            this.selection.clear();
            if (date != null) {
                try {
                    this.selection.add(CalendarUtils.convertToDate(date));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        public void setSelectedDates(Object[] dates) {
            this.selection.clear();
            if (dates == null || dates.length < 1) {
                return;
            }
            for (int i = 0; i < dates.length; ++i) {
                try {
                    this.selection.add(CalendarUtils.convertToDate(dates[i]));
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        public void setValueIsAdjusting(boolean b) {
        }

        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private static class SingleInterval
    implements DateSelectionModel {
        private Date from;
        private Date to;
        private Date lead;

        private SingleInterval() {
        }

        public void addSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                this.from = null;
                this.to = null;
                return;
            }
            if (from.after(to)) {
                this.from = to;
                this.to = from;
            } else {
                this.from = from;
                this.to = to;
            }
            this.lead = to;
        }

        public void clearSelection() {
            this.from = null;
            this.to = null;
        }

        public boolean isSelectedDate(Date date) {
            if (this.from == null || this.to == null) {
                return false;
            }
            if (date == null) {
                return false;
            }
            if (CalendarUtils.isSameDay(date, this.from) || CalendarUtils.isSameDay(date, this.to)) {
                return true;
            }
            return !date.before(this.from) && !date.after(this.to);
        }

        public boolean isSelectionEmpty() {
            return this.from == null || this.to == null;
        }

        public void removeSelectionInterval(Date from, Date to) {
        }

        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        public int getSelectionMode() {
            return 1;
        }

        public void setSelectionMode(int selectionMode) {
        }

        public Date getLeadSelectionDate() {
            return this.lead;
        }

        public void setLeadSelectionDate(Date date) {
            this.lead = date;
        }

        public Object getSelectedDate() {
            return this.lead;
        }

        public Object[] getSelectedDates() {
            return DefaultDateSelectionModel.getDates(this.from, this.to);
        }

        public void setSelectedDate(Object date) {
            try {
                this.to = this.from = CalendarUtils.convertToDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void setSelectedDates(Object[] dates) {
            if (dates == null || dates.length < 1) {
                this.from = null;
                this.to = null;
                return;
            }
            try {
                this.from = CalendarUtils.convertToDate(dates[0]);
                this.to = CalendarUtils.convertToDate(dates[dates.length - 1]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void setValueIsAdjusting(boolean b) {
        }

        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private static class SingleSelection
    implements DateSelectionModel {
        private Date selection;

        private SingleSelection() {
        }

        public void addSelectionInterval(Date from, Date to) {
            this.selection = to;
        }

        public void clearSelection() {
            this.selection = null;
        }

        public boolean isSelectedDate(Date date) {
            if (this.selection == null) {
                return false;
            }
            if (date == null) {
                return false;
            }
            return CalendarUtils.isSameDay(date, this.selection);
        }

        public boolean isSelectionEmpty() {
            return this.selection == null;
        }

        public void removeSelectionInterval(Date from, Date to) {
        }

        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        public int getSelectionMode() {
            return 0;
        }

        public void setSelectionMode(int selectionMode) {
        }

        public Date getLeadSelectionDate() {
            return this.selection;
        }

        public void setLeadSelectionDate(Date date) {
            this.selection = date;
        }

        public Object getSelectedDate() {
            return this.selection;
        }

        public Object[] getSelectedDates() {
            return new Object[]{this.selection};
        }

        public void setSelectedDate(Object date) {
            if (date == null) {
                return;
            }
            try {
                this.selection = CalendarUtils.convertToDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void setSelectedDates(Object[] dates) {
            if (dates == null) {
                return;
            }
            if (dates.length == 0) {
                this.selection = null;
                return;
            }
            try {
                this.selection = CalendarUtils.convertToDate(dates[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void setValueIsAdjusting(boolean b) {
        }

        public boolean getValueIsAdjusting() {
            return false;
        }
    }
}

