/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;

public class ArrowButton
extends JButton {
    private int defaultsize = 16;
    private int direction;

    public ArrowButton(int direction) {
        this.direction = direction;
    }

    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getSize().width;
        int h = this.getSize().height;
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        int x = (w - size) / 2;
        int y = (h - size) / 2;
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (this.isEnabled()) {
            g.setColor(this.getForeground());
        } else {
            g.setColor(Color.gray);
        }
        switch (this.direction) {
            case 1: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                break;
            }
            case 5: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                break;
            }
            case 3: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.defaultsize, this.defaultsize);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

