/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public final class PrimaveraConvert {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 4) {
                System.out.println("Usage: PrimaveraConvert <JDBC Driver Class> <JDBC connection string> <project ID> <output file name>");
            } else {
                PrimaveraConvert primaveraConvert = new PrimaveraConvert();
                primaveraConvert.process(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void process(String string, String string2, String string3, String string4) throws Exception {
        System.out.println("Reading Primavera database started.");
        long l = System.currentTimeMillis();
        Class.forName(string);
        Connection connection = DriverManager.getConnection(string2);
        PrimaveraDatabaseReader primaveraDatabaseReader = new PrimaveraDatabaseReader();
        primaveraDatabaseReader.setConnection(connection);
        primaveraDatabaseReader.setProjectID(Integer.valueOf(string3));
        ProjectFile projectFile = primaveraDatabaseReader.read();
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Reading database completed in " + l2 + "ms.");
        System.out.println("Writing output file started.");
        l = System.currentTimeMillis();
        ProjectWriter projectWriter = ProjectWriterUtility.getProjectWriter(string4);
        projectWriter.write(projectFile, string4);
        l2 = System.currentTimeMillis() - l;
        System.out.println("Writing output completed in " + l2 + "ms.");
    }
}

