/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpxjQuery {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static void query(String string) throws Exception {
        ProjectReader projectReader = ProjectReaderUtility.getProjectReader(string);
        ProjectFile projectFile = projectReader.read(string);
        System.out.println("MPP file type: " + projectFile.getMppFileType());
        MpxjQuery.listProjectHeader(projectFile);
        MpxjQuery.listResources(projectFile);
        MpxjQuery.listTasks(projectFile);
        MpxjQuery.listAssignments(projectFile);
        MpxjQuery.listAssignmentsByTask(projectFile);
        MpxjQuery.listAssignmentsByResource(projectFile);
        MpxjQuery.listHierarchy(projectFile);
        MpxjQuery.listTaskNotes(projectFile);
        MpxjQuery.listResourceNotes(projectFile);
        MpxjQuery.listRelationships(projectFile);
        MpxjQuery.listSlack(projectFile);
        MpxjQuery.listCalendars(projectFile);
    }

    private static void listProjectHeader(ProjectFile projectFile) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        Date date = projectHeader.getStartDate();
        Date date2 = projectHeader.getFinishDate();
        String string = date == null ? "(none)" : simpleDateFormat.format(date);
        String string2 = date2 == null ? "(none)" : simpleDateFormat.format(date2);
        System.out.println("Project Header: StartDate=" + string + " FinishDate=" + string2);
        System.out.println();
    }

    private static void listResources(ProjectFile projectFile) {
        for (Resource resource : projectFile.getAllResources()) {
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ") Start=" + resource.getStart() + " Finish=" + resource.getFinish());
        }
        System.out.println();
    }

    private static void listTasks(ProjectFile projectFile) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        for (Task task : projectFile.getAllTasks()) {
            Date date = task.getStart();
            String string = date != null ? simpleDateFormat.format(date) : "(no date supplied)";
            date = task.getFinish();
            String string2 = date != null ? simpleDateFormat.format(date) : "(no date supplied)";
            Duration duration = task.getDuration();
            String string3 = duration != null ? duration.toString() : "(no duration supplied)";
            String string4 = task.getBaselineDurationText();
            if (string4 == null) {
                duration = task.getBaselineDuration();
                string4 = duration != null ? duration.toString() : "(no duration supplied)";
            }
            System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID() + " (Start Date=" + string + " Finish Date=" + string2 + " Duration=" + string3 + " Baseline Duration=" + string4 + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + " Recurring=" + task.getRecurring() + ")");
        }
        System.out.println();
    }

    private static void listHierarchy(ProjectFile projectFile) {
        for (Task task : projectFile.getChildTasks()) {
            System.out.println("Task: " + task.getName());
            MpxjQuery.listHierarchy(task, " ");
        }
        System.out.println();
    }

    private static void listHierarchy(Task task, String string) {
        for (Task task2 : task.getChildTasks()) {
            System.out.println(string + "Task: " + task2.getName());
            MpxjQuery.listHierarchy(task2, string + " ");
        }
    }

    private static void listAssignments(ProjectFile projectFile) {
        for (ResourceAssignment resourceAssignment : projectFile.getAllResourceAssignments()) {
            Task task = resourceAssignment.getTask();
            String string = task == null ? "(null task)" : task.getName();
            Resource resource = resourceAssignment.getResource();
            String string2 = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + string + " Resource=" + string2);
        }
        System.out.println();
    }

    private static void listAssignmentsByTask(ProjectFile projectFile) {
        for (Task task : projectFile.getAllTasks()) {
            System.out.println("Assignments for task " + task.getName() + ":");
            for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
                Resource resource = resourceAssignment.getResource();
                String string = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + string);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(ProjectFile projectFile) {
        for (Resource resource : projectFile.getAllResources()) {
            System.out.println("Assignments for resource " + resource.getName() + ":");
            for (ResourceAssignment resourceAssignment : resource.getTaskAssignments()) {
                Task task = resourceAssignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(ProjectFile projectFile) {
        for (Task task : projectFile.getAllTasks()) {
            String string = task.getNotes();
            if (string == null || string.length() == 0) continue;
            System.out.println("Notes for " + task.getName() + ": " + string);
        }
        System.out.println();
    }

    private static void listResourceNotes(ProjectFile projectFile) {
        for (Resource resource : projectFile.getAllResources()) {
            String string = resource.getNotes();
            if (string == null || string.length() == 0) continue;
            System.out.println("Notes for " + resource.getName() + ": " + string);
        }
        System.out.println();
    }

    private static void listRelationships(ProjectFile projectFile) {
        for (Task task : projectFile.getAllTasks()) {
            System.out.print(task.getID());
            System.out.print('\t');
            System.out.print(task.getName());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getPredecessors());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getSuccessors());
            System.out.println();
        }
    }

    private static void dumpRelationList(List<Relation> list) {
        if (list != null && !list.isEmpty()) {
            if (list.size() > 1) {
                System.out.print('\"');
            }
            boolean bl = true;
            for (Relation relation : list) {
                if (!bl) {
                    System.out.print(',');
                }
                bl = false;
                System.out.print(relation.getTargetTask().getID());
                Duration duration = relation.getLag();
                if (relation.getType() != RelationType.FINISH_START || duration.getDuration() != 0.0) {
                    System.out.print(relation.getType());
                }
                if (duration.getDuration() == 0.0) continue;
                if (duration.getDuration() > 0.0) {
                    System.out.print("+");
                }
                System.out.print(duration);
            }
            if (list.size() > 1) {
                System.out.print('\"');
            }
        }
    }

    private static void listSlack(ProjectFile projectFile) {
        for (Task task : projectFile.getAllTasks()) {
            System.out.println(task.getName() + " Total Slack=" + task.getTotalSlack() + " Start Slack=" + task.getStartSlack() + " Finish Slack=" + task.getFinishSlack());
        }
    }

    private static void listCalendars(ProjectFile projectFile) {
        for (ProjectCalendar projectCalendar : projectFile.getBaseCalendars()) {
            System.out.println(projectCalendar.toString());
        }
        for (ProjectCalendar projectCalendar : projectFile.getResourceCalendars()) {
            System.out.println(projectCalendar.toString());
        }
    }
}

