/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            try {
                this.m_projectFile = new ProjectFile();
                this.m_projectFile.setAutoTaskUniqueID(false);
                this.m_projectFile.setAutoResourceUniqueID(false);
                this.m_projectFile.setAutoCalendarUniqueID(false);
                this.m_projectFile.setAutoAssignmentUniqueID(false);
                this.m_projectFile.setTaskFieldAlias(TaskField.TEXT1, "Code");
                this.m_projectFile.addProjectListeners(this.m_projectListeners);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(inputStream));
                if (CONTEXT == null) {
                    throw CONTEXT_EXCEPTION;
                }
                Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
                APIBusinessObjects aPIBusinessObjects = (APIBusinessObjects)unmarshaller.unmarshal((Source)sAXSource);
                List<ProjectType> list = aPIBusinessObjects.getProject();
                if (list.size() != 1) {
                    throw new MPXJException("Exoecting 1 project, found " + list.size());
                }
                ProjectType projectType = list.get(0);
                this.processProjectHeader(aPIBusinessObjects, projectType);
                this.processCalendars(aPIBusinessObjects);
                this.processResources(aPIBusinessObjects);
                this.processTasks(projectType);
                this.processPredecessors(projectType);
                this.processAssignments(projectType);
                this.m_projectFile.updateUniqueCounters();
                ProjectFile projectFile = this.m_projectFile;
                Object var12_14 = null;
                this.m_projectFile = null;
                this.m_clashMap.clear();
                this.m_calMap.clear();
                return projectFile;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new MPXJException("Failed to parse file", parserConfigurationException);
            }
            catch (JAXBException jAXBException) {
                throw new MPXJException("Failed to parse file", (Exception)((Object)jAXBException));
            }
            catch (SAXException sAXException) {
                throw new MPXJException("Failed to parse file", sAXException);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_calMap.clear();
            throw throwable;
        }
    }

    private void processProjectHeader(APIBusinessObjects aPIBusinessObjects, ProjectType projectType) {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        projectHeader.setCreationDate(this.getValue(projectType.getCreateDate()));
        projectHeader.setFinishDate(this.getValue(projectType.getFinishDate()));
        projectHeader.setName(projectType.getName());
        projectHeader.setStartDate(projectType.getPlannedStartDate());
        List<GlobalPreferencesType> list = aPIBusinessObjects.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType globalPreferencesType = list.get(0);
            projectHeader.setCreationDate(this.getValue(globalPreferencesType.getCreateDate()));
            projectHeader.setLastSaved(this.getValue(globalPreferencesType.getLastUpdateDate()));
            projectHeader.setMinutesPerDay((int)(NumberUtility.getDouble(globalPreferencesType.getHoursPerDay()) * 60.0));
            projectHeader.setMinutesPerWeek((int)(NumberUtility.getDouble(globalPreferencesType.getHoursPerWeek()) * 60.0));
            projectHeader.setWeekStartDay(Day.getInstance(NumberUtility.getInt(globalPreferencesType.getStartDayOfWeek())));
            List<CurrencyType> list2 = aPIBusinessObjects.getCurrency();
            for (CurrencyType currencyType : list2) {
                if (!currencyType.getObjectId().equals(globalPreferencesType.getBaseCurrencyObjectId())) continue;
                projectHeader.setCurrencySymbol(currencyType.getSymbol());
                break;
            }
        }
    }

    private void processCalendars(APIBusinessObjects aPIBusinessObjects) {
        for (CalendarType calendarType : aPIBusinessObjects.getCalendar()) {
            Object object;
            List<WorkTimeType> list;
            Object object2;
            ProjectCalendar projectCalendar = this.m_projectFile.addBaseCalendar();
            Integer n = calendarType.getObjectId();
            this.m_calMap.put(n, projectCalendar);
            projectCalendar.setName(calendarType.getName());
            projectCalendar.setUniqueID(n);
            CalendarType.StandardWorkWeek standardWorkWeek = calendarType.getStandardWorkWeek();
            if (standardWorkWeek != null) {
                object2 = standardWorkWeek.getStandardWorkHours().iterator();
                while (object2.hasNext()) {
                    CalendarType.StandardWorkWeek.StandardWorkHours standardWorkHours = (CalendarType.StandardWorkWeek.StandardWorkHours)object2.next();
                    Day day = DAY_MAP.get(standardWorkHours.getDayOfWeek());
                    list = standardWorkHours.getWorkTime();
                    if (list.isEmpty() || list.get(0) == null) {
                        projectCalendar.setWorkingDay(day, false);
                        continue;
                    }
                    projectCalendar.setWorkingDay(day, true);
                    object = projectCalendar.addCalendarHours(day);
                    for (WorkTimeType workTimeType : list) {
                        if (workTimeType == null) continue;
                        ((ProjectCalendarDateRanges)object).addRange(new DateRange(workTimeType.getStart(), workTimeType.getFinish()));
                    }
                }
            }
            if ((object2 = calendarType.getHolidayOrExceptions()) == null) continue;
            for (CalendarType.HolidayOrExceptions.HolidayOrException holidayOrException : ((CalendarType.HolidayOrExceptions)object2).getHolidayOrException()) {
                list = DateUtility.getDayStartDate(holidayOrException.getDate());
                object = DateUtility.getDayEndDate(holidayOrException.getDate());
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException((Date)((Object)list), (Date)object);
                List<WorkTimeType> list2 = holidayOrException.getWorkTime();
                for (WorkTimeType workTimeType : list2) {
                    if (workTimeType == null) continue;
                    projectCalendarException.addRange(new DateRange(workTimeType.getStart(), workTimeType.getFinish()));
                }
            }
        }
    }

    private void processResources(APIBusinessObjects aPIBusinessObjects) {
        List<net.sf.mpxj.primavera.schema.ResourceType> list = aPIBusinessObjects.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType resourceType : list) {
            ProjectCalendar projectCalendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(resourceType.getObjectId());
            resource.setName(resourceType.getName());
            resource.setCode(resourceType.getEmployeeId());
            resource.setEmailAddress(resourceType.getEmailAddress());
            resource.setNotes(resourceType.getResourceNotes());
            resource.setCreationDate(this.getValue(resourceType.getCreateDate()));
            resource.setType(RESOURCE_TYPE_MAP.get(resourceType.getResourceType()));
            Integer n = resourceType.getCalendarObjectId();
            if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
                ProjectCalendar projectCalendar2;
                if (!projectCalendar.isDerived()) {
                    projectCalendar2 = this.m_projectFile.addResourceCalendar();
                    projectCalendar2.setParent(projectCalendar);
                    projectCalendar2.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(projectCalendar2);
                } else if (projectCalendar.getResource() == null) {
                    resource.setResourceCalendar(projectCalendar);
                } else {
                    projectCalendar2 = this.m_projectFile.addResourceCalendar();
                    projectCalendar2.copy(projectCalendar);
                    resource.setResourceCalendar(projectCalendar2);
                }
            }
            this.m_projectFile.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType projectType) {
        Comparable<Integer> comparable;
        List<WBSType> list = projectType.getWBS();
        List<ActivityType> list2 = projectType.getActivity();
        HashSet<Comparable<Integer>> hashSet = new HashSet<Comparable<Integer>>();
        for (WBSType object2 : list) {
            Task task = this.m_projectFile.addTask();
            comparable = object2.getObjectId();
            hashSet.add(comparable);
            task.setUniqueID((Integer)comparable);
            task.setName(object2.getName());
            task.setBaselineCost(this.getValue(object2.getSummaryBaselineTotalCost()));
            task.setRemainingCost(this.getValue(object2.getSummaryRemainingTotalCost()));
            task.setRemainingDuration(this.getDuration(object2.getSummaryRemainingDuration()));
            task.setStart(this.getValue(object2.getAnticipatedStartDate()));
            task.setFinish(this.getValue(object2.getAnticipatedFinishDate()));
            task.setText1(object2.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType wBSType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(wBSType.getObjectId());
            comparable = this.m_projectFile.getTaskByUniqueID(this.getValue(wBSType.getParentObjectId()));
            if (comparable == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            ((Task)comparable).getChildTasks().add(task);
        }
        int n = 1;
        this.m_clashMap.clear();
        for (ActivityType activityType : list2) {
            Comparable<Integer> comparable2;
            comparable = activityType.getObjectId();
            if (hashSet.contains(comparable)) {
                while (hashSet.contains(n)) {
                    ++n;
                }
                comparable2 = n;
                this.m_clashMap.put((Integer)comparable, (Integer)comparable2);
                comparable = comparable2;
            }
            hashSet.add(comparable);
            Integer n2 = this.getValue(activityType.getWBSObjectId());
            Task task = this.m_projectFile.getTaskByUniqueID(n2);
            comparable2 = task == null ? this.m_projectFile.addTask() : task.addTask();
            ((Task)comparable2).setUniqueID((Integer)comparable);
            ((Task)comparable2).setPercentageComplete(activityType.getPhysicalPercentComplete());
            ((Task)comparable2).setName(activityType.getName());
            ((Task)comparable2).setRemainingDuration(this.getDuration(activityType.getRemainingDuration()));
            ((Task)comparable2).setActualWork(this.getDuration(activityType.getActualDuration()));
            ((Task)comparable2).setRemainingWork(this.getDuration(activityType.getRemainingTotalUnits()));
            ((Task)comparable2).setBaselineDuration(this.getDuration(activityType.getBaselineDuration()));
            ((Task)comparable2).setConstraintDate(this.getValue(activityType.getPrimaryConstraintDate()));
            ((Task)comparable2).setConstraintType(CONSTRAINT_TYPE_MAP.get(activityType.getPrimaryConstraintType()));
            ((Task)comparable2).setActualStart(this.getValue(activityType.getActualStartDate()));
            ((Task)comparable2).setActualFinish(this.getValue(activityType.getActualFinishDate()));
            ((Task)comparable2).setLateStart(this.getValue(activityType.getLateStartDate()));
            ((Task)comparable2).setLateFinish(this.getValue(activityType.getLateFinishDate()));
            ((Task)comparable2).setFinish(this.getValue(activityType.getExpectedFinishDate()));
            ((Task)comparable2).setEarlyStart(this.getValue(activityType.getEarlyStartDate()));
            ((Task)comparable2).setEarlyFinish(this.getValue(activityType.getEarlyFinishDate()));
            ((Task)comparable2).setBaselineStart(this.getValue(activityType.getBaselineStartDate()));
            ((Task)comparable2).setBaselineFinish(this.getValue(activityType.getBaselineFinishDate()));
            ((Task)comparable2).setPriority(PRIORITY_MAP.get(activityType.getLevelingPriority()));
            ((Task)comparable2).setCreateDate(this.getValue(activityType.getCreateDate()));
            Integer n3 = activityType.getCalendarObjectId();
            ProjectCalendar projectCalendar = this.m_calMap.get(n3);
            ((Task)comparable2).setCalendar(projectCalendar);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.START, TaskField.BASELINE_START, TaskField.ACTUAL_START);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.FINISH, TaskField.BASELINE_FINISH, TaskField.ACTUAL_FINISH);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            this.m_projectFile.fireTaskReadEvent((Task)comparable2);
        }
        this.updateStructure();
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType fieldType2, FieldType fieldType3) {
        Object object = fieldContainer.getCachedValue(fieldType3);
        if (object == null) {
            object = fieldContainer.getCachedValue(fieldType2);
        }
        fieldContainer.set(fieldType, object);
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    private void processPredecessors(ProjectType projectType) {
        for (RelationshipType relationshipType : projectType.getRelationship()) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getSuccessorActivityObjectId()));
            Task task2 = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getPredecessorActivityObjectId()));
            if (task == null || task2 == null) continue;
            RelationType relationType = RELATION_TYPE_MAP.get(relationshipType.getType());
            Duration duration = this.getDuration(relationshipType.getLag());
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_projectFile.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType projectType) {
        List<ResourceAssignmentType> list = projectType.getResourceAssignment();
        for (ResourceAssignmentType resourceAssignmentType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(resourceAssignmentType.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(this.getValue(resourceAssignmentType.getResourceObjectId()));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(resourceAssignmentType.getObjectId());
            resourceAssignment.setRemainingWork(this.getDuration(resourceAssignmentType.getRemainingUnits()));
            resourceAssignment.setBaselineWork(this.getDuration(resourceAssignmentType.getPlannedUnits()));
            resourceAssignment.setActualWork(this.getDuration(resourceAssignmentType.getActualUnits()));
            resourceAssignment.setBaselineCost(this.getValue(resourceAssignmentType.getPlannedCost()));
            resourceAssignment.setActualCost(this.getValue(resourceAssignmentType.getActualCost()));
            resourceAssignment.setActualStart(this.getValue(resourceAssignmentType.getActualStartDate()));
            resourceAssignment.setActualFinish(this.getValue(resourceAssignmentType.getActualFinishDate()));
            resourceAssignment.setBaselineStart(resourceAssignmentType.getPlannedStartDate());
            resourceAssignment.setBaselineFinish(resourceAssignmentType.getPlannedFinishDate());
            this.populateField(resourceAssignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(resourceAssignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_projectFile.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private <T> T getValue(JAXBElement<T> jAXBElement) {
        Object object = null;
        if (jAXBElement != null) {
            object = jAXBElement.getValue();
        }
        return (T)object;
    }

    private Duration getDuration(JAXBElement<Double> jAXBElement) {
        Double d;
        Duration duration = null;
        if (jAXBElement != null && (d = (Double)jAXBElement.getValue()) != null) {
            duration = Duration.getInstance(NumberUtility.getDouble(d), TimeUnit.HOURS);
        }
        return duration;
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.MATERIAL);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
    }
}

