/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.planner;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.planner.schema.Allocation;
import net.sf.mpxj.planner.schema.Allocations;
import net.sf.mpxj.planner.schema.Calendar;
import net.sf.mpxj.planner.schema.Calendars;
import net.sf.mpxj.planner.schema.Constraint;
import net.sf.mpxj.planner.schema.DayType;
import net.sf.mpxj.planner.schema.DayTypes;
import net.sf.mpxj.planner.schema.Days;
import net.sf.mpxj.planner.schema.DefaultWeek;
import net.sf.mpxj.planner.schema.Interval;
import net.sf.mpxj.planner.schema.ObjectFactory;
import net.sf.mpxj.planner.schema.OverriddenDayType;
import net.sf.mpxj.planner.schema.OverriddenDayTypes;
import net.sf.mpxj.planner.schema.Predecessor;
import net.sf.mpxj.planner.schema.Predecessors;
import net.sf.mpxj.planner.schema.Project;
import net.sf.mpxj.planner.schema.Resources;
import net.sf.mpxj.planner.schema.Tasks;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.Sequence;
import net.sf.mpxj.writer.AbstractProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlannerWriter
extends AbstractProjectWriter {
    private String m_encoding;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private Project m_plannerProject;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private static Map<RelationType, String> RELATIONSHIP_TYPES = new HashMap<RelationType, String>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            try {
                this.m_projectFile = projectFile;
                if (CONTEXT == null) {
                    throw CONTEXT_EXCEPTION;
                }
                Marshaller marshaller = CONTEXT.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                if (this.m_encoding != null) {
                    marshaller.setProperty("jaxb.encoding", (Object)this.m_encoding);
                }
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.m_factory = new ObjectFactory();
                this.m_plannerProject = this.m_factory.createProject();
                this.writeProjectHeader();
                this.writeCalendars();
                this.writeResources();
                this.writeTasks();
                this.writeAssignments();
                marshaller.marshal((Object)this.m_plannerProject, outputStream);
            }
            catch (JAXBException jAXBException) {
                throw new IOException(jAXBException.toString());
            }
            Object var5_5 = null;
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_plannerProject = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_plannerProject = null;
            throw throwable;
        }
    }

    private void writeProjectHeader() {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        this.m_plannerProject.setCompany(projectHeader.getCompany());
        this.m_plannerProject.setManager(projectHeader.getManager());
        this.m_plannerProject.setName(this.getString(projectHeader.getName()));
        this.m_plannerProject.setProjectStart(this.getDateTime(projectHeader.getStartDate()));
        this.m_plannerProject.setCalendar(this.getIntegerString(this.m_projectFile.getCalendar().getUniqueID()));
        this.m_plannerProject.setMrprojectVersion("2");
    }

    private void writeCalendars() throws JAXBException {
        Calendars calendars = this.m_factory.createCalendars();
        this.m_plannerProject.setCalendars(calendars);
        this.writeDayTypes(calendars);
        List<Calendar> list = calendars.getCalendar();
        for (ProjectCalendar projectCalendar : this.m_projectFile.getBaseCalendars()) {
            Calendar calendar = this.m_factory.createCalendar();
            list.add(calendar);
            this.writeCalendar(projectCalendar, calendar);
        }
    }

    private void writeDayTypes(Calendars calendars) {
        DayTypes dayTypes = this.m_factory.createDayTypes();
        calendars.setDayTypes(dayTypes);
        List<DayType> list = dayTypes.getDayType();
        DayType dayType = this.m_factory.createDayType();
        list.add(dayType);
        dayType.setId("0");
        dayType.setName("Working");
        dayType.setDescription("A default working day");
        dayType = this.m_factory.createDayType();
        list.add(dayType);
        dayType.setId("1");
        dayType.setName("Nonworking");
        dayType.setDescription("A default non working day");
        dayType = this.m_factory.createDayType();
        list.add(dayType);
        dayType.setId("2");
        dayType.setName("Use base");
        dayType.setDescription("Use day from base calendar");
    }

    private void writeCalendar(ProjectCalendar projectCalendar, Calendar calendar) throws JAXBException {
        Object object;
        calendar.setId(this.getIntegerString(projectCalendar.getUniqueID()));
        calendar.setName(this.getString(projectCalendar.getName()));
        DefaultWeek defaultWeek = this.m_factory.createDefaultWeek();
        calendar.setDefaultWeek(defaultWeek);
        defaultWeek.setMon(this.getWorkingDayString(projectCalendar, Day.MONDAY));
        defaultWeek.setTue(this.getWorkingDayString(projectCalendar, Day.TUESDAY));
        defaultWeek.setWed(this.getWorkingDayString(projectCalendar, Day.WEDNESDAY));
        defaultWeek.setThu(this.getWorkingDayString(projectCalendar, Day.THURSDAY));
        defaultWeek.setFri(this.getWorkingDayString(projectCalendar, Day.FRIDAY));
        defaultWeek.setSat(this.getWorkingDayString(projectCalendar, Day.SATURDAY));
        defaultWeek.setSun(this.getWorkingDayString(projectCalendar, Day.SUNDAY));
        OverriddenDayTypes overriddenDayTypes = this.m_factory.createOverriddenDayTypes();
        calendar.setOverriddenDayTypes(overriddenDayTypes);
        List<OverriddenDayType> list = overriddenDayTypes.getOverriddenDayType();
        Sequence sequence = new Sequence(0);
        for (int i = 1; i < 8; ++i) {
            object = Day.getInstance(i);
            if (!projectCalendar.isWorkingDay((Day)object)) continue;
            this.processWorkingHours(projectCalendar, sequence, (Day)object, list);
            break;
        }
        Days days = this.m_factory.createDays();
        calendar.setDays(days);
        object = days.getDay();
        this.processExceptionDays(projectCalendar, (List<net.sf.mpxj.planner.schema.Day>)object);
        this.m_projectFile.fireCalendarWrittenEvent(projectCalendar);
        List<Calendar> list2 = calendar.getCalendar();
        for (ProjectCalendar projectCalendar2 : projectCalendar.getDerivedCalendars()) {
            Calendar calendar2 = this.m_factory.createCalendar();
            list2.add(calendar2);
            this.writeCalendar(projectCalendar2, calendar2);
        }
    }

    private void processWorkingHours(ProjectCalendar projectCalendar, Sequence sequence, Day day, List<OverriddenDayType> list) {
        ProjectCalendarHours projectCalendarHours;
        if (this.isWorkingDay(projectCalendar, day) && (projectCalendarHours = projectCalendar.getCalendarHours(day)) != null) {
            OverriddenDayType overriddenDayType = this.m_factory.createOverriddenDayType();
            list.add(overriddenDayType);
            overriddenDayType.setId(this.getIntegerString(sequence.next()));
            List<Interval> list2 = overriddenDayType.getInterval();
            for (DateRange dateRange : projectCalendarHours) {
                Date date = dateRange.getStart();
                Date date2 = dateRange.getEnd();
                if (date == null || date2 == null) continue;
                Interval interval = this.m_factory.createInterval();
                list2.add(interval);
                interval.setStart(this.getTimeString(date));
                interval.setEnd(this.getTimeString(date2));
            }
        }
    }

    private void processExceptionDays(ProjectCalendar projectCalendar, List<net.sf.mpxj.planner.schema.Day> list) {
        for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
            Object object;
            Date date = projectCalendarException.getFromDate();
            Date date2 = projectCalendarException.getToDate();
            if (DateUtility.getDayStartDate(date).getTime() == DateUtility.getDayEndDate(date2).getTime()) {
                object = this.m_factory.createDay();
                list.add((net.sf.mpxj.planner.schema.Day)object);
                ((net.sf.mpxj.planner.schema.Day)object).setType("day-type");
                ((net.sf.mpxj.planner.schema.Day)object).setDate(this.getDateString(projectCalendarException.getFromDate()));
                ((net.sf.mpxj.planner.schema.Day)object).setId(projectCalendarException.getWorking() ? "0" : "1");
                continue;
            }
            object = java.util.Calendar.getInstance();
            ((java.util.Calendar)object).setTime(date);
            while (((java.util.Calendar)object).getTime().getTime() < date2.getTime()) {
                net.sf.mpxj.planner.schema.Day day = this.m_factory.createDay();
                list.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(((java.util.Calendar)object).getTime()));
                day.setId(projectCalendarException.getWorking() ? "0" : "1");
                ((java.util.Calendar)object).add(6, 1);
            }
        }
    }

    private void writeResources() {
        Resources resources = this.m_factory.createResources();
        this.m_plannerProject.setResources(resources);
        List<net.sf.mpxj.planner.schema.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            net.sf.mpxj.planner.schema.Resource resource2 = this.m_factory.createResource();
            list.add(resource2);
            this.writeResource(resource, resource2);
        }
    }

    private void writeResource(Resource resource, net.sf.mpxj.planner.schema.Resource resource2) {
        ProjectCalendar projectCalendar = resource.getResourceCalendar();
        if (projectCalendar != null) {
            resource2.setCalendar(this.getIntegerString(projectCalendar.getUniqueID()));
        }
        resource2.setEmail(resource.getEmailAddress());
        resource2.setId(this.getIntegerString(resource.getUniqueID()));
        resource2.setName(this.getString(resource.getName()));
        resource2.setNote(resource.getNotes());
        resource2.setShortName(resource.getInitials());
        resource2.setType(resource.getType() == ResourceType.MATERIAL ? "2" : "1");
        resource2.setUnits("0");
    }

    private void writeTasks() throws JAXBException {
        Tasks tasks = this.m_factory.createTasks();
        this.m_plannerProject.setTasks(tasks);
        List<net.sf.mpxj.planner.schema.Task> list = tasks.getTask();
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task, list);
        }
    }

    private void writeTask(Task task, List<net.sf.mpxj.planner.schema.Task> list) throws JAXBException {
        Object object;
        net.sf.mpxj.planner.schema.Task task2 = this.m_factory.createTask();
        list.add(task2);
        task2.setEnd(this.getDateTimeString(task.getFinish()));
        task2.setId(this.getIntegerString(task.getUniqueID()));
        task2.setName(this.getString(task.getName()));
        task2.setNote(task.getNotes());
        task2.setPercentComplete(this.getIntegerString(task.getPercentageWorkComplete()));
        task2.setPriority(task.getPriority() == null ? null : this.getIntegerString(task.getPriority().getValue() * 10));
        task2.setScheduling(this.getScheduling(task.getType()));
        task2.setStart(this.getDateTimeString(DateUtility.getDayStartDate(task.getStart())));
        if (task.getMilestone()) {
            task2.setType("milestone");
        } else {
            task2.setType("normal");
        }
        task2.setWork(this.getDurationString(task.getWork()));
        task2.setWorkStart(this.getDateTimeString(task.getStart()));
        ConstraintType constraintType = task.getConstraintType();
        if (constraintType != ConstraintType.AS_SOON_AS_POSSIBLE) {
            object = this.m_factory.createConstraint();
            task2.setConstraint((Constraint)object);
            if (constraintType == ConstraintType.START_NO_EARLIER_THAN) {
                ((Constraint)object).setType("start-no-earlier-than");
            } else if (constraintType == ConstraintType.MUST_START_ON) {
                ((Constraint)object).setType("must-start-on");
            }
            ((Constraint)object).setTime(this.getDateTimeString(task.getConstraintDate()));
        }
        this.writePredecessors(task, task2);
        object = task2.getTask();
        for (Task task3 : task.getChildTasks()) {
            this.writeTask(task3, (List<net.sf.mpxj.planner.schema.Task>)object);
        }
    }

    private void writePredecessors(Task task, net.sf.mpxj.planner.schema.Task task2) {
        Predecessors predecessors = this.m_factory.createPredecessors();
        task2.setPredecessors(predecessors);
        List<Predecessor> list = predecessors.getPredecessor();
        int n = 0;
        List<Relation> list2 = task.getPredecessors();
        if (list2 != null) {
            for (Relation relation : list2) {
                Integer n2 = relation.getTargetTask().getUniqueID();
                Predecessor predecessor = this.m_factory.createPredecessor();
                predecessor.setId(this.getIntegerString(++n));
                predecessor.setPredecessorId(this.getIntegerString(n2));
                predecessor.setLag(this.getDurationString(relation.getLag()));
                predecessor.setType(RELATIONSHIP_TYPES.get(relation.getType()));
                list.add(predecessor);
                this.m_projectFile.fireRelationWrittenEvent(relation);
            }
        }
    }

    private void writeAssignments() {
        Allocations allocations = this.m_factory.createAllocations();
        this.m_plannerProject.setAllocations(allocations);
        List<Allocation> list = allocations.getAllocation();
        for (ResourceAssignment resourceAssignment : this.m_projectFile.getAllResourceAssignments()) {
            Allocation allocation = this.m_factory.createAllocation();
            list.add(allocation);
            allocation.setTaskId(this.getIntegerString(resourceAssignment.getTask().getUniqueID()));
            allocation.setResourceId(this.getIntegerString(resourceAssignment.getResourceUniqueID()));
            allocation.setUnits(this.getIntegerString(resourceAssignment.getUnits()));
            this.m_projectFile.fireAssignmentWrittenEvent(resourceAssignment);
        }
    }

    private String getDateTime(Date date) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (date != null) {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date);
            stringBuffer.append(this.m_fourDigitFormat.format(calendar.get(1)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(2) + 1));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(5)));
            stringBuffer.append("T");
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(11)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(12)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(13)));
            stringBuffer.append("Z");
        }
        return stringBuffer.toString();
    }

    private String getIntegerString(Number number) {
        return number == null ? null : Integer.toString(number.intValue());
    }

    private String getIntegerString(int n) {
        return Integer.toString(n);
    }

    private boolean isWorkingDay(ProjectCalendar projectCalendar, Day day) {
        boolean bl = false;
        switch (projectCalendar.getWorkingDay(day)) {
            case WORKING: {
                bl = true;
                break;
            }
            case NON_WORKING: {
                bl = false;
                break;
            }
            case DEFAULT: {
                bl = this.isWorkingDay(projectCalendar.getParent(), day);
            }
        }
        return bl;
    }

    private String getWorkingDayString(ProjectCalendar projectCalendar, Day day) {
        String string = null;
        switch (projectCalendar.getWorkingDay(day)) {
            case WORKING: {
                string = "0";
                break;
            }
            case NON_WORKING: {
                string = "1";
                break;
            }
            case DEFAULT: {
                string = "2";
            }
        }
        return string;
    }

    private String getTimeString(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        StringBuffer stringBuffer = new StringBuffer(4);
        stringBuffer.append(this.m_twoDigitFormat.format(n));
        stringBuffer.append(this.m_twoDigitFormat.format(n2));
        return stringBuffer.toString();
    }

    private String getDateString(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.m_fourDigitFormat.format(n));
        stringBuffer.append(this.m_twoDigitFormat.format(n2));
        stringBuffer.append(this.m_twoDigitFormat.format(n3));
        return stringBuffer.toString();
    }

    private String getDateTimeString(Date date) {
        String string = null;
        if (date != null) {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date);
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(this.m_fourDigitFormat.format(calendar.get(1)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(2) + 1));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(5)));
            stringBuffer.append('T');
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(11)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(12)));
            stringBuffer.append(this.m_twoDigitFormat.format(calendar.get(13)));
            stringBuffer.append('Z');
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getDurationString(Duration duration) {
        String string = null;
        if (duration != null) {
            double d = 0.0;
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    d = duration.getDuration() * 60.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    d = duration.getDuration() * 3600.0;
                    break;
                }
                case DAYS: {
                    double d2 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    d = duration.getDuration() * (d2 * 60.0);
                    break;
                }
                case ELAPSED_DAYS: {
                    d = duration.getDuration() * 86400.0;
                    break;
                }
                case WEEKS: {
                    double d3 = this.m_projectFile.getProjectHeader().getMinutesPerWeek().doubleValue();
                    d = duration.getDuration() * (d3 * 60.0);
                    break;
                }
                case ELAPSED_WEEKS: {
                    d = duration.getDuration() * 604800.0;
                    break;
                }
                case MONTHS: {
                    double d4 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double d5 = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (d5 * d4 * 60.0);
                    break;
                }
                case ELAPSED_MONTHS: {
                    d = duration.getDuration() * 2592000.0;
                    break;
                }
                case YEARS: {
                    double d6 = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double d7 = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (12.0 * d7 * d6 * 60.0);
                    break;
                }
                case ELAPSED_YEARS: {
                    d = duration.getDuration() * 3.1536E7;
                    break;
                }
            }
            string = Long.toString((long)d);
        }
        return string;
    }

    private String getScheduling(TaskType taskType) {
        String string = "fixed-work";
        if (taskType != null && taskType == TaskType.FIXED_DURATION) {
            string = "fixed-duration";
        }
        return string;
    }

    private String getString(String string) {
        return string == null ? "" : string;
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "FF");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "FS");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "SF");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "SS");
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.planner.schema", (ClassLoader)PlannerWriter.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

