/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Day;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryEntry;

public final class ProjectHeaderReader {
    public void process(ProjectFile projectFile, Props props, DirectoryEntry directoryEntry) throws MPXJException {
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        projectHeader.setStartDate(props.getTimestamp(Props.PROJECT_START_DATE));
        projectHeader.setFinishDate(props.getTimestamp(Props.PROJECT_FINISH_DATE));
        projectHeader.setScheduleFrom(ScheduleFrom.getInstance(1 - props.getShort(Props.SCHEDULE_FROM)));
        projectHeader.setCalendarName(props.getUnicodeString(Props.DEFAULT_CALENDAR_NAME));
        projectHeader.setDefaultStartTime(props.getTime(Props.START_TIME));
        projectHeader.setDefaultEndTime(props.getTime(Props.END_TIME));
        projectHeader.setStatusDate(props.getTimestamp(Props.STATUS_DATE));
        projectHeader.setHyperlinkBase(props.getUnicodeString(Props.HYPERLINK_BASE));
        projectHeader.setDefaultDurationUnits(MPPUtility.getDurationTimeUnits(props.getShort(Props.DURATION_UNITS)));
        projectHeader.setMinutesPerDay(props.getInt(Props.MINUTES_PER_DAY));
        projectHeader.setMinutesPerWeek(props.getInt(Props.MINUTES_PER_WEEK));
        projectHeader.setDefaultOvertimeRate(new Rate(props.getDouble(Props.OVERTIME_RATE), TimeUnit.HOURS));
        projectHeader.setDefaultStandardRate(new Rate(props.getDouble(Props.STANDARD_RATE), TimeUnit.HOURS));
        projectHeader.setDefaultWorkUnits(MPPUtility.getWorkTimeUnits(props.getShort(Props.WORK_UNITS)));
        projectHeader.setSplitInProgressTasks(props.getBoolean(Props.SPLIT_TASKS));
        projectHeader.setUpdatingTaskStatusUpdatesResourceStatus(props.getBoolean(Props.TASK_UPDATES_RESOURCE));
        projectHeader.setCurrencyDigits(props.getShort(Props.CURRENCY_DIGITS));
        projectHeader.setCurrencySymbol(props.getUnicodeString(Props.CURRENCY_SYMBOL));
        projectHeader.setCurrencyCode(props.getUnicodeString(Props.CURRENCY_CODE));
        projectHeader.setSymbolPosition(MPPUtility.getSymbolPosition(props.getShort(Props.CURRENCY_PLACEMENT)));
        projectHeader.setWeekStartDay(Day.getInstance(props.getShort(Props.WEEK_START_DAY) + 1));
        projectHeader.setFiscalYearStartMonth(props.getShort(Props.FISCAL_YEAR_START_MONTH));
        projectHeader.setFiscalYearStart(props.getShort(Props.FISCAL_YEAR_START) == 1);
        projectHeader.setDaysPerMonth(props.getShort(Props.DAYS_PER_MONTH));
        projectHeader.setEditableActualCosts(props.getBoolean(Props.EDITABLE_ACTUAL_COSTS));
        projectHeader.setHonorConstraints(!props.getBoolean(Props.HONOR_CONSTRAINTS));
        SummaryInformation summaryInformation = new SummaryInformation(directoryEntry);
        projectHeader.setProjectTitle(summaryInformation.getProjectTitle());
        projectHeader.setSubject(summaryInformation.getSubject());
        projectHeader.setAuthor(summaryInformation.getAuthor());
        projectHeader.setKeywords(summaryInformation.getKeywords());
        projectHeader.setComments(summaryInformation.getComments());
        projectHeader.setCompany(summaryInformation.getCompany());
        projectHeader.setManager(summaryInformation.getManager());
        projectHeader.setCategory(summaryInformation.getCategory());
        projectHeader.setRevision(summaryInformation.getRevision());
        projectHeader.setCreationDate(summaryInformation.getCreationDate());
        projectHeader.setLastSaved(summaryInformation.getLastSaved());
        projectHeader.setDocumentSummaryInformation(summaryInformation.getDocumentSummaryInformation());
        projectHeader.setCalculateMultipleCriticalPaths(props.getBoolean(Props.CALCULATE_MULTIPLE_CRITICAL_PATHS));
        projectHeader.setBaselineDate(0, props.getTimestamp(Props.BASELINE_DATE));
        projectHeader.setBaselineDate(1, props.getTimestamp(Props.BASELINE1_DATE));
        projectHeader.setBaselineDate(2, props.getTimestamp(Props.BASELINE2_DATE));
        projectHeader.setBaselineDate(3, props.getTimestamp(Props.BASELINE3_DATE));
        projectHeader.setBaselineDate(4, props.getTimestamp(Props.BASELINE4_DATE));
        projectHeader.setBaselineDate(5, props.getTimestamp(Props.BASELINE5_DATE));
        projectHeader.setBaselineDate(6, props.getTimestamp(Props.BASELINE6_DATE));
        projectHeader.setBaselineDate(7, props.getTimestamp(Props.BASELINE7_DATE));
        projectHeader.setBaselineDate(8, props.getTimestamp(Props.BASELINE8_DATE));
        projectHeader.setBaselineDate(9, props.getTimestamp(Props.BASELINE9_DATE));
        projectHeader.setBaselineDate(10, props.getTimestamp(Props.BASELINE10_DATE));
    }
}

